/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.statistics;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.eventhandlers.RrdLoggingEventHandler;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.statistics.AbstractGraphImageProducer;
import java.awt.Color;
import java.awt.Paint;
import org.rrd4j.ConsolFun;
import org.rrd4j.graph.RrdGraphDef;

public class SevenDaysProducer
extends AbstractGraphImageProducer {
    public SevenDaysProducer(MainFrame mainFrame) {
        super(mainFrame);
    }

    public RrdGraphDef getGraphDef(long nowInSeconds, SourceIdentifier sourceIdentifier, boolean showMax) {
        String description;
        ConsolFun consolFun;
        String absoluteRrdPath = this.getRrdFile(sourceIdentifier).getAbsolutePath();
        RrdGraphDef graphDef = new RrdGraphDef();
        graphDef.setColor(0, (Paint)new Color(204, 204, 204));
        graphDef.setNoMinorGrid(true);
        graphDef.setShowSignature(false);
        graphDef.setMinValue(0.0);
        graphDef.setAltAutoscaleMax(true);
        graphDef.setAltYGrid(false);
        graphDef.setTimeAxis(11, 1, 11, 6, 5, 1, 0, "yyyy-MM-dd");
        graphDef.setFilename("-");
        graphDef.setImageFormat("PNG");
        if (showMax) {
            consolFun = ConsolFun.MAX;
            description = " (max.)";
        } else {
            consolFun = ConsolFun.AVERAGE;
            description = " (avg.)";
        }
        graphDef.setVerticalLabel("Events/s" + description);
        graphDef.datasource(RrdLoggingEventHandler.TRACE, absoluteRrdPath, RrdLoggingEventHandler.TRACE_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventHandler.DEBUG, absoluteRrdPath, RrdLoggingEventHandler.DEBUG_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventHandler.INFO, absoluteRrdPath, RrdLoggingEventHandler.INFO_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventHandler.WARN, absoluteRrdPath, RrdLoggingEventHandler.WARN_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventHandler.ERROR, absoluteRrdPath, RrdLoggingEventHandler.ERROR_DS_NAME, consolFun);
        graphDef.area(RrdLoggingEventHandler.TRACE, (Paint)new Color(0, 0, 255), RrdLoggingEventHandler.TRACE);
        graphDef.stack(RrdLoggingEventHandler.DEBUG, (Paint)new Color(0, 255, 0), RrdLoggingEventHandler.DEBUG);
        graphDef.stack(RrdLoggingEventHandler.INFO, (Paint)new Color(255, 255, 255), RrdLoggingEventHandler.INFO);
        graphDef.stack(RrdLoggingEventHandler.WARN, (Paint)new Color(255, 255, 0), RrdLoggingEventHandler.WARN);
        graphDef.stack(RrdLoggingEventHandler.ERROR, (Paint)new Color(255, 0, 0), RrdLoggingEventHandler.ERROR);
        if (showMax) {
            graphDef.datasource("TOTAL", absoluteRrdPath, "TOTAL!", consolFun);
            graphDef.line("TOTAL", (Paint)Color.BLACK, "TOTAL");
        }
        graphDef.setAntiAliasing(true);
        graphDef.setLazy(false);
        String sourceTitle = this.createGraphTitle(sourceIdentifier);
        long before = nowInSeconds - 604800L;
        graphDef.setTimeSpan(before, nowInSeconds);
        graphDef.setTitle(sourceTitle);
        graphDef.setWidth(this.graphSize.width);
        graphDef.setHeight(this.graphSize.height);
        return graphDef;
    }
}

