/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences.table;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.preferences.table.ColorSchemePreviewRenderer;
import de.huxhorn.lilith.swing.table.ColorScheme;
import java.util.Map;
import javax.swing.JTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingLevelPreviewRenderer
extends ColorSchemePreviewRenderer {
    private final Logger logger = LoggerFactory.getLogger(LoggingLevelPreviewRenderer.class);
    private Map<LoggingEvent.Level, ColorScheme> schemes;

    public Map<LoggingEvent.Level, ColorScheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(Map<LoggingEvent.Level, ColorScheme> schemes) {
        this.schemes = schemes;
    }

    @Override
    public ColorScheme resolveColorScheme(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ColorScheme result = null;
        if (value instanceof LoggingEvent.Level) {
            LoggingEvent.Level level = (LoggingEvent.Level)value;
            if (this.schemes == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("No color schemes defined for logging levels!");
                }
            } else {
                result = this.schemes.get(level);
            }
        }
        return result;
    }

    @Override
    public void updateText(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        String text = "";
        String toolTip = "";
        if (value instanceof LoggingEvent.Level) {
            LoggingEvent.Level level = (LoggingEvent.Level)value;
            text = level.name();
            toolTip = level.name();
        }
        this.renderer.setText(text);
        this.renderer.setToolTipText(toolTip);
    }
}

