/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences.table;

import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.sulky.io.IOUtilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessStatusTypeTableModel
implements TableModel {
    private final Logger logger = LoggerFactory.getLogger(AccessStatusTypeTableModel.class);
    public static final int LEVEL_COLUMN = 0;
    private List<HttpStatus.Type> data;
    private final EventListenerList eventListenerList = new EventListenerList();

    public AccessStatusTypeTableModel() {
        HttpStatus.Type[] values = HttpStatus.Type.values();
        this.data = Collections.unmodifiableList(Arrays.asList(values));
    }

    public List<HttpStatus.Type> getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Condition";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return LoggingEvent.Level.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data == null || columnIndex > 0 || rowIndex < 0 || rowIndex >= this.data.size()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void refresh() {
        this.fireTableChange(new TableModelEvent(this));
    }

    private void fireTableChange(TableModelEvent evt) {
        FireTableChangeRunnable r = new FireTableChangeRunnable(evt);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.add(TableModelListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.remove(TableModelListener.class, l);
        }
    }

    private class FireTableChangeRunnable
    implements Runnable {
        private TableModelEvent event;

        public FireTableChangeRunnable(TableModelEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] listeners;
            EventListenerList eventListenerList = AccessStatusTypeTableModel.this.eventListenerList;
            synchronized (eventListenerList) {
                listeners = AccessStatusTypeTableModel.this.eventListenerList.getListenerList();
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                TableModelListener listener = (TableModelListener)listeners[i + 1];
                if (AccessStatusTypeTableModel.this.logger.isDebugEnabled()) {
                    AccessStatusTypeTableModel.this.logger.debug("Firing TableChange at {}.", (Object)listener.getClass().getName());
                }
                try {
                    listener.tableChanged(this.event);
                    continue;
                }
                catch (Throwable ex) {
                    if (AccessStatusTypeTableModel.this.logger.isWarnEnabled()) {
                        AccessStatusTypeTableModel.this.logger.warn("Exception while firing change!", ex);
                    }
                    IOUtilities.interruptIfNecessary((Throwable)ex);
                }
            }
        }
    }
}

