/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class WindowsPanel
extends JPanel {
    private ApplicationPreferences applicationPreferences;
    private JCheckBox showingToolbarCheckbox;
    private JCheckBox showingStatusbarCheckbox;
    private JCheckBox internalFramesCheckbox;
    private JCheckBox maximizeInternalFramesCheckbox;
    private JCheckBox autoOpenCheckbox;
    private JCheckBox autoFocusCheckbox;
    private JCheckBox autoCloseCheckbox;
    private JCheckBox showIdentifierCheckbox;

    public WindowsPanel(PreferencesDialog preferencesDialog) {
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.showingToolbarCheckbox = new JCheckBox("Show toolbar.");
        this.showingStatusbarCheckbox = new JCheckBox("Show statusbar.");
        this.internalFramesCheckbox = new JCheckBox("Use internal frames.");
        this.maximizeInternalFramesCheckbox = new JCheckBox("Maximize internal frames.");
        this.showIdentifierCheckbox = new JCheckBox("Show identifier for named sources.");
        this.autoOpenCheckbox = new JCheckBox("Automatically open new views on connection.");
        this.autoCloseCheckbox = new JCheckBox("Automatically close inactive views on disconnection.");
        this.autoFocusCheckbox = new JCheckBox("Automatically focus window of new view.");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.showingToolbarCheckbox, gbc);
        ++gbc.gridy;
        this.add((Component)this.showingStatusbarCheckbox, gbc);
        ++gbc.gridy;
        this.add((Component)this.internalFramesCheckbox, gbc);
        ++gbc.gridy;
        this.add((Component)this.maximizeInternalFramesCheckbox, gbc);
        ++gbc.gridy;
        this.add((Component)this.autoOpenCheckbox, gbc);
        ++gbc.gridy;
        this.add((Component)this.autoFocusCheckbox, gbc);
        ++gbc.gridy;
        this.add((Component)this.autoCloseCheckbox, gbc);
        gbc.weighty = 1.0;
        ++gbc.gridy;
        this.add((Component)this.showIdentifierCheckbox, gbc);
    }

    public void initUI() {
        this.showingToolbarCheckbox.setSelected(this.applicationPreferences.isShowingToolbar());
        this.showingStatusbarCheckbox.setSelected(this.applicationPreferences.isShowingStatusbar());
        this.internalFramesCheckbox.setSelected(this.applicationPreferences.isUsingInternalFrames());
        this.maximizeInternalFramesCheckbox.setSelected(this.applicationPreferences.isMaximizingInternalFrames());
        this.autoOpenCheckbox.setSelected(this.applicationPreferences.isAutoOpening());
        this.autoFocusCheckbox.setSelected(this.applicationPreferences.isAutoFocusingWindow());
        this.autoCloseCheckbox.setSelected(this.applicationPreferences.isAutoClosing());
        this.showIdentifierCheckbox.setSelected(this.applicationPreferences.isShowingIdentifier());
    }

    public void saveSettings() {
        this.applicationPreferences.setShowingToolbar(this.showingToolbarCheckbox.isSelected());
        this.applicationPreferences.setShowingStatusbar(this.showingStatusbarCheckbox.isSelected());
        this.applicationPreferences.setUsingInternalFrames(this.internalFramesCheckbox.isSelected());
        this.applicationPreferences.setMaximizingInternalFrames(this.maximizeInternalFramesCheckbox.isSelected());
        this.applicationPreferences.setAutoOpening(this.autoOpenCheckbox.isSelected());
        this.applicationPreferences.setAutoFocusingWindow(this.autoFocusCheckbox.isSelected());
        this.applicationPreferences.setAutoClosing(this.autoCloseCheckbox.isSelected());
        this.applicationPreferences.setShowingIdentifier(this.showIdentifierCheckbox.isSelected());
    }
}

