/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.TextPreprocessor;
import de.huxhorn.lilith.swing.preferences.EditConditionDialog;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.preferences.table.ConditionTableColumnModel;
import de.huxhorn.lilith.swing.preferences.table.ConditionTableModel;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.swing.Windows;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionsPanel
extends JPanel {
    private static final long serialVersionUID = -2757940105037104853L;
    private final Logger logger = LoggerFactory.getLogger(ConditionsPanel.class);
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private EditConditionDialog editConditionDialog;
    private List<SavedCondition> conditions;
    private JTable conditionTable;
    private ConditionTableModel conditionTableModel;
    private EditConditionAction editConditionAction;
    private RemoveConditionAction removeConditionAction;
    private JTextArea conditionTextArea;
    private MoveUpAction moveUpAction;
    private MoveDownAction moveDownAction;

    public ConditionsPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.editConditionDialog = new EditConditionDialog(this.preferencesDialog);
        this.conditionTableModel = new ConditionTableModel(null);
        this.conditionTable = new JTable(this.conditionTableModel);
        this.conditionTable.addMouseListener(new ConditionTableMouseListener());
        this.conditionTable.setColumnModel(new ConditionTableColumnModel());
        this.conditionTextArea = new JTextArea();
        this.conditionTextArea.setEditable(false);
        JScrollPane tableScrollPane = new JScrollPane(this.conditionTable);
        JScrollPane descriptionScrollPane = new JScrollPane(this.conditionTextArea);
        descriptionScrollPane.setBorder(new TitledBorder(new EtchedBorder(1), "Details"));
        JPanel conditionsPanel = new JPanel(new GridLayout(2, 1));
        conditionsPanel.add(tableScrollPane);
        conditionsPanel.add(descriptionScrollPane);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        ListSelectionModel sourceNameRowSelectionModel = this.conditionTable.getSelectionModel();
        sourceNameRowSelectionModel.setSelectionMode(0);
        sourceNameRowSelectionModel.addListSelectionListener(new ConditionTableRowSelectionListener());
        this.editConditionAction = new EditConditionAction();
        this.removeConditionAction = new RemoveConditionAction();
        this.moveUpAction = new MoveUpAction();
        this.moveDownAction = new MoveDownAction();
        JButton editConditionButton = new JButton(this.editConditionAction);
        JButton removeConditionButton = new JButton(this.removeConditionAction);
        JButton moveUpButton = new JButton(this.moveUpAction);
        JButton moveDownButton = new JButton(this.moveDownAction);
        toolBar.add(editConditionButton);
        toolBar.add(removeConditionButton);
        toolBar.add(moveUpButton);
        toolBar.add(moveDownButton);
        this.add((Component)toolBar, "North");
        this.add((Component)conditionsPanel, "Center");
    }

    public void initUI() {
        this.conditions = this.applicationPreferences.getConditions();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Conditions retrieved: {}", this.conditions);
        }
        this.conditionTableModel.setData(this.conditions);
        this.updateConditions();
    }

    public void updateConditions() {
        int selectedRow = this.conditionTable.getSelectedRow();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("selectedRow={}", (Object)selectedRow);
        }
        SavedCondition condition = null;
        int conditionCount = this.conditions.size();
        if (selectedRow > -1 && selectedRow < conditionCount) {
            condition = this.conditions.get(selectedRow);
        }
        this.editConditionAction.setEnabled(condition != null);
        this.removeConditionAction.setEnabled(condition != null);
        this.moveUpAction.setEnabled(selectedRow > 0);
        this.moveDownAction.setEnabled(selectedRow > -1 && selectedRow < conditionCount - 1);
        String description = "";
        if (condition != null) {
            description = TextPreprocessor.formatCondition(condition.getCondition());
        }
        this.conditionTextArea.setText(description);
    }

    public void saveSettings() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Setting conditions to {}.", this.conditions);
        }
        this.applicationPreferences.setConditions(this.conditions);
    }

    public void editCondition(Condition condition) {
        block13: {
            int conditionIndex;
            boolean done;
            boolean adding;
            SavedCondition savedCondition;
            block12: {
                savedCondition = null;
                for (SavedCondition current : this.conditions) {
                    if (!condition.equals(current.getCondition())) continue;
                    savedCondition = current;
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("Found saved condition {}.", (Object)savedCondition);
                    break;
                }
                adding = false;
                if (savedCondition == null) {
                    adding = true;
                    savedCondition = new SavedCondition(condition);
                }
                try {
                    savedCondition = savedCondition.clone();
                }
                catch (CloneNotSupportedException e) {
                    if (!this.logger.isErrorEnabled()) break block12;
                    this.logger.error("Couldn't clone saved condition!", (Throwable)e);
                }
            }
            this.editConditionDialog.setSavedCondition(savedCondition);
            this.editConditionDialog.setAdding(adding);
            do {
                Windows.showWindow((Window)this.editConditionDialog, (Window)this.preferencesDialog, (boolean)true);
                if (this.editConditionDialog.isCanceled()) break block13;
                SavedCondition newCondition = this.editConditionDialog.getSavedCondition();
                String newName = newCondition.getName();
                Condition containedCondition = newCondition.getCondition();
                conditionIndex = -1;
                int nameIndex = -1;
                for (int i = 0; i < this.conditions.size(); ++i) {
                    if (containedCondition.equals(this.conditions.get(i).getCondition())) {
                        conditionIndex = i;
                    }
                    if (!newName.equals(this.conditions.get(i).getName())) continue;
                    nameIndex = i;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("conditionIndex={}, nameIndex={}", (Object)conditionIndex, (Object)nameIndex);
                }
                done = false;
                if (nameIndex >= 0 && nameIndex != conditionIndex) {
                    String message = "A different confition with the same name does already exist!\nOverwrite that condition?";
                    String dialogTitle = "Duplicate condition name!";
                    int result = JOptionPane.showConfirmDialog(this, message, dialogTitle, 2, 3);
                    if (0 != result) continue;
                    this.conditionTableModel.set(nameIndex, savedCondition);
                    if (conditionIndex >= 0) {
                        this.conditionTableModel.remove(conditionIndex);
                        if (conditionIndex < nameIndex) {
                            --nameIndex;
                        }
                    }
                    conditionIndex = nameIndex;
                    done = true;
                    continue;
                }
                if (conditionIndex < 0) {
                    conditionIndex = this.conditionTableModel.add(savedCondition);
                    done = true;
                    continue;
                }
                this.conditionTableModel.set(conditionIndex, savedCondition);
                done = true;
            } while (!done);
            this.conditionTable.setRowSelectionInterval(conditionIndex, conditionIndex);
            this.updateConditions();
        }
    }

    private class ConditionTableMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            } else if (evt.getButton() == 1) {
                Point p = evt.getPoint();
                int row = ConditionsPanel.this.conditionTable.rowAtPoint(p);
                int col = ConditionsPanel.this.conditionTable.columnAtPoint(p);
                if (row >= 0 && row < ConditionsPanel.this.conditions.size()) {
                    if (col == 3) {
                        SavedCondition condition;
                        condition.setActive(!(condition = (SavedCondition)ConditionsPanel.this.conditions.get(row)).isActive());
                        ConditionsPanel.this.conditionTableModel.set(row, condition);
                    } else if (evt.getClickCount() >= 2) {
                        SavedCondition condition = (SavedCondition)ConditionsPanel.this.conditions.get(row);
                        ConditionsPanel.this.editCondition(condition.getCondition());
                    }
                }
            }
        }

        private void showPopup(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1115999498183305487L;

        public MoveDownAction() {
            super("Move down");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-down.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Move the selected Condition down.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (ConditionsPanel.this.logger.isDebugEnabled()) {
                ConditionsPanel.this.logger.debug("MoveDown");
            }
            if ((row = ConditionsPanel.this.conditionTable.getSelectedRow()) >= 0) {
                int newRow = ConditionsPanel.this.conditionTableModel.moveDown(row);
                if (newRow >= 0) {
                    ConditionsPanel.this.conditionTable.setRowSelectionInterval(newRow, newRow);
                }
                ConditionsPanel.this.updateConditions();
            }
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -5414336722079117405L;

        public MoveUpAction() {
            super("Move up");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-up.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Move the selected Condition up.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (ConditionsPanel.this.logger.isDebugEnabled()) {
                ConditionsPanel.this.logger.debug("MoveUp");
            }
            if ((row = ConditionsPanel.this.conditionTable.getSelectedRow()) >= 0) {
                int newRow = ConditionsPanel.this.conditionTableModel.moveUp(row);
                if (newRow >= 0) {
                    ConditionsPanel.this.conditionTable.setRowSelectionInterval(newRow, newRow);
                }
                ConditionsPanel.this.updateConditions();
            }
        }
    }

    private class RemoveConditionAction
    extends AbstractAction {
        private static final long serialVersionUID = 4573645407508010450L;

        public RemoveConditionAction() {
            super("Remove");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-remove.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Remove the selected Condition.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (ConditionsPanel.this.logger.isDebugEnabled()) {
                ConditionsPanel.this.logger.debug("Remove");
            }
            if ((row = ConditionsPanel.this.conditionTable.getSelectedRow()) >= 0) {
                ConditionsPanel.this.conditionTableModel.remove(row);
                int rowCount = ConditionsPanel.this.conditionTableModel.getRowCount();
                if (row >= rowCount) {
                    row = rowCount > 0 ? rowCount - 1 : -1;
                }
                if (row >= 0) {
                    ConditionsPanel.this.conditionTable.setRowSelectionInterval(row, row);
                }
                ConditionsPanel.this.updateConditions();
            }
        }
    }

    private class EditConditionAction
    extends AbstractAction {
        private static final long serialVersionUID = 95425194239658313L;

        public EditConditionAction() {
            super("Edit");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Edit a Condition.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (ConditionsPanel.this.logger.isDebugEnabled()) {
                ConditionsPanel.this.logger.debug("Edit");
            }
            if ((row = ConditionsPanel.this.conditionTable.getSelectedRow()) >= 0 && row < ConditionsPanel.this.conditions.size()) {
                SavedCondition condition = (SavedCondition)ConditionsPanel.this.conditions.get(row);
                ConditionsPanel.this.editCondition(condition.getCondition());
                ConditionsPanel.this.updateConditions();
            }
        }
    }

    private class ConditionTableRowSelectionListener
    implements ListSelectionListener {
        private ConditionTableRowSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ConditionsPanel.this.updateConditions();
        }
    }
}

