/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorChooserPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(ColorChooserPanel.class);
    private JColorChooser colorChooser;
    private JCheckBox inheritCheckbox;
    private Color defaultColor;

    public ColorChooserPanel(Color defaultColor) {
        this.defaultColor = defaultColor;
        this.createUI();
    }

    private void createUI() {
        JPanel emptyPreview = new JPanel();
        emptyPreview.setMinimumSize(new Dimension(0, 0));
        emptyPreview.setPreferredSize(new Dimension(0, 0));
        emptyPreview.setMaximumSize(new Dimension(0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        this.inheritCheckbox = new JCheckBox("Inherit");
        this.inheritCheckbox.setToolTipText("Select if color is undefined and will be derived from default or other condition.");
        this.inheritCheckbox.setSelected(false);
        this.inheritCheckbox.setMnemonic(73);
        this.inheritCheckbox.setVerticalAlignment(1);
        this.inheritCheckbox.setHorizontalAlignment(2);
        this.inheritCheckbox.addActionListener(new InheritListener());
        this.add((Component)this.inheritCheckbox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(emptyPreview);
        this.add((Component)this.colorChooser, gbc);
    }

    public JColorChooser getColorChooser() {
        return this.colorChooser;
    }

    public void setColor(Color color) {
        if (color == null) {
            this.inheritCheckbox.setSelected(true);
        } else {
            this.inheritCheckbox.setSelected(false);
            this.colorChooser.setColor(color);
        }
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("updateComponents...");
        }
        if (this.inheritCheckbox.isSelected()) {
            this.colorChooser.setColor(this.defaultColor);
            this.colorChooser.setVisible(false);
        } else {
            this.colorChooser.setVisible(true);
        }
    }

    public Color getColor() {
        return this.getColor(false);
    }

    public Color getColor(boolean returnDefault) {
        if (!this.inheritCheckbox.isSelected()) {
            return this.colorChooser.getColor();
        }
        if (returnDefault) {
            return this.defaultColor;
        }
        return null;
    }

    private class InheritListener
    implements ActionListener {
        private InheritListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColorChooserPanel.this.updateComponents();
        }
    }
}

