/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusSavedConditionAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusSavedConditionsMenu
extends JMenu
implements ViewContainerRelated {
    private static final long serialVersionUID = 5642118791633046024L;
    private final ApplicationPreferences applicationPreferences;
    private List<FilterAction> savedConditionActions;
    private ViewContainer viewContainer;

    public FocusSavedConditionsMenu(ApplicationPreferences applicationPreferences) {
        super("Saved conditions");
        this.applicationPreferences = applicationPreferences;
        this.setViewContainer(null);
        this.setConditionNames(applicationPreferences.getConditionNames());
    }

    @Override
    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void setConditionNames(List<String> conditionNames) {
        this.removeAll();
        if (conditionNames == null) {
            this.savedConditionActions = null;
        } else {
            conditionNames = new ArrayList<String>(conditionNames);
            Collections.sort(conditionNames, String.CASE_INSENSITIVE_ORDER);
            this.savedConditionActions = new ArrayList<FilterAction>(conditionNames.size());
            for (String current : conditionNames) {
                SavedCondition savedCondition = this.applicationPreferences.resolveSavedCondition(current);
                if (savedCondition == null || savedCondition.getCondition() == null) continue;
                this.savedConditionActions.add(this.createAction(this.viewContainer, savedCondition));
            }
        }
        this.updateState();
    }

    private void updateState() {
        if (this.viewContainer == null || this.savedConditionActions == null || this.savedConditionActions.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        for (FilterAction current : this.savedConditionActions) {
            current.setViewContainer(this.viewContainer);
        }
        if (this.getMenuComponentCount() == 0) {
            for (FilterAction current : this.savedConditionActions) {
                this.add(current);
            }
        }
        this.setEnabled(true);
    }

    protected FilterAction createAction(ViewContainer viewContainer, SavedCondition savedCondition) {
        return new FocusSavedConditionAction(viewContainer, savedCondition);
    }
}

