/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.AbstractAccessFilterAction;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.lilith.swing.actions.EventWrapperRelated;
import de.huxhorn.lilith.swing.actions.FocusCallLocationAction;
import de.huxhorn.lilith.swing.actions.FocusFormattedMessageAction;
import de.huxhorn.lilith.swing.actions.FocusHttpMethodAction;
import de.huxhorn.lilith.swing.actions.FocusHttpRemoteUserAction;
import de.huxhorn.lilith.swing.actions.FocusHttpRequestUriAction;
import de.huxhorn.lilith.swing.actions.FocusHttpRequestUrlAction;
import de.huxhorn.lilith.swing.actions.FocusHttpStatusCodeAction;
import de.huxhorn.lilith.swing.actions.FocusMessagePatternAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import de.huxhorn.lilith.swing.menu.FocusHttpStatusTypeMenu;
import de.huxhorn.lilith.swing.menu.FocusLevelMenu;
import de.huxhorn.lilith.swing.menu.FocusLoggerMenu;
import de.huxhorn.lilith.swing.menu.FocusMDCMenu;
import de.huxhorn.lilith.swing.menu.FocusMarkerMenu;
import de.huxhorn.lilith.swing.menu.FocusNDCMenu;
import de.huxhorn.lilith.swing.menu.FocusSavedConditionsMenu;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusMenu
extends JMenu
implements ViewContainerRelated,
EventWrapperRelated {
    private static final long serialVersionUID = 2301518754828320721L;
    private final ApplicationPreferences applicationPreferences;
    private EventWrapper eventWrapper;
    private FocusSavedConditionsMenu savedMenu;
    private FocusMessagePatternAction messagePatternAction;
    private JMenuItem messagePatternItem;
    private FocusFormattedMessageAction formattedMessageAction;
    private JMenuItem formattedMessageItem;
    private FocusCallLocationAction callLocationAction;
    private JMenuItem callLocationItem;
    private FocusMDCMenu mdcMenu;
    private FocusMarkerMenu markerMenu;
    private FocusNDCMenu ndcMenu;
    private FocusLoggerMenu loggerMenu;
    private FocusLevelMenu levelMenu;
    private FocusHttpStatusCodeAction statusCodeAction;
    private JMenuItem statusCodeItem;
    private FocusHttpStatusTypeMenu statusTypeMenu;
    private FocusHttpMethodAction methodAction;
    private JMenuItem methodItem;
    private FocusHttpRequestUriAction requestUriAction;
    private JMenuItem requestUriItem;
    private FocusHttpRequestUrlAction requestUrlAction;
    private JMenuItem requestUrlItem;
    private FocusHttpRemoteUserAction remoteUserAction;
    private JMenuItem remoteUserItem;
    private ViewContainer viewContainer;

    public FocusMenu(ApplicationPreferences applicationPreferences) {
        super("Focus");
        this.applicationPreferences = applicationPreferences;
        this.createUI();
        this.setViewContainer(null);
        this.setEventWrapper(null);
    }

    private void createUI() {
        this.savedMenu = new FocusSavedConditionsMenu(this.applicationPreferences);
        this.messagePatternAction = new FocusMessagePatternAction();
        this.formattedMessageAction = new FocusFormattedMessageAction();
        this.callLocationAction = new FocusCallLocationAction();
        this.messagePatternItem = new JMenuItem(this.messagePatternAction);
        this.formattedMessageItem = new JMenuItem(this.formattedMessageAction);
        this.callLocationItem = new JMenuItem(this.callLocationAction);
        this.mdcMenu = new FocusMDCMenu();
        this.markerMenu = new FocusMarkerMenu();
        this.ndcMenu = new FocusNDCMenu();
        this.loggerMenu = new FocusLoggerMenu();
        this.levelMenu = new FocusLevelMenu();
        this.statusCodeAction = new FocusHttpStatusCodeAction();
        this.statusCodeItem = new JMenuItem(this.statusCodeAction);
        this.statusTypeMenu = new FocusHttpStatusTypeMenu();
        this.methodAction = new FocusHttpMethodAction();
        this.methodItem = new JMenuItem(this.methodAction);
        this.requestUriAction = new FocusHttpRequestUriAction();
        this.requestUriItem = new JMenuItem(this.requestUriAction);
        this.requestUrlAction = new FocusHttpRequestUrlAction();
        this.requestUrlItem = new JMenuItem(this.requestUrlAction);
        this.remoteUserAction = new FocusHttpRemoteUserAction();
        this.remoteUserItem = new JMenuItem(this.remoteUserAction);
    }

    @Override
    public void setEventWrapper(EventWrapper eventWrapper) {
        this.eventWrapper = eventWrapper;
        this.messagePatternAction.setEventWrapper(eventWrapper);
        this.formattedMessageAction.setEventWrapper(eventWrapper);
        this.callLocationAction.setEventWrapper(eventWrapper);
        this.mdcMenu.setEventWrapper(eventWrapper);
        this.markerMenu.setEventWrapper(eventWrapper);
        this.ndcMenu.setEventWrapper(eventWrapper);
        this.loggerMenu.setEventWrapper(eventWrapper);
        this.statusCodeAction.setEventWrapper(eventWrapper);
        this.methodAction.setEventWrapper(eventWrapper);
        this.requestUriAction.setEventWrapper(eventWrapper);
        this.requestUrlAction.setEventWrapper(eventWrapper);
        this.remoteUserAction.setEventWrapper(eventWrapper);
        this.updateState();
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    @Override
    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.savedMenu.setViewContainer(viewContainer);
        this.messagePatternAction.setViewContainer(viewContainer);
        this.formattedMessageAction.setViewContainer(viewContainer);
        this.callLocationAction.setViewContainer(viewContainer);
        this.mdcMenu.setViewContainer(viewContainer);
        this.markerMenu.setViewContainer(viewContainer);
        this.ndcMenu.setViewContainer(viewContainer);
        this.loggerMenu.setViewContainer(viewContainer);
        this.levelMenu.setViewContainer(viewContainer);
        this.statusCodeAction.setViewContainer(viewContainer);
        this.statusTypeMenu.setViewContainer(viewContainer);
        this.methodAction.setViewContainer(viewContainer);
        this.requestUriAction.setViewContainer(viewContainer);
        this.requestUrlAction.setViewContainer(viewContainer);
        this.remoteUserAction.setViewContainer(viewContainer);
        this.updateState();
    }

    private void updateState() {
        EventWrapper wrapper = this.eventWrapper;
        this.removeAll();
        LoggingEvent loggingEvent = AbstractLoggingFilterAction.resolveLoggingEvent(wrapper);
        if (loggingEvent != null) {
            this.add(this.savedMenu);
            this.addSeparator();
            this.add(this.messagePatternItem);
            this.add(this.formattedMessageItem);
            this.addSeparator();
            this.add(this.levelMenu);
            this.addSeparator();
            this.add(this.callLocationItem);
            this.addSeparator();
            this.add(this.mdcMenu);
            this.add(this.markerMenu);
            this.add(this.ndcMenu);
            this.addSeparator();
            this.add(this.loggerMenu);
            this.setEnabled(true);
            return;
        }
        AccessEvent accessEvent = AbstractAccessFilterAction.resolveAccessEvent(this.eventWrapper);
        if (accessEvent != null) {
            this.add(this.savedMenu);
            this.addSeparator();
            this.add(this.statusCodeItem);
            this.add(this.statusTypeMenu);
            this.addSeparator();
            this.add(this.methodItem);
            this.addSeparator();
            this.add(this.requestUriItem);
            this.add(this.requestUrlItem);
            this.addSeparator();
            this.add(this.remoteUserItem);
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void setConditionNames(List<String> conditionNames) {
        this.savedMenu.setConditionNames(conditionNames);
    }
}

