/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.lilith.swing.actions.EventWrapperRelated;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusMarkerAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JMenu;

public class FocusMarkerMenu
extends JMenu
implements ViewContainerRelated,
EventWrapperRelated {
    private static final long serialVersionUID = -6549986627607364431L;
    private ViewContainer viewContainer;
    private Marker marker;

    public FocusMarkerMenu() {
        super("Marker");
        this.setViewContainer(null);
        this.setEventWrapper(null);
    }

    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void setEventWrapper(EventWrapper eventWrapper) {
        LoggingEvent loggingEvent = AbstractLoggingFilterAction.resolveLoggingEvent(eventWrapper);
        Marker marker = null;
        if (loggingEvent != null) {
            marker = loggingEvent.getMarker();
        }
        this.setMarker(marker);
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
        this.updateState();
    }

    private void updateState() {
        this.removeAll();
        if (this.viewContainer == null || this.marker == null) {
            this.setEnabled(false);
            return;
        }
        Set collected = this.marker.collectMarkerNames();
        if (collected == null || collected.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        TreeSet sorted = new TreeSet(collected);
        for (String current : sorted) {
            this.add(this.createAction(this.viewContainer, current));
        }
        this.setEnabled(true);
    }

    protected FilterAction createAction(ViewContainer viewContainer, String markerName) {
        return new FocusMarkerAction(viewContainer, markerName);
    }
}

