/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanAllInactiveCallable
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(CleanAllInactiveCallable.class);
    private MainFrame mainFrame;

    public CleanAllInactiveCallable(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public Long call() throws Exception {
        LogFileFactory accessFileFactory = this.mainFrame.getAccessFileFactory();
        LogFileFactory loggingFileFactory = this.mainFrame.getLoggingFileFactory();
        List<SourceIdentifier> inactiveAccess = this.mainFrame.collectInactiveLogs(accessFileFactory);
        List<SourceIdentifier> inactiveLogging = this.mainFrame.collectInactiveLogs(loggingFileFactory);
        this.setNumberOfSteps(inactiveAccess.size() + inactiveLogging.size());
        long currentStep = 0L;
        for (SourceIdentifier si : inactiveAccess) {
            this.delete(accessFileFactory, si);
            this.setCurrentStep(++currentStep);
        }
        for (SourceIdentifier si : inactiveLogging) {
            this.delete(loggingFileFactory, si);
            this.setCurrentStep(++currentStep);
        }
        return currentStep;
    }

    private void delete(LogFileFactory fileFactory, SourceIdentifier si) {
        File dataFile = fileFactory.getDataFile(si);
        File indexFile = fileFactory.getIndexFile(si);
        if (dataFile.delete() && this.logger.isInfoEnabled()) {
            this.logger.info("Deleted {}", (Object)dataFile);
        }
        if (indexFile.delete() && this.logger.isInfoEnabled()) {
            this.logger.info("Deleted {}", (Object)indexFile);
        }
    }
}

