/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.impl.EventSourceImpl;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.callables.CallableMetaData;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.Flush;
import de.huxhorn.sulky.buffers.FlushOperation;
import de.huxhorn.sulky.buffers.filtering.FilteringBuffer;
import de.huxhorn.sulky.buffers.filtering.FilteringCallable;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.tasks.ProgressingCallable;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewContainer<T extends Serializable>
extends JPanel
implements DisposeOperation,
FlushOperation {
    private static final long serialVersionUID = 4834209079953596930L;
    public static final String SELECTED_EVENT_PROPERTY_NAME = "selectedEvent";
    private static final ImageIcon globalFrameImageIcon;
    private static final Map<LoggingViewState, ImageIcon> frameIconImages;
    private final List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();
    private EventWrapperViewPanel<T> defaultView;
    private final MainFrame mainFrame;
    private TaskManager<Long> taskManager;
    private Map<Callable<Long>, EventWrapperViewPanel<T>> filterMapping;
    private FilterTaskListener filterTaskListener;
    private EventSource<T> eventSource;
    private ProgressGlassPane progressPanel;
    private Component prevGlassPane;
    private boolean searching;
    private ProgressingCallable<Long> updateCallable;

    public ViewContainer(MainFrame mainFrame, EventSource<T> eventSource) {
        if (mainFrame == null) {
            throw new IllegalArgumentException("mainFrame must not be null!");
        }
        this.mainFrame = mainFrame;
        this.eventSource = eventSource;
        this.taskManager = mainFrame.getLongWorkManager();
        this.progressPanel = new ProgressGlassPane();
        this.filterMapping = new HashMap<Callable<Long>, EventWrapperViewPanel<T>>();
        this.filterTaskListener = new FilterTaskListener();
        this.taskManager.addTaskListener((TaskListener)this.filterTaskListener);
        this.defaultView = this.createViewPanel(eventSource);
        this.defaultView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName())) {
                    ViewContainer.this.updateContainerIcon();
                }
            }
        });
    }

    public EventSource<T> getEventSource() {
        return this.eventSource;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    protected abstract EventWrapperViewPanel<T> createViewPanel(EventSource<T> var1);

    public abstract EventWrapperViewPanel<T> getViewAt(int var1);

    public abstract EventWrapperViewPanel<T> getSelectedView();

    public abstract void addView(EventWrapperViewPanel<T> var1);

    public abstract void removeView(EventWrapperViewPanel<T> var1, boolean var2);

    public abstract void showDefaultView();

    public abstract Class getWrappedClass();

    public EventWrapperViewPanel<T> getDefaultView() {
        return this.defaultView;
    }

    public void dispose() {
        this.taskManager.removeTaskListener((TaskListener)this.filterTaskListener);
        this.cancelUpdateTask();
    }

    public void flush() {
        for (int i = 0; i < this.getViewCount(); ++i) {
            Flush.flush(this.getViewAt(i));
        }
    }

    public void applyCondition(Condition condition, ActionEvent e) {
        if (condition == null) {
            return;
        }
        EventWrapperViewPanel<T> selectedView = this.getSelectedView();
        if (selectedView == null) {
            return;
        }
        Condition previousCondition = selectedView.getBufferCondition();
        Condition filter = selectedView.getCombinedCondition(condition);
        if (filter == null || filter.equals(previousCondition)) {
            return;
        }
        ApplicationPreferences applicationPreferences = this.getMainFrame().getApplicationPreferences();
        if (applicationPreferences.isReplacingOnApply(e)) {
            this.replaceFilteredView(selectedView, filter);
        } else {
            this.addFilteredView(selectedView, filter);
        }
    }

    public void addFilteredView(EventWrapperViewPanel<T> original, Condition filter) {
        Buffer<EventWrapper<T>> originalBuffer = original.getSourceBuffer();
        FilteringBuffer filteredBuffer = new FilteringBuffer(originalBuffer, filter);
        FilteringCallable callable = new FilteringCallable(filteredBuffer, 500);
        EventSource<T> originalEventSource = original.getEventSource();
        Map<String, String> metaData = CallableMetaData.createFilteringMetaData(filter, originalEventSource);
        EventSourceImpl newEventSource = new EventSourceImpl(originalEventSource.getSourceIdentifier(), (Buffer)filteredBuffer, filter, originalEventSource.isGlobal());
        EventWrapperViewPanel<T> newViewPanel = this.createViewPanel((EventSource<T>)newEventSource);
        this.filterMapping.put((Callable<Long>)callable, newViewPanel);
        this.addView(newViewPanel);
        this.taskManager.startTask((Callable)callable, "Filtering", ViewContainer.createFilteringMessage(metaData), metaData);
    }

    public void replaceFilteredView(EventWrapperViewPanel<T> original, Condition filter) {
        EventSource<T> eventSource = original.getEventSource();
        Buffer buffer = eventSource.getBuffer();
        if (buffer instanceof FilteringBuffer) {
            Callable<Long> found = null;
            for (Map.Entry<Callable<Long>, EventWrapperViewPanel<T>> current : this.filterMapping.entrySet()) {
                if (current.getValue() != original) continue;
                found = current.getKey();
                break;
            }
            if (found != null) {
                this.filterMapping.remove(found);
                Task task = this.taskManager.getTaskByCallable(found);
                if (task != null) {
                    task.getFuture().cancel(true);
                }
                Buffer<EventWrapper<T>> originalBuffer = original.getSourceBuffer();
                FilteringBuffer filteredBuffer = new FilteringBuffer(originalBuffer, filter);
                FilteringCallable callable = new FilteringCallable(filteredBuffer, 500);
                EventSource<T> originalEventSource = original.getEventSource();
                Map<String, String> metaData = CallableMetaData.createFilteringMetaData(filter, originalEventSource);
                EventSourceImpl newEventSource = new EventSourceImpl(originalEventSource.getSourceIdentifier(), (Buffer)filteredBuffer, filter, originalEventSource.isGlobal());
                original.setEventSource((EventSource<T>)newEventSource);
                this.filterMapping.put((Callable<Long>)callable, original);
                this.taskManager.startTask((Callable)callable, "Filtering", ViewContainer.createFilteringMessage(metaData), metaData);
            }
        } else {
            this.addFilteredView(original, filter);
        }
    }

    private static String createFilteringMessage(Map<String, String> metaData) {
        return "Filtering " + metaData.get("SourceIdentifier") + ".\n\n" + metaData.get("Condition");
    }

    public ViewWindow resolveViewWindow() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ViewWindow); parent = parent.getParent()) {
        }
        return (ViewWindow)((Object)parent);
    }

    private void updateContainerIcon() {
        ViewWindow window = this.resolveViewWindow();
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)((Object)window);
            this.updateFrameIcon(frame);
        } else if (window instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)((Object)window);
            this.updateInternalFrameIcon(frame);
        }
    }

    private static ImageIcon resolveIconForState(LoggingViewState state) {
        ImageIcon result = globalFrameImageIcon;
        if (state != null) {
            result = frameIconImages.get((Object)state);
        }
        return result;
    }

    private void updateFrameIcon(JFrame frame) {
        ImageIcon frameImageIcon = ViewContainer.resolveIconForState(this.defaultView.getState());
        if (frameImageIcon != null) {
            frame.setIconImage(frameImageIcon.getImage());
        }
    }

    private void updateInternalFrameIcon(JInternalFrame iframe) {
        ImageIcon frameImageIcon = ViewContainer.resolveIconForState(this.defaultView.getState());
        if (frameImageIcon != null) {
            iframe.setFrameIcon(frameImageIcon);
            iframe.repaint();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateContainerIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        boolean changed = false;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
                changed = true;
            }
        }
        if (changed) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        boolean changed = false;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (this.changeListeners.contains(listener)) {
                this.changeListeners.remove(listener);
                changed = true;
            }
        }
        if (changed) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange() {
        ArrayList<ChangeListener> clone;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            clone = new ArrayList<ChangeListener>(this.changeListeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : clone) {
            listener.stateChanged(event);
        }
    }

    public void setPreviousSearchStrings(List<String> previousSearchStrings) {
        for (int i = 0; i < this.getViewCount(); ++i) {
            EventWrapperViewPanel<T> view = this.getViewAt(i);
            view.setPreviousSearchStrings(previousSearchStrings);
        }
    }

    public void setConditionNames(List<String> conditionNames) {
        for (int i = 0; i < this.getViewCount(); ++i) {
            EventWrapperViewPanel<T> view = this.getViewAt(i);
            view.setConditionNames(conditionNames);
        }
    }

    public abstract void updateViewScale(double var1);

    public abstract void setShowingStatusbar(boolean var1);

    public void setUpdateCallable(ProgressingCallable<Long> updateCallable) {
        this.cancelUpdateTask();
        this.updateCallable = updateCallable;
        if (this.updateCallable != null) {
            this.taskManager.startTask(this.updateCallable, "Updating: " + this.updateCallable);
            this.getDefaultView().setState(LoggingViewState.UPDATING_FILE);
        }
    }

    private void cancelUpdateTask() {
        if (this.updateCallable != null) {
            Task task = this.taskManager.getTaskByCallable(this.updateCallable);
            if (task != null) {
                task.getFuture().cancel(true);
            }
            this.updateCallable = null;
            this.getDefaultView().setState(LoggingViewState.STALE_FILE);
        }
    }

    public abstract void closeCurrentFilter();

    public abstract void closeOtherFilters();

    public abstract void closeAllFilters();

    public abstract int getViewCount();

    public abstract void setViewIndex(int var1);

    public abstract int getViewIndex();

    public boolean isSearching() {
        return this.searching;
    }

    public void cancelSearching() {
        this.progressPanel.getFindCancelAction().actionPerformed(null);
    }

    public void hideSearchPanel() {
        if (this.searching) {
            this.searching = false;
            ViewWindow window = this.resolveViewWindow();
            if (window != null && this.prevGlassPane != null) {
                window.setGlassPane(this.prevGlassPane);
                this.prevGlassPane = null;
                this.fireChange();
            }
        }
    }

    public void showSearchPanel(Task<Long> task) {
        if (task != null) {
            this.searching = true;
            this.progressPanel.setProgress(0);
            this.progressPanel.getFindCancelAction().setTask(task);
            ViewWindow window = this.resolveViewWindow();
            if (window != null) {
                this.prevGlassPane = window.getGlassPane();
                window.setGlassPane(this.progressPanel);
                this.progressPanel.setVisible(true);
            }
            this.fireChange();
        }
    }

    public ProgressGlassPane getProgressPanel() {
        return this.progressPanel;
    }

    public abstract EventWrapper<T> getSelectedEvent();

    public abstract void updateViews();

    public abstract void scrollToEvent();

    static {
        URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/categories/applications-internet.png");
        globalFrameImageIcon = url != null ? new ImageIcon(url) : null;
        frameIconImages = new HashMap<LoggingViewState, ImageIcon>();
        url = EventWrapperViewPanel.class.getResource("/tango/16x16/status/network-receive.png");
        if (url != null) {
            frameIconImages.put(LoggingViewState.ACTIVE, new ImageIcon(url));
        }
        if ((url = EventWrapperViewPanel.class.getResource("/tango/16x16/status/network-offline.png")) != null) {
            frameIconImages.put(LoggingViewState.INACTIVE, new ImageIcon(url));
        }
        if ((url = EventWrapperViewPanel.class.getResource("/tango/16x16/emotes/face-grin.png")) != null) {
            frameIconImages.put(LoggingViewState.UPDATING_FILE, new ImageIcon(url));
        }
        if ((url = EventWrapperViewPanel.class.getResource("/tango/16x16/emotes/face-plain.png")) != null) {
            frameIconImages.put(LoggingViewState.STALE_FILE, new ImageIcon(url));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterTaskListener
    implements TaskListener<Long> {
        private final Logger logger = LoggerFactory.getLogger(FilterTaskListener.class);

        FilterTaskListener() {
        }

        public void taskCreated(Task<Long> longTask) {
        }

        public void executionFailed(Task<Long> task, ExecutionException exception) {
            EventWrapperViewPanel view = (EventWrapperViewPanel)ViewContainer.this.filterMapping.get(task.getCallable());
            if (view != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Filter execution failed!", (Throwable)exception);
                }
                this.finished(view);
            }
            if (task.getCallable() == ViewContainer.this.updateCallable) {
                ViewContainer.this.cancelUpdateTask();
            }
        }

        public void executionFinished(Task<Long> task, Long result) {
            EventWrapperViewPanel view = (EventWrapperViewPanel)ViewContainer.this.filterMapping.get(task.getCallable());
            if (view != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Filter execution finished: {}!", (Object)result);
                }
                this.finished(view);
            }
            if (task.getCallable() == ViewContainer.this.updateCallable) {
                ViewContainer.this.cancelUpdateTask();
            }
        }

        public void executionCanceled(Task<Long> task) {
            EventWrapperViewPanel view = (EventWrapperViewPanel)ViewContainer.this.filterMapping.get(task.getCallable());
            if (view != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Filter execution canceled.");
                }
                this.finished(view);
            }
            if (task.getCallable() == ViewContainer.this.updateCallable) {
                ViewContainer.this.cancelUpdateTask();
            }
        }

        public void progressUpdated(Task<Long> task, int progress) {
        }

        private void finished(EventWrapperViewPanel<T> view) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing FilterTaskListener.finished().");
            }
            ViewContainer.this.removeView(view, true);
        }
    }
}

