/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.Lilith;
import de.huxhorn.lilith.LilithBuffer;
import de.huxhorn.lilith.VersionBundle;
import de.huxhorn.lilith.appender.InternalLilithAppender;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.data.access.logback.LogbackAccessConverter;
import de.huxhorn.lilith.data.converter.Converter;
import de.huxhorn.lilith.data.converter.ConverterRegistry;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.logback.LogbackLoggingConverter;
import de.huxhorn.lilith.debug.DebugDialog;
import de.huxhorn.lilith.engine.AccessFileBufferFactory;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.EventSourceListener;
import de.huxhorn.lilith.engine.EventSourceProducer;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.engine.LoggingFileBufferFactory;
import de.huxhorn.lilith.engine.SourceManager;
import de.huxhorn.lilith.engine.impl.EventSourceImpl;
import de.huxhorn.lilith.engine.impl.LogFileFactoryImpl;
import de.huxhorn.lilith.engine.impl.eventproducer.LoggingEventSourceIdentifierUpdater;
import de.huxhorn.lilith.engine.impl.eventproducer.SourceIdentifierUpdater;
import de.huxhorn.lilith.engine.impl.sourcemanager.SourceManagerImpl;
import de.huxhorn.lilith.engine.impl.sourceproducer.AccessEventProtobufServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.impl.sourceproducer.ConvertingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.impl.sourceproducer.LoggingEventProtobufServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.json.sourceproducer.LilithJsonMessageLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.json.sourceproducer.LilithJsonStreamLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.jul.sourceproducer.JulXmlStreamLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.xml.sourceproducer.LilithXmlMessageLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.xml.sourceproducer.LilithXmlStreamLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.eventhandlers.AlarmSoundAccessEventHandler;
import de.huxhorn.lilith.eventhandlers.AlarmSoundLoggingEventHandler;
import de.huxhorn.lilith.eventhandlers.FileDumpEventHandler;
import de.huxhorn.lilith.eventhandlers.FileSplitterEventHandler;
import de.huxhorn.lilith.eventhandlers.RrdLoggingEventHandler;
import de.huxhorn.lilith.jul.xml.JulImportCallable;
import de.huxhorn.lilith.log4j.producer.Log4jLoggingConverter;
import de.huxhorn.lilith.log4j.xml.Log4jImportCallable;
import de.huxhorn.lilith.log4j2.producer.Log4j2LoggingConverter;
import de.huxhorn.lilith.prefs.LilithPreferences;
import de.huxhorn.lilith.services.gotosrc.GoToSource;
import de.huxhorn.lilith.services.gotosrc.SerializingGoToSource;
import de.huxhorn.lilith.services.sender.EventSender;
import de.huxhorn.lilith.services.sender.SenderService;
import de.huxhorn.lilith.swing.AboutDialog;
import de.huxhorn.lilith.swing.AccessEventViewManager;
import de.huxhorn.lilith.swing.AccessEventViewPanel;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.CheckForUpdateDialog;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.HelpFrame;
import de.huxhorn.lilith.swing.HtmlTransferable;
import de.huxhorn.lilith.swing.LoggingEventViewManager;
import de.huxhorn.lilith.swing.LoggingEventViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.OpenPreviousDialog;
import de.huxhorn.lilith.swing.SplashScreen;
import de.huxhorn.lilith.swing.StatisticsDialog;
import de.huxhorn.lilith.swing.TipOfTheDayDialog;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewContainerFrame;
import de.huxhorn.lilith.swing.ViewContainerInternalFrame;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.callables.CheckFileChangeCallable;
import de.huxhorn.lilith.swing.callables.CleanAllInactiveCallable;
import de.huxhorn.lilith.swing.callables.CleanObsoleteCallable;
import de.huxhorn.lilith.swing.callables.ExportCallable;
import de.huxhorn.lilith.swing.callables.IndexingCallable;
import de.huxhorn.lilith.swing.filefilters.DirectoryFilter;
import de.huxhorn.lilith.swing.filefilters.LilithFileFilter;
import de.huxhorn.lilith.swing.filefilters.LogFileFilter;
import de.huxhorn.lilith.swing.filefilters.RrdFileFilter;
import de.huxhorn.lilith.swing.filefilters.XmlImportFileFilter;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.taskmanager.TaskManagerInternalFrame;
import de.huxhorn.lilith.swing.transfer.MainFrameTransferHandler;
import de.huxhorn.lilith.swing.transfer.MainFrameTransferHandler16;
import de.huxhorn.lilith.tray.TraySupport;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.codec.filebuffer.CodecFileBuffer;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.Or;
import de.huxhorn.sulky.formatting.SimpleXml;
import de.huxhorn.sulky.groovy.GroovyInstance;
import de.huxhorn.sulky.io.IOUtilities;
import de.huxhorn.sulky.sounds.Sounds;
import de.huxhorn.sulky.swing.MemoryStatus;
import de.huxhorn.sulky.swing.Windows;
import de.huxhorn.sulky.tasks.ProgressingCallable;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import groovy.lang.Binding;
import groovy.lang.Script;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPInputStream;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 6138189654024239738L;
    private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
    private final File startupApplicationPath;
    private GoToSource gotoSource;
    private LogFileFactory loggingFileFactory;
    private SourceManager<LoggingEvent> loggingEventSourceManager;
    private FileBufferFactory<LoggingEvent> loggingFileBufferFactory;
    private EventSourceListener<LoggingEvent> loggingSourceListener;
    private LoggingEventViewManager loggingEventViewManager;
    private LogFileFactory accessFileFactory;
    private SourceManager<AccessEvent> accessEventSourceManager;
    private FileBufferFactory<AccessEvent> accessFileBufferFactory;
    private EventSourceListener<AccessEvent> accessSourceListener;
    private AccessEventViewManager accessEventViewManager;
    private Sounds sounds;
    private JDesktopPane desktop;
    private PreferencesDialog preferencesDialog;
    private JDialog aboutDialog;
    private JLabel statusLabel;
    private ApplicationPreferences applicationPreferences;
    private DebugDialog debugDialog;
    private RrdFileFilter rrdFileFilter;
    private StatisticsDialog statisticsDialog;
    private TaskManager<Long> longTaskManager;
    private ViewActions viewActions;
    private OpenPreviousDialog openInactiveLogsDialog;
    private HelpFrame helpFrame;
    private Application application;
    private int activeCounter;
    private List<AutostartRunnable> autostartProcesses;
    private SenderService senderService;
    private boolean enableBonjour;
    private static final boolean isMac;
    private static final boolean isWindows;
    private List<SavedCondition> activeConditions;
    private Map<LoggingEvent.Level, Colors> levelColors;
    private Map<HttpStatus.Type, Colors> statusColors;
    private SplashScreen splashScreen;
    private TaskManagerInternalFrame taskManagerFrame;
    private JLabel taskStatusLabel;
    private int previousNumberOfTasks;
    private ImageIcon smallProgressIcon;
    public static final String LOGS_SUBDIRECTORY = "logs";
    public static final String LOGGING_FILE_SUBDIRECTORY = "logs/logging";
    public static final String ACCESS_FILE_SUBDIRECTORY = "logs/access";
    private JFileChooser openFileChooser;
    private JFileChooser importFileChooser;
    private JFileChooser exportFileChooser;
    private boolean coloringWholeRow;
    private static final double SCALE_FACTOR = 0.05;
    private JToolBar toolbar;
    private JPanel statusBar;
    private TipOfTheDayDialog tipOfTheDayDialog;
    private CheckForUpdateDialog checkForUpdateDialog;
    private FileDumpEventHandler<LoggingEvent> loggingFileDump;
    private FileDumpEventHandler<AccessEvent> accessFileDump;
    private RrdLoggingEventHandler rrdLoggingEventHandler;
    private static final int EXPORT_WARNING_SIZE = 20000;
    private Condition findActiveCondition;
    private GroovyInstance detailsViewInstance;
    private TraySupport traySupport;
    private static final String[] MAC_OPEN_URL_ARRAY;
    private static final String[] WINDOWS_OPEN_URL_ARRAY;

    public AccessEventViewManager getAccessEventViewManager() {
        return this.accessEventViewManager;
    }

    public LoggingEventViewManager getLoggingEventViewManager() {
        return this.loggingEventViewManager;
    }

    public PreferencesDialog getPreferencesDialog() {
        return this.preferencesDialog;
    }

    public ViewActions getViewActions() {
        return this.viewActions;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public MainFrame(ApplicationPreferences applicationPreferences, SplashScreen splashScreen, String appName, boolean enableBonjour) {
        super(appName);
        this.applicationPreferences = applicationPreferences;
        this.coloringWholeRow = this.applicationPreferences.isColoringWholeRow();
        this.splashScreen = splashScreen;
        this.setSplashStatusText("Creating main frame.");
        this.smallProgressIcon = new ImageIcon(MainFrame.class.getResource("/otherGraphics/Progress16.gif"));
        ImageIcon frameIcon = new ImageIcon(MainFrame.class.getResource("/otherGraphics/Lilith16.jpg"));
        this.setIconImage(frameIcon.getImage());
        this.application = new DefaultApplication();
        this.autostartProcesses = new ArrayList<AutostartRunnable>();
        this.addWindowListener(new MainWindowListener());
        this.setDefaultCloseOperation(0);
        Runtime runtime = Runtime.getRuntime();
        Thread shutdownHook = new Thread(new ShutdownRunnable());
        runtime.addShutdownHook(shutdownHook);
        this.senderService = new SenderService(this);
        this.enableBonjour = enableBonjour;
        this.longTaskManager = new TaskManager();
        this.longTaskManager.setUsingEventQueue(true);
        this.longTaskManager.startUp();
        this.longTaskManager.addTaskListener((TaskListener)new MainTaskListener());
        this.startupApplicationPath = this.applicationPreferences.getStartupApplicationPath();
        this.loggingFileFactory = new LogFileFactoryImpl(new File(this.startupApplicationPath, LOGGING_FILE_SUBDIRECTORY));
        this.accessFileFactory = new LogFileFactoryImpl(new File(this.startupApplicationPath, ACCESS_FILE_SUBDIRECTORY));
        HashMap<String, String> loggingMetaData = new HashMap<String, String>();
        loggingMetaData.put("contentType", "logging");
        loggingMetaData.put("contentFormat", "protobuf");
        loggingMetaData.put("compression", "GZIP");
        this.loggingFileBufferFactory = new LoggingFileBufferFactory(this.loggingFileFactory, loggingMetaData);
        HashMap<String, String> accessMetaData = new HashMap<String, String>();
        accessMetaData.put("contentType", "access");
        accessMetaData.put("contentFormat", "protobuf");
        accessMetaData.put("compression", "GZIP");
        this.accessFileBufferFactory = new AccessFileBufferFactory(this.accessFileFactory, accessMetaData);
        this.rrdFileFilter = new RrdFileFilter();
        this.loggingEventViewManager = new LoggingEventViewManager(this);
        this.accessEventViewManager = new AccessEventViewManager(this);
        this.applicationPreferences.addPropertyChangeListener(new PreferencesChangeListener());
        this.loggingSourceListener = new LoggingEventSourceListener();
        this.accessSourceListener = new AccessEventSourceListener();
        this.desktop = new JDesktopPane();
        this.statusBar = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Starting...");
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.statusBar.add((Component)this.statusLabel, gbc);
        this.taskStatusLabel = new JLabel();
        this.taskStatusLabel.setText("");
        this.taskStatusLabel.setForeground(Color.BLUE);
        this.taskStatusLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainFrame.this.showTaskManager();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                MainFrame.this.taskStatusLabel.setForeground(Color.RED);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                MainFrame.this.taskStatusLabel.setForeground(Color.BLUE);
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.statusBar.add((Component)this.taskStatusLabel, gbc);
        MemoryStatus memoryStatus = new MemoryStatus();
        memoryStatus.setBackground(Color.WHITE);
        memoryStatus.setOpaque(true);
        memoryStatus.setUsingBinaryUnits(true);
        memoryStatus.setUsingTotal(false);
        memoryStatus.setBorder((Border)new EtchedBorder(1));
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.statusBar.add((Component)memoryStatus, gbc);
        this.add((Component)this.desktop, "Center");
        this.add((Component)this.statusBar, "South");
        if (SystemUtils.IS_JAVA_1_6) {
            this.setSplashStatusText("Creating statistics dialog.");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Before creation of statistics-dialog...");
            }
            this.statisticsDialog = new StatisticsDialog(this);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("After creation of statistics-dialog...");
            }
        }
        this.setSplashStatusText("Creating about dialog.");
        this.aboutDialog = new AboutDialog((Frame)this, "About " + appName + "...", appName);
        this.setSplashStatusText("Creating update dialog.");
        this.checkForUpdateDialog = new CheckForUpdateDialog(this);
        this.setSplashStatusText("Creating debug dialog.");
        this.debugDialog = new DebugDialog((Frame)this, this);
        this.setSplashStatusText("Creating preferences dialog.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Before creation of preferences-dialog...");
        }
        this.preferencesDialog = new PreferencesDialog(this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After creation of preferences-dialog...");
        }
        this.setSplashStatusText("Creating \"Open inactive\" dialog.");
        this.openInactiveLogsDialog = new OpenPreviousDialog(this);
        this.setSplashStatusText("Creating help frame.");
        this.helpFrame = new HelpFrame(this);
        this.helpFrame.setTitle("Help Topics");
        this.openFileChooser = new JFileChooser();
        this.openFileChooser.setFileFilter(new LilithFileFilter());
        this.openFileChooser.setFileHidingEnabled(false);
        this.openFileChooser.setCurrentDirectory(this.applicationPreferences.getPreviousOpenPath());
        this.importFileChooser = new JFileChooser();
        this.importFileChooser.setFileFilter(new XmlImportFileFilter());
        this.importFileChooser.setFileHidingEnabled(false);
        this.importFileChooser.setCurrentDirectory(this.applicationPreferences.getPreviousImportPath());
        this.exportFileChooser = new JFileChooser();
        this.exportFileChooser.setFileFilter(new LilithFileFilter());
        this.exportFileChooser.setFileHidingEnabled(false);
        this.exportFileChooser.setCurrentDirectory(this.applicationPreferences.getPreviousExportPath());
        this.setSplashStatusText("Creating task manager frame.");
        this.taskManagerFrame = new TaskManagerInternalFrame(this);
        this.taskManagerFrame.setTitle("Task Manager");
        this.taskManagerFrame.setDefaultCloseOperation(1);
        this.taskManagerFrame.setBounds(0, 0, 320, 240);
        this.desktop.add(this.taskManagerFrame);
        this.desktop.validate();
        try {
            new MainFrameTransferHandler16(this).attach();
        }
        catch (Throwable t) {
            new MainFrameTransferHandler(this).attach();
        }
        this.setSplashStatusText("Creating Tip of the Day dialog.");
        this.tipOfTheDayDialog = new TipOfTheDayDialog(this);
        this.setSplashStatusText("Creating actions and menus.");
        this.viewActions = new ViewActions(this, null);
        this.viewActions.getPopupMenu();
        JMenuBar menuBar = this.viewActions.getMenuBar();
        this.toolbar = this.viewActions.getToolbar();
        this.add((Component)this.toolbar, "North");
        this.setJMenuBar(menuBar);
        this.setShowingToolbar(applicationPreferences.isShowingToolbar());
        this.setShowingStatusbar(applicationPreferences.isShowingStatusbar());
        File detailsViewRoot = this.getApplicationPreferences().getDetailsViewRoot();
        File scriptFile = new File(detailsViewRoot, "detailsView.groovy");
        this.detailsViewInstance = new GroovyInstance();
        this.detailsViewInstance.setGroovyFileName(scriptFile.getAbsolutePath());
    }

    public void startUp() {
        block50: {
            ConvertingServerSocketEventSourceProducer producer;
            block49: {
                block48: {
                    ConverterRegistry accessConverterRegistry;
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    block39: {
                                                        block38: {
                                                            ConverterRegistry loggingConverterRegistry;
                                                            block37: {
                                                                File[] autoFiles;
                                                                this.setSplashStatusText("Executing autostart items.");
                                                                File autostartDir = new File(this.startupApplicationPath, "autostart");
                                                                if (autostartDir.mkdirs() && this.logger.isDebugEnabled()) {
                                                                    this.logger.debug("Created '{}'.", (Object)autostartDir.getAbsolutePath());
                                                                }
                                                                if ((autoFiles = autostartDir.listFiles(new FileFilter(){

                                                                    public boolean accept(File file) {
                                                                        return file.isFile();
                                                                    }
                                                                })) != null && autoFiles.length > 0) {
                                                                    Arrays.sort(autoFiles, new Comparator<File>(){

                                                                        @Override
                                                                        public int compare(File o1, File o2) {
                                                                            return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                                                                        }
                                                                    });
                                                                    for (File current : autoFiles) {
                                                                        AutostartRunnable r = new AutostartRunnable(current);
                                                                        this.autostartProcesses.add(r);
                                                                        Thread t = new Thread((Runnable)r, current.getAbsolutePath());
                                                                        t.setDaemon(true);
                                                                        t.start();
                                                                    }
                                                                } else if (this.logger.isInfoEnabled()) {
                                                                    this.logger.info("No autostart files defined in '{}'.", (Object)autostartDir.getAbsolutePath());
                                                                }
                                                                this.gotoSource = new SerializingGoToSource();
                                                                this.setSplashStatusText("Creating global views.");
                                                                SourceIdentifier globalSourceIdentifier = new SourceIdentifier("global", null);
                                                                this.loggingFileDump = new FileDumpEventHandler<LoggingEvent>(globalSourceIdentifier, this.loggingFileBufferFactory);
                                                                this.accessFileDump = new FileDumpEventHandler<AccessEvent>(globalSourceIdentifier, this.accessFileBufferFactory);
                                                                this.setGlobalLoggingEnabled(this.applicationPreferences.isGlobalLoggingEnabled());
                                                                LilithBuffer loggingEventQueue = new LilithBuffer(this.applicationPreferences, 1000);
                                                                LilithBuffer accessEventQueue = new LilithBuffer(this.applicationPreferences, 1000);
                                                                SourceManagerImpl lsm = new SourceManagerImpl(loggingEventQueue);
                                                                EventSourceImpl globalLoggingEventSource = new EventSourceImpl(globalSourceIdentifier, this.loggingFileDump.getBuffer(), true);
                                                                lsm.addSource((EventSource)globalLoggingEventSource);
                                                                this.setSplashStatusText("Creating internal view.");
                                                                EventSourceImpl lilithLoggingEventSource = new EventSourceImpl(InternalLilithAppender.getSourceIdentifier(), InternalLilithAppender.getBuffer(), false);
                                                                lsm.addSource((EventSource)lilithLoggingEventSource);
                                                                this.setLoggingEventSourceManager((SourceManager<LoggingEvent>)lsm);
                                                                SourceManagerImpl asm = new SourceManagerImpl(accessEventQueue);
                                                                EventSourceImpl globalAccessEventSource = new EventSourceImpl(globalSourceIdentifier, this.accessFileDump.getBuffer(), true);
                                                                asm.addSource((EventSource)globalAccessEventSource);
                                                                this.setAccessEventSourceManager((SourceManager<AccessEvent>)asm);
                                                                loggingConverterRegistry = new ConverterRegistry();
                                                                loggingConverterRegistry.addConverter((Converter)new LogbackLoggingConverter());
                                                                loggingConverterRegistry.addConverter((Converter)new Log4jLoggingConverter());
                                                                loggingConverterRegistry.addConverter((Converter)new Log4j2LoggingConverter());
                                                                accessConverterRegistry = new ConverterRegistry();
                                                                accessConverterRegistry.addConverter((Converter)new LogbackAccessConverter());
                                                                this.setSplashStatusText("Starting event receivers.");
                                                                try {
                                                                    producer = new ConvertingServerSocketEventSourceProducer(4560, loggingConverterRegistry, (SourceIdentifierUpdater)new LoggingEventSourceIdentifierUpdater());
                                                                    this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                                                }
                                                                catch (IOException ex) {
                                                                    if (!this.logger.isWarnEnabled()) break block37;
                                                                    this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                                                }
                                                            }
                                                            try {
                                                                producer = new ConvertingServerSocketEventSourceProducer(4445, loggingConverterRegistry, (SourceIdentifierUpdater)new LoggingEventSourceIdentifierUpdater());
                                                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                                            }
                                                            catch (IOException ex) {
                                                                if (!this.logger.isWarnEnabled()) break block38;
                                                                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                                            }
                                                        }
                                                        try {
                                                            producer = new LoggingEventProtobufServerSocketEventSourceProducer(10000, true);
                                                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                                        }
                                                        catch (IOException ex) {
                                                            if (!this.logger.isWarnEnabled()) break block39;
                                                            this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                                        }
                                                    }
                                                    try {
                                                        producer = new LoggingEventProtobufServerSocketEventSourceProducer(10001, false);
                                                        this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                                    }
                                                    catch (IOException ex) {
                                                        if (!this.logger.isWarnEnabled()) break block40;
                                                        this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                                    }
                                                }
                                                try {
                                                    producer = new LilithXmlMessageLoggingServerSocketEventSourceProducer(10021, false);
                                                    this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                                }
                                                catch (IOException ex) {
                                                    if (!this.logger.isWarnEnabled()) break block41;
                                                    this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                                }
                                            }
                                            try {
                                                producer = new LilithXmlMessageLoggingServerSocketEventSourceProducer(10020, true);
                                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                            }
                                            catch (IOException ex) {
                                                if (!this.logger.isWarnEnabled()) break block42;
                                                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                            }
                                        }
                                        try {
                                            producer = new LilithJsonMessageLoggingServerSocketEventSourceProducer(10031, false);
                                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                        }
                                        catch (IOException ex) {
                                            if (!this.logger.isWarnEnabled()) break block43;
                                            this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                        }
                                    }
                                    try {
                                        producer = new LilithJsonMessageLoggingServerSocketEventSourceProducer(10030, true);
                                        this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                    }
                                    catch (IOException ex) {
                                        if (!this.logger.isWarnEnabled()) break block44;
                                        this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                    }
                                }
                                try {
                                    producer = new LilithXmlStreamLoggingServerSocketEventSourceProducer(11000);
                                    this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                }
                                catch (IOException ex) {
                                    if (!this.logger.isWarnEnabled()) break block45;
                                    this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                }
                            }
                            try {
                                producer = new LilithJsonStreamLoggingServerSocketEventSourceProducer(11010);
                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                            }
                            catch (IOException ex) {
                                if (!this.logger.isWarnEnabled()) break block46;
                                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                            }
                        }
                        try {
                            producer = new JulXmlStreamLoggingServerSocketEventSourceProducer(11020);
                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                        }
                        catch (IOException ex) {
                            if (!this.logger.isWarnEnabled()) break block47;
                            this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                        }
                    }
                    try {
                        producer = new ConvertingServerSocketEventSourceProducer(4570, accessConverterRegistry, null);
                        this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                    }
                    catch (IOException ex) {
                        if (!this.logger.isWarnEnabled()) break block48;
                        this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                    }
                }
                try {
                    producer = new AccessEventProtobufServerSocketEventSourceProducer(10010, true);
                    this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) break block49;
                    this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                }
            }
            try {
                producer = new AccessEventProtobufServerSocketEventSourceProducer(10011, false);
                this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
            }
            catch (IOException ex) {
                if (!this.logger.isWarnEnabled()) break block50;
                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
            }
        }
        this.setSplashStatusText("Setting up event handlers.");
        this.rrdLoggingEventHandler = new RrdLoggingEventHandler();
        this.rrdLoggingEventHandler.setBasePath(new File(this.startupApplicationPath, "statistics"));
        this.setStatisticsEnabled(this.applicationPreferences.isLoggingStatisticEnabled());
        AlarmSoundLoggingEventHandler loggingEventAlarmSound = new AlarmSoundLoggingEventHandler();
        loggingEventAlarmSound.setSounds(this.sounds);
        FileSplitterEventHandler<LoggingEvent> fileSplitterLoggingEventHandler = new FileSplitterEventHandler<LoggingEvent>(this.loggingFileBufferFactory, this.loggingEventSourceManager);
        ArrayList<Object> loggingHandlers = new ArrayList<Object>();
        loggingHandlers.add(this.rrdLoggingEventHandler);
        loggingHandlers.add(loggingEventAlarmSound);
        loggingHandlers.add(fileSplitterLoggingEventHandler);
        loggingHandlers.add(this.loggingFileDump);
        this.loggingEventSourceManager.setEventHandlers(loggingHandlers);
        this.loggingEventSourceManager.start();
        ArrayList<Object> accessHandlers = new ArrayList<Object>();
        FileSplitterEventHandler<AccessEvent> fileSplitterAccessEventHandler = new FileSplitterEventHandler<AccessEvent>(this.accessFileBufferFactory, this.accessEventSourceManager);
        AlarmSoundAccessEventHandler accessEventAlarmSound = new AlarmSoundAccessEventHandler();
        accessEventAlarmSound.setSounds(this.sounds);
        accessHandlers.add(accessEventAlarmSound);
        accessHandlers.add(fileSplitterAccessEventHandler);
        accessHandlers.add(this.accessFileDump);
        this.accessEventSourceManager.setEventHandlers(accessHandlers);
        this.accessEventSourceManager.start();
        this.viewActions.updateWindowMenu();
        this.application.setEnabledAboutMenu(true);
        this.application.setEnabledPreferencesMenu(true);
        this.application.addApplicationListener((ApplicationListener)new MyApplicationListener());
        if (this.enableBonjour) {
            this.senderService.start();
        }
        if (Lilith.APP_SNAPSHOT || this.applicationPreferences.isCheckingForUpdate()) {
            this.checkForUpdate(false);
        }
        this.updateConditions();
        if (this.applicationPreferences.isShowingTipOfTheDay()) {
            this.showTipOfTheDayDialog();
        }
        this.cleanObsoleteFiles();
        this.traySupport = TraySupport.getInstance();
        if (this.traySupport != null) {
            this.traySupport.setMainFrame(this);
        }
        this.setSplashStatusText("Finished.");
    }

    public void showTipOfTheDayDialog() {
        Windows.showWindow((Window)this.tipOfTheDayDialog, (Window)this, (boolean)true);
    }

    private void updateTaskStatus() {
        int numberOfTasks = this.longTaskManager.getNumberOfTasks();
        if (numberOfTasks != this.previousNumberOfTasks) {
            this.previousNumberOfTasks = numberOfTasks;
            String text = "";
            ImageIcon icon = null;
            if (numberOfTasks == 1) {
                text = "1 active task.";
                icon = this.smallProgressIcon;
            } else if (numberOfTasks > 1) {
                text = "" + numberOfTasks + " active tasks.";
                icon = this.smallProgressIcon;
            }
            this.taskStatusLabel.setText(text);
            this.taskStatusLabel.setIcon(icon);
        }
    }

    private void setSplashStatusText(String text) {
        if (this.splashScreen != null) {
            this.splashScreen.setStatusText(text);
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public Map<String, EventSender<LoggingEvent>> getLoggingEventSenders() {
        return this.senderService.getLoggingEventSenders();
    }

    public Map<String, EventSender<AccessEvent>> getAccessEventSenders() {
        return this.senderService.getAccessEventSenders();
    }

    public void updateWindowMenus() {
        this.viewActions.updateWindowMenu();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateWindowMenu();
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateWindowMenu();
        }
        JInternalFrame selected = this.desktop.getSelectedFrame();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Selected IFrame: {}", (Object)selected);
        }
        if (selected instanceof ViewContainerInternalFrame) {
            ViewContainerInternalFrame iframe = (ViewContainerInternalFrame)selected;
            this.viewActions.setViewContainer(iframe.getViewContainer());
        } else {
            this.viewActions.setViewContainer(null);
        }
    }

    public void closeLoggingConnection(SourceIdentifier id) {
        this.loggingEventSourceManager.removeEventProducer(id);
    }

    public void closeAccessConnection(SourceIdentifier id) {
        this.accessEventSourceManager.removeEventProducer(id);
    }

    public void goToSource(StackTraceElement ste) {
        if (this.gotoSource != null) {
            this.gotoSource.goToSource(ste);
        }
    }

    public void setActiveConnectionsCounter(int activeCounter) {
        this.activeCounter = activeCounter;
        this.updateStatus();
    }

    public void copyHtml(String html) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        HtmlTransferable transferableText = new HtmlTransferable(html);
        systemClipboard.setContents(transferableText, null);
    }

    public void checkForUpdate(boolean showAlways) {
        Thread t = new Thread(new CheckForUpdateRunnable(showAlways, this.applicationPreferences.isCheckingForSnapshot()));
        t.start();
    }

    public Colors getColors(HttpStatus.Type status) {
        Colors c;
        block4: {
            if (this.statusColors == null) {
                this.initStatusColors();
            }
            if ((c = this.statusColors.get(status)) != null) {
                try {
                    c = c.clone();
                }
                catch (CloneNotSupportedException e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("Exception while cloning Colors!!", (Throwable)e);
                }
            }
        }
        return c;
    }

    public Colors getColors(LoggingEvent.Level level) {
        Colors c;
        block4: {
            if (this.levelColors == null) {
                this.initLevelColors();
            }
            if ((c = this.levelColors.get(level)) != null) {
                try {
                    c = c.clone();
                }
                catch (CloneNotSupportedException e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("Exception while cloning Colors!!", (Throwable)e);
                }
            }
        }
        return c;
    }

    public Colors getColors(EventWrapper eventWrapper) {
        if (!SwingUtilities.isEventDispatchThread() && this.logger.isErrorEnabled()) {
            this.logger.error("Not on EventDispatchThread!");
        }
        ColorScheme result = null;
        if (this.activeConditions != null) {
            for (SavedCondition current : this.activeConditions) {
                Condition condition = current.getCondition();
                if (condition != null && condition.isTrue((Object)eventWrapper)) {
                    if (result == null) {
                        result = current.getColorScheme();
                        if (result != null) {
                            try {
                                result = result.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                if (this.logger.isErrorEnabled()) {
                                    this.logger.error("Exception while cloning ColorScheme!!", (Throwable)e);
                                }
                            }
                        }
                    } else {
                        result.mergeWith(current.getColorScheme());
                    }
                }
                if (result == null || !result.isAbsolute()) continue;
                return new Colors(result, false);
            }
        }
        if (this.coloringWholeRow) {
            Colors c;
            Serializable eventObj = eventWrapper.getEvent();
            if (eventObj instanceof LoggingEvent) {
                c = this.getColors(((LoggingEvent)eventObj).getLevel());
                if (result != null) {
                    return new Colors(result.mergeWith(c.getColorScheme()), false);
                }
                return c;
            }
            if (eventObj instanceof AccessEvent) {
                c = this.getColors(HttpStatus.getType((int)((AccessEvent)eventObj).getStatusCode()));
                if (result != null) {
                    return new Colors(result.mergeWith(c.getColorScheme()), false);
                }
                return c;
            }
        }
        if (result != null) {
            return new Colors(result, false);
        }
        return null;
    }

    public void open() {
        int returnVal = this.openFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.open(this.openFileChooser.getSelectedFile());
        }
    }

    public void importFile() {
        int returnVal = this.importFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File importFile = this.importFileChooser.getSelectedFile();
            String fileName = importFile.getAbsolutePath();
            if (fileName.toLowerCase().endsWith(".lilith")) {
                this.open(importFile);
                return;
            }
            this.importFile(importFile);
        }
    }

    public void exportFile(EventWrapperViewPanel view) {
        long size = view.getEventSource().getBuffer().getSize();
        if (size == 0L) {
            return;
        }
        int returnVal = this.exportFileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file;
            String fileName;
            if (size > 20000L) {
                String dialogTitle = "Large export! Are you sure?";
                String message = "You are about to export " + size + " events. This could take some time.\nAre you sure you want to export?";
                int result = JOptionPane.showConfirmDialog(this, message, dialogTitle, 2, 3);
                if (0 != result) {
                    return;
                }
            }
            String baseName = (fileName = (file = this.exportFileChooser.getSelectedFile()).getAbsolutePath()).toLowerCase().endsWith(".lilith") ? fileName.substring(0, fileName.length() - ".lilith".length()) : fileName;
            File dataFile = new File(baseName + ".lilith");
            File indexFile = new File(baseName + ".idx");
            if (dataFile.isFile()) {
                String message = "Data file does already exist!\nOverwrite data file?";
                String dialogTitle = "Overwrite file?";
                int result = JOptionPane.showConfirmDialog(this, message, dialogTitle, 2, 3);
                if (0 != result) {
                    return;
                }
                if (!dataFile.delete() && this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't delete existing file {}!", (Object)dataFile.getAbsolutePath());
                }
                if (indexFile.isFile() && !indexFile.delete() && this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't delete existing file {}!", (Object)indexFile.getAbsolutePath());
                }
            }
            if (view instanceof AccessEventViewPanel) {
                this.exportFile(dataFile, indexFile, (AccessEventViewPanel)view);
            } else if (view instanceof LoggingEventViewPanel) {
                this.exportFile(dataFile, indexFile, (LoggingEventViewPanel)view);
            }
        }
    }

    private void exportFile(File dataFile, File indexFile, AccessEventViewPanel viewPanel) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("contentFormat", "protobuf");
        metaData.put("contentType", "access");
        metaData.put("compression", "GZIP");
        FileBuffer outputBuffer = this.accessFileBufferFactory.createBuffer(dataFile, indexFile, metaData);
        Buffer inputBuffer = viewPanel.getEventSource().getBuffer();
        String name = "Export to " + dataFile.getName();
        String description = "Exporting " + inputBuffer.getSize() + " access events into file '" + dataFile.getAbsolutePath() + "'.";
        Task task = this.longTaskManager.startTask(new ExportCallable(inputBuffer, outputBuffer), name, description);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Task-Name: {}", (Object)task.getName());
        }
    }

    private void exportFile(File dataFile, File indexFile, LoggingEventViewPanel viewPanel) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("contentFormat", "protobuf");
        metaData.put("contentType", "logging");
        metaData.put("compression", "GZIP");
        FileBuffer outputBuffer = this.loggingFileBufferFactory.createBuffer(dataFile, indexFile, metaData);
        Buffer inputBuffer = viewPanel.getEventSource().getBuffer();
        String name = "Export to " + dataFile.getName();
        String description = "Exporting " + inputBuffer.getSize() + " logging events into file '" + dataFile.getAbsolutePath() + "'.";
        Task task = this.longTaskManager.startTask(new ExportCallable(inputBuffer, outputBuffer), name, description);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Task-Name: {}", (Object)task.getName());
        }
    }

    public void open(File dataFile) {
        String dialogTitle;
        String message;
        int result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Open file: {}", (Object)dataFile.getAbsolutePath());
        }
        if (!dataFile.isFile()) {
            String message2 = "'" + dataFile.getAbsolutePath() + "' is not a file!";
            JOptionPane.showMessageDialog(this, message2, "Can't open file...", 0);
            return;
        }
        if (!dataFile.canRead()) {
            String message3 = "Can't read from '" + dataFile.getAbsolutePath() + "'!";
            JOptionPane.showMessageDialog(this, message3, "Can't open file...", 0);
            return;
        }
        ViewContainer<?> viewContainer = this.resolveViewContainer(dataFile);
        if (viewContainer != null) {
            this.showView(viewContainer);
            String message4 = "File '" + dataFile.getAbsolutePath() + "' is already open.";
            JOptionPane.showMessageDialog(this, message4, "File is already open...", 1);
            return;
        }
        String fileName = dataFile.getAbsolutePath();
        String indexFileName = fileName.toLowerCase().endsWith(".lilith") ? fileName.substring(0, fileName.length() - ".lilith".length()) : fileName;
        indexFileName = indexFileName + ".idx";
        long dataModified = dataFile.lastModified();
        File indexFile = new File(indexFileName);
        if (!indexFile.isFile()) {
            String message5 = "Index file does not exist!\nIndex data file right now?";
            String dialogTitle2 = "Index file?";
            int result2 = JOptionPane.showConfirmDialog(this, message5, dialogTitle2, 2, 3);
            if (0 != result2) {
                return;
            }
            String name = "Indexing Lilith file";
            String description = "Indexing '" + dataFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)((Object)new IndexingCallable(dataFile, indexFile)), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        long indexModified = indexFile.lastModified();
        if (indexModified < dataModified && 0 == (result = JOptionPane.showConfirmDialog(this, message = "The index file is older than the data file!\nReindex data file right now?", dialogTitle = "Index outdated. Reindex file?", 2, 3)) && indexFile.delete()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Deleted previous index file {}.", (Object)indexFile.getAbsolutePath());
            }
            String name = "Reindexing Lilith file";
            String description = "Reindexing '" + dataFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)((Object)new IndexingCallable(dataFile, indexFile)), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        this.createViewFor(dataFile, indexFile, true);
    }

    public void importFile(File importFile) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Import file: {}", (Object)importFile.getAbsolutePath());
        }
        File parentFile = importFile.getParentFile();
        String inputName = importFile.getName();
        if (!importFile.isFile()) {
            String message = "'" + importFile.getAbsolutePath() + "' is not a file!";
            JOptionPane.showMessageDialog(this, message, "Can't import file...", 0);
            return;
        }
        if (!importFile.canRead()) {
            String message = "Can't read from '" + importFile.getAbsolutePath() + "'!";
            JOptionPane.showMessageDialog(this, message, "Can't import file...", 0);
            return;
        }
        File dataFile = new File(parentFile, inputName + ".lilith");
        File indexFile = new File(parentFile, inputName + ".idx");
        if (dataFile.isFile()) {
            ViewContainer<?> viewContainer = this.resolveViewContainer(dataFile);
            if (viewContainer != null) {
                this.showView(viewContainer);
                String message = "File '" + dataFile.getAbsolutePath() + "' is already open.";
                JOptionPane.showMessageDialog(this, message, "File is already open...", 1);
                return;
            }
            String message = "Data file does already exist!\nReimport data file right now?";
            String dialogTitle = "Reimport file?";
            int result = JOptionPane.showConfirmDialog(this, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            if (dataFile.delete() && this.logger.isInfoEnabled()) {
                this.logger.info("Deleted file '{}'.", (Object)dataFile.getAbsolutePath());
            }
        }
        if (indexFile.isFile() && indexFile.delete() && this.logger.isInfoEnabled()) {
            this.logger.info("Deleted file '{}'.", (Object)indexFile.getAbsolutePath());
        }
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("contentFormat", "protobuf");
        metaData.put("contentType", "logging");
        metaData.put("compression", "GZIP");
        FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(dataFile, indexFile, metaData);
        ImportType type = this.resolveType(importFile);
        if (type == ImportType.LOG4J) {
            String name = "Importing Log4J XML file";
            String description = "Importing Log4J XML file '" + importFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)new Log4jImportCallable(importFile, (AppendOperation)buffer), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        if (type == ImportType.JUL) {
            String name = "Importing java.util.logging XML file";
            String description = "Importing java.util.logging XML file '" + importFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)new JulImportCallable(importFile, (AppendOperation)buffer), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        String message = "Couldn't detect type of file '" + importFile.getAbsolutePath() + "'.\nFile is unsupported.";
        JOptionPane.showMessageDialog(this, message, "Unknown file type...", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportType resolveType(File inputFile) {
        BufferedReader br = null;
        try {
            FileInputStream fis = new FileInputStream(inputFile);
            String fileName = inputFile.getName().toLowerCase();
            br = fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(fis), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            for (int i = 0; i < 5; ++i) {
                String line = br.readLine();
                if (line == null) {
                    break;
                }
                if (line.contains("<log4j:")) {
                    ImportType importType = ImportType.LOG4J;
                    return importType;
                }
                if (!line.contains("<log>") && !line.contains("<record>")) continue;
                ImportType importType = ImportType.JUL;
                return importType;
            }
        }
        catch (IOException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while resolving type of file!", (Throwable)ex);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void zoomOut() {
        double scale = this.applicationPreferences.getScaleFactor() - 0.05;
        if (scale < 0.1) {
            scale = 0.1;
        }
        this.applicationPreferences.setScaleFactor(scale);
    }

    public void zoomIn() {
        double scale = this.applicationPreferences.getScaleFactor() + 0.05;
        this.applicationPreferences.setScaleFactor(scale);
    }

    public void resetZoom() {
        this.applicationPreferences.setScaleFactor(1.0);
    }

    public void troubleshooting() {
        this.preferencesDialog.showPane(PreferencesDialog.Panes.Troubleshooting);
    }

    public void openHelp(String help) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opening help: {}", (Object)help);
        }
        this.helpFrame.setHelpUrl(help);
        if (!this.helpFrame.isVisible()) {
            Windows.showWindow((Window)this.helpFrame, (Window)this, (boolean)false);
        }
        this.helpFrame.toFront();
    }

    public void openPreferences(String panelName) {
        block2: {
            try {
                PreferencesDialog.Panes pane = PreferencesDialog.Panes.valueOf(panelName);
                this.preferencesDialog.showPane(pane);
            }
            catch (IllegalArgumentException ex) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Couldn't resolve preferences pane '{}'!", (Object)panelName);
            }
        }
    }

    public ViewContainer<?> resolveViewContainer(File dataFile) {
        CodecFileBuffer cfb;
        Buffer buffer;
        EventSource es;
        EventWrapperViewPanel defaultView;
        ViewContainer view;
        Map views = this.loggingEventViewManager.getViews();
        for (Map.Entry current : views.entrySet()) {
            view = current.getValue();
            defaultView = view.getDefaultView();
            es = defaultView.getEventSource();
            if (es == null || !((buffer = es.getBuffer()) instanceof CodecFileBuffer) || !dataFile.equals((cfb = (CodecFileBuffer)buffer).getDataFile())) continue;
            return view;
        }
        views = this.accessEventViewManager.getViews();
        for (Map.Entry current : views.entrySet()) {
            view = current.getValue();
            defaultView = view.getDefaultView();
            es = defaultView.getEventSource();
            if (es == null || !((buffer = es.getBuffer()) instanceof CodecFileBuffer) || !dataFile.equals((cfb = (CodecFileBuffer)buffer).getDataFile())) continue;
            return view;
        }
        return null;
    }

    private void createViewFor(File dataFile, File indexFile, boolean keepUpdating) {
        block18: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Create view for dataFile '{}' and indexFile '{}'.", (Object)dataFile.getAbsolutePath(), (Object)indexFile.getAbsolutePath());
            }
            DefaultFileHeaderStrategy fileHeaderStrategy = new DefaultFileHeaderStrategy();
            try {
                FileHeader header = fileHeaderStrategy.readFileHeader(dataFile);
                if (header == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Couldn't read file header from '{}'!", (Object)dataFile.getAbsolutePath());
                    }
                    return;
                }
                if (header.getMagicValue() != 190731757) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Invalid magic value! ", (Object)Integer.toHexString(header.getMagicValue()));
                    }
                    return;
                }
                MetaData metaData = header.getMetaData();
                if (metaData == null || metaData.getData() == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Couldn't read meta data from '{}'!", (Object)dataFile.getAbsolutePath());
                    }
                    return;
                }
                Map data = metaData.getData();
                String contentType = (String)data.get("contentType");
                HashMap usedMetaData = new HashMap();
                SourceIdentifier si = new SourceIdentifier(dataFile.getAbsolutePath());
                if ("logging".equals(contentType)) {
                    FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(dataFile, indexFile, usedMetaData);
                    EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
                    ViewContainer viewContainer = this.loggingEventViewManager.retrieveViewContainer(eventSource);
                    EventWrapperViewPanel panel = viewContainer.getDefaultView();
                    if (keepUpdating) {
                        panel.setState(LoggingViewState.UPDATING_FILE);
                        viewContainer.setUpdateCallable((ProgressingCallable<Long>)new CheckFileChangeCallable(dataFile, indexFile, viewContainer));
                    } else {
                        panel.setState(LoggingViewState.STALE_FILE);
                    }
                    this.showLoggingView((EventSource<LoggingEvent>)eventSource);
                    this.applicationPreferences.addRecentFile(dataFile);
                } else if ("access".equals(contentType)) {
                    FileBuffer buffer = this.accessFileBufferFactory.createBuffer(dataFile, indexFile, usedMetaData);
                    EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
                    ViewContainer viewContainer = this.accessEventViewManager.retrieveViewContainer(eventSource);
                    EventWrapperViewPanel panel = viewContainer.getDefaultView();
                    if (keepUpdating) {
                        panel.setState(LoggingViewState.UPDATING_FILE);
                        viewContainer.setUpdateCallable((ProgressingCallable<Long>)new CheckFileChangeCallable(dataFile, indexFile, viewContainer));
                    } else {
                        panel.setState(LoggingViewState.STALE_FILE);
                    }
                    this.showAccessView((EventSource<AccessEvent>)eventSource);
                    this.applicationPreferences.addRecentFile(dataFile);
                } else {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Unexpected content type {}.", (Object)contentType);
                    }
                    this.applicationPreferences.removeRecentFile(dataFile);
                }
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block18;
                this.logger.warn("Exception while creating view form file!", (Throwable)e);
            }
        }
    }

    private void initStatusColors() {
        Map<HttpStatus.Type, ColorScheme> prefValue = this.applicationPreferences.getStatusColors();
        HashMap<HttpStatus.Type, Colors> colors = new HashMap<HttpStatus.Type, Colors>();
        for (Map.Entry<HttpStatus.Type, ColorScheme> current : prefValue.entrySet()) {
            colors.put(current.getKey(), new Colors(current.getValue(), false));
        }
        this.statusColors = colors;
    }

    private void initLevelColors() {
        Map<LoggingEvent.Level, ColorScheme> prefValue = this.applicationPreferences.getLevelColors();
        HashMap<LoggingEvent.Level, Colors> colors = new HashMap<LoggingEvent.Level, Colors>();
        for (Map.Entry<LoggingEvent.Level, ColorScheme> current : prefValue.entrySet()) {
            colors.put(current.getKey(), new Colors(current.getValue(), false));
        }
        this.levelColors = colors;
    }

    private void setLoggingEventSourceManager(SourceManager<LoggingEvent> loggingEventSourceManager) {
        if (this.loggingEventSourceManager != null) {
            this.loggingEventSourceManager.removeEventSourceListener(this.loggingSourceListener);
        }
        this.loggingEventSourceManager = loggingEventSourceManager;
        if (this.loggingEventSourceManager != null) {
            this.loggingEventSourceManager.addEventSourceListener(this.loggingSourceListener);
            List sources = this.loggingEventSourceManager.getSources();
            for (EventSource source : sources) {
                this.loggingEventViewManager.retrieveViewContainer(source);
            }
        }
    }

    public SourceManager<LoggingEvent> getLoggingEventSourceManager() {
        return this.loggingEventSourceManager;
    }

    private void setAccessEventSourceManager(SourceManager<AccessEvent> accessEventSourceManager) {
        if (this.accessEventSourceManager != null) {
            this.accessEventSourceManager.removeEventSourceListener(this.accessSourceListener);
        }
        this.accessEventSourceManager = accessEventSourceManager;
        if (this.accessEventSourceManager != null) {
            this.accessEventSourceManager.addEventSourceListener(this.accessSourceListener);
            List sources = this.accessEventSourceManager.getSources();
            for (EventSource source : sources) {
                this.accessEventViewManager.retrieveViewContainer(source);
            }
        }
    }

    public SourceManager<AccessEvent> getAccessEventSourceManager() {
        return this.accessEventSourceManager;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public void setSounds(Sounds sounds) {
        if (sounds != null) {
            sounds.setSoundLocations(this.applicationPreferences.getSoundLocations());
            sounds.setMute(this.applicationPreferences.isMute());
        }
        this.sounds = sounds;
    }

    private ViewContainer<LoggingEvent> retrieveLoggingViewContainer(EventSource<LoggingEvent> eventSource) {
        return this.loggingEventViewManager.retrieveViewContainer(eventSource);
    }

    private ViewContainer<AccessEvent> retrieveAccessViewContainer(EventSource<AccessEvent> eventSource) {
        return this.accessEventViewManager.retrieveViewContainer(eventSource);
    }

    public ApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public SortedMap<String, SourceIdentifier> getAvailableStatistics() {
        File statisticsPath = new File(this.applicationPreferences.getStartupApplicationPath(), "statistics");
        File[] files = statisticsPath.listFiles(this.rrdFileFilter);
        TreeMap<String, SourceIdentifier> sources = new TreeMap<String, SourceIdentifier>();
        if (files != null) {
            for (File f : files) {
                String name = f.getName();
                if ((name = name.substring(0, name.length() - 4)).equalsIgnoreCase("global")) continue;
                SourceIdentifier si = new SourceIdentifier(name);
                sources.put(this.getSourceTitle(si, null), si);
            }
        }
        return sources;
    }

    public void showStatistics(SourceIdentifier sourceIdentifier) {
        if (this.statisticsDialog != null) {
            this.statisticsDialog.setSourceIdentifier(sourceIdentifier);
            Windows.showWindow((Window)this.statisticsDialog, (Window)this, (boolean)true);
        }
    }

    public TaskManager<Long> getLongWorkManager() {
        return this.longTaskManager;
    }

    public LogFileFactory getAccessFileFactory() {
        return this.accessFileFactory;
    }

    public LogFileFactory getLoggingFileFactory() {
        return this.loggingFileFactory;
    }

    public void showLoggingView(EventSource<LoggingEvent> eventSource) {
        ViewContainer<LoggingEvent> container = this.retrieveLoggingViewContainer(eventSource);
        this.showView(container);
    }

    public void showAccessView(EventSource<AccessEvent> eventSource) {
        ViewContainer<AccessEvent> container = this.retrieveAccessViewContainer(eventSource);
        this.showView(container);
    }

    public void showView(ViewContainer<?> container) {
        ShowViewRunnable runnable = new ShowViewRunnable(container);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void openPreviousLogging(SourceIdentifier si) {
        FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(si);
        EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
        ViewContainer<LoggingEvent> container = this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)eventSource);
        EventWrapperViewPanel<LoggingEvent> panel = container.getDefaultView();
        panel.setState(LoggingViewState.INACTIVE);
        this.showLoggingView((EventSource<LoggingEvent>)eventSource);
    }

    public void openPreviousAccess(SourceIdentifier si) {
        FileBuffer buffer = this.accessFileBufferFactory.createBuffer(si);
        EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
        ViewContainer<AccessEvent> container = this.retrieveAccessViewContainer((EventSource<AccessEvent>)eventSource);
        EventWrapperViewPanel<AccessEvent> panel = container.getDefaultView();
        panel.setState(LoggingViewState.INACTIVE);
        this.showAccessView((EventSource<AccessEvent>)eventSource);
    }

    public void updateStatus() {
        StringBuilder statusText = new StringBuilder();
        LilithPreferences.SourceFiltering filtering = this.applicationPreferences.getSourceFiltering();
        switch (filtering) {
            case BLACKLIST: {
                statusText.append("Blacklisting on '");
                statusText.append(this.applicationPreferences.getBlackListName());
                statusText.append("'.  ");
                break;
            }
            case WHITELIST: {
                statusText.append("Whitelisting on '");
                statusText.append(this.applicationPreferences.getWhiteListName());
                statusText.append("'.  ");
            }
        }
        if (this.activeCounter == 0) {
            statusText.append("No active connections.");
        } else if (this.activeCounter == 1) {
            statusText.append("One active connection.");
        } else if (this.activeCounter > 1) {
            statusText.append(this.activeCounter).append(" active connections.");
        }
        String status = statusText.toString();
        this.statusLabel.setText(status);
        if (this.traySupport != null) {
            this.traySupport.setToolTip(status);
        }
    }

    public String createMessage(EventWrapper wrapper) {
        String message;
        Script instance = (Script)this.detailsViewInstance.getInstanceAs(Script.class);
        if (instance == null) {
            Throwable errorCause;
            StringBuilder msg = new StringBuilder("<html><body>detailsView Script is broken!");
            String errorMessage = this.detailsViewInstance.getErrorMessage();
            if (errorMessage != null) {
                errorMessage = SimpleXml.escape((String)errorMessage);
                msg.append("<br/>").append(errorMessage);
            }
            if ((errorCause = this.detailsViewInstance.getErrorCause()) != null) {
                String exceptionStr = errorCause.toString();
                exceptionStr = SimpleXml.escape((String)exceptionStr);
                msg.append("<br/>").append(exceptionStr);
            }
            msg.append("</body></html>");
            message = msg.toString();
        } else {
            try {
                Binding binding = new Binding();
                binding.setVariable("eventWrapper", (Object)wrapper);
                binding.setVariable("logger", (Object)this.logger);
                binding.setVariable("completeCallStack", (Object)this.applicationPreferences.isShowingFullCallstack());
                binding.setVariable("showStackTrace", (Object)this.applicationPreferences.isShowingStackTrace());
                binding.setVariable("wrappedExceptionStyle", (Object)this.applicationPreferences.isUsingWrappedExceptionStyle());
                instance.setBinding(binding);
                Object result = instance.run();
                message = result instanceof String ? (String)result : (result != null ? result.toString() : "<html><body>detailsView Script returned null!</body></html>");
            }
            catch (Throwable t) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while executing detailsView Script!", t);
                }
                StringBuilder msg = new StringBuilder("<html><body>Exception while executing detailsView Script!");
                String exceptionStr = t.toString();
                exceptionStr = SimpleXml.escape((String)exceptionStr);
                msg.append("<br/>").append(exceptionStr);
                msg.append("</body></html>");
                message = msg.toString();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message:\n{}", (Object)message);
        }
        message = SimpleXml.replaceNonValidXMLCharacters((String)message, (char)' ');
        return message;
    }

    public SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> getSortedLoggingViews() {
        EventSourceComparator loggingComparator = new EventSourceComparator();
        TreeMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> sortedLoggingViews = new TreeMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>>(loggingComparator);
        if (this.loggingEventViewManager != null) {
            sortedLoggingViews.putAll(this.loggingEventViewManager.getViews());
        }
        return sortedLoggingViews;
    }

    public SortedMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> getSortedAccessViews() {
        EventSourceComparator accessComparator = new EventSourceComparator();
        TreeMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> sortedAccessViews = new TreeMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>>(accessComparator);
        if (this.accessEventViewManager != null) {
            sortedAccessViews.putAll(this.accessEventViewManager.getViews());
        }
        return sortedAccessViews;
    }

    public void closeAllViews(ViewContainer beside) {
        this.loggingEventViewManager.closeAllViews(beside);
        this.accessEventViewManager.closeAllViews(beside);
    }

    public void minimizeAllViews(ViewContainer beside) {
        this.loggingEventViewManager.minimizeAllViews(beside);
        this.accessEventViewManager.minimizeAllViews(beside);
    }

    public void removeInactiveViews(boolean onlyClosed, boolean clean) {
        EventWrapperViewPanel panel;
        List removed = this.loggingEventViewManager.removeInactiveViews(onlyClosed);
        if (clean) {
            for (ViewContainer current : removed) {
                panel = current.getDefaultView();
                panel.clear();
            }
        }
        removed = this.accessEventViewManager.removeInactiveViews(onlyClosed);
        if (clean) {
            for (ViewContainer current : removed) {
                panel = current.getDefaultView();
                panel.clear();
            }
        }
    }

    public void toggleVisible() {
        this.setFramesVisible(!this.isVisible());
    }

    public void setFramesVisible(boolean visible) {
        this.setVisible(visible);
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof ViewContainerFrame)) continue;
            ViewContainerFrame frame = (ViewContainerFrame)window;
            frame.setVisible(visible);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof ViewContainerFrame)) continue;
            ViewContainerFrame frame = (ViewContainerFrame)window;
            frame.setVisible(visible);
        }
    }

    public void openInactiveLogs() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Open inactive log...");
        }
        Windows.showWindow((Window)this.openInactiveLogsDialog, (Window)this, (boolean)true);
    }

    public void showDebugDialog() {
        Windows.showWindow((Window)this.debugDialog, (Window)this, (boolean)true);
    }

    public void showPreferencesDialog() {
        Windows.showWindow((Window)this.preferencesDialog, (Window)this, (boolean)true);
    }

    public void showHelp() {
        this.openHelp("index.xhtml");
    }

    public void showAboutDialog() {
        Windows.showWindow((Window)this.aboutDialog, (Window)this, (boolean)true);
    }

    public void cleanAllInactiveLogs() {
        this.loggingEventViewManager.removeInactiveViews(false);
        this.accessEventViewManager.removeInactiveViews(false);
        this.longTaskManager.startTask((Callable)((Object)new CleanAllInactiveCallable(this)), "Clean all inactive...");
        this.updateWindowMenus();
    }

    public String getPrimarySourceTitle(String primary) {
        if (primary == null) {
            return null;
        }
        Map<String, String> sourceNames = this.applicationPreferences.getSourceNames();
        String resolvedName = sourceNames.get(primary);
        if (resolvedName != null && !resolvedName.equals(primary)) {
            if (this.applicationPreferences.isShowingIdentifier()) {
                return resolvedName + " [" + primary + "]";
            }
            return resolvedName;
        }
        return primary;
    }

    public String getPrimarySourceTitle(SourceIdentifier identifier) {
        return this.getPrimarySourceTitle(identifier.getIdentifier());
    }

    public String getSourceTitle(SourceIdentifier identifier, String name) {
        String primary = this.getPrimarySourceTitle(identifier);
        String secondary = identifier.getSecondaryIdentifier();
        if (secondary == null) {
            if (name == null) {
                return primary;
            }
            return primary + " - " + name;
        }
        if (name == null) {
            return primary + " - " + secondary;
        }
        return primary + " - " + name + " - " + secondary;
    }

    public String getLoggingSourceTitle(SourceIdentifier identifier, String name) {
        return this.getSourceTitle(identifier, name) + " (Logging)";
    }

    public String getAccessSourceTitle(SourceIdentifier identifier, String name) {
        return this.getSourceTitle(identifier, name) + " (Access)";
    }

    String resolveSourceTitle(ViewContainer container) {
        EventWrapperViewPanel defaultView = container.getDefaultView();
        EventSource eventSource = defaultView.getEventSource();
        boolean global = eventSource.isGlobal();
        String name = null;
        if (!global) {
            Buffer buffer = defaultView.getSourceBuffer();
            Object event = null;
            if (buffer != null) {
                event = buffer.get(0L);
            }
            name = this.resolveName(event);
        }
        SourceIdentifier si = eventSource.getSourceIdentifier();
        Class clazz = container.getWrappedClass();
        String title = clazz == LoggingEvent.class ? this.getLoggingSourceTitle(si, name) : this.getAccessSourceTitle(si, name);
        return title;
    }

    private String resolveName(Object eventWrapperObj) {
        String appId = null;
        if (eventWrapperObj instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)eventWrapperObj;
            Serializable evtObject = wrapper.getEvent();
            LoggerContext context = null;
            if (evtObject instanceof LoggingEvent) {
                context = ((LoggingEvent)evtObject).getLoggerContext();
            } else if (evtObject instanceof AccessEvent) {
                context = ((AccessEvent)evtObject).getLoggerContext();
            }
            if (context != null) {
                Map props;
                String name = context.getName();
                if ("default".equals(name) || "".equals(name)) {
                    name = null;
                }
                if ((props = context.getProperties()) != null) {
                    appId = (String)props.get("applicationIdentifier");
                }
                if (name != null) {
                    if (appId == null || name.equals(appId)) {
                        return name;
                    }
                    return name + "/" + appId;
                }
                return appId;
            }
        }
        return null;
    }

    public static void openUrl(URL url) {
        Logger logger = LoggerFactory.getLogger(MainFrame.class);
        if (logger.isInfoEnabled()) {
            logger.info("Opening URL {}. ", (Object)url);
        }
        if (url == null) {
            return;
        }
        String[] cmdArray = MainFrame.resolveOpenCommandArray(url.toString());
        if (cmdArray == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Can't open URL {} because no open command is defined for the current system.", (Object)url);
            }
            return;
        }
        MainFrame.executeCommand(cmdArray);
    }

    public static void openUri(URI uri) {
        Logger logger = LoggerFactory.getLogger(MainFrame.class);
        if (logger.isInfoEnabled()) {
            logger.info("Opening URI {}. ", (Object)uri);
        }
        if (uri == null) {
            return;
        }
        String[] cmdArray = MainFrame.resolveOpenCommandArray(uri.toString());
        if (cmdArray == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Can't open URI {} because no open command is defined for the current system.", (Object)uri);
            }
            return;
        }
        MainFrame.executeCommand(cmdArray);
    }

    private static void executeCommand(String[] cmdArray) {
        block3: {
            Logger logger = LoggerFactory.getLogger(MainFrame.class);
            if (cmdArray == null) {
                return;
            }
            Runtime runtime = Runtime.getRuntime();
            String commandString = Arrays.asList(cmdArray).toString();
            try {
                Process process = runtime.exec(cmdArray);
                ProcessConsumerRunnable consumer = new ProcessConsumerRunnable(process);
                Thread t = new Thread((Runnable)consumer, "Consuming command: " + commandString);
                t.setDaemon(true);
                t.start();
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Exception while trying to execute command {}!", (Object)commandString, (Object)e);
            }
        }
    }

    private static String[] resolveOpenCommandArray(String value) {
        if (value == null) {
            return null;
        }
        String[] result = null;
        if (isWindows) {
            result = new String[WINDOWS_OPEN_URL_ARRAY.length];
            System.arraycopy(WINDOWS_OPEN_URL_ARRAY, 0, result, 0, WINDOWS_OPEN_URL_ARRAY.length);
        } else if (isMac) {
            result = new String[MAC_OPEN_URL_ARRAY.length];
            System.arraycopy(MAC_OPEN_URL_ARRAY, 0, result, 0, MAC_OPEN_URL_ARRAY.length);
        }
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != null) continue;
                result[i] = value;
            }
        }
        return result;
    }

    void showFrame(ViewContainer container) {
        String title = this.resolveSourceTitle(container);
        ViewContainerFrame frame = new ViewContainerFrame(this, container);
        frame.setShowingToolbar(this.applicationPreferences.isShowingToolbar());
        frame.setShowingStatusbar(this.applicationPreferences.isShowingStatusbar());
        frame.setTitle(title);
        frame.setSize(800, 600);
        Windows.showWindow((Window)frame, null, (boolean)false);
        this.executeScrollToBottom(frame);
    }

    void showInternalFrame(ViewContainer container) {
        ViewContainerInternalFrame frame;
        block3: {
            String title = this.resolveSourceTitle(container);
            frame = new ViewContainerInternalFrame(this, container);
            frame.setShowingStatusbar(this.applicationPreferences.isShowingStatusbar());
            frame.setTitle(title);
            int count = this.desktop.getComponentCount();
            int titleBarHeight = this.resolveInternalTitlebarHeight();
            frame.setBounds(titleBarHeight * (count % 10), titleBarHeight * (count % 10), 640, 480);
            this.desktop.add(frame);
            boolean maximize = this.applicationPreferences.isMaximizingInternalFrames();
            if (maximize) {
                try {
                    frame.setMaximum(true);
                }
                catch (PropertyVetoException ex) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Vetoed maximizing!", (Throwable)ex);
                }
            }
        }
        this.viewActions.setViewContainer(container);
        frame.setVisible(true);
        this.executeScrollToBottom(frame);
    }

    public void showTaskManager() {
        if (this.taskManagerFrame.isClosed()) {
            this.desktop.add(this.taskManagerFrame);
            this.desktop.validate();
        }
        if (this.taskManagerFrame.isIcon()) {
            try {
                this.taskManagerFrame.setIcon(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        if (!this.taskManagerFrame.isVisible()) {
            this.taskManagerFrame.setVisible(true);
        }
        this.taskManagerFrame.moveToFront();
        try {
            this.taskManagerFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void executeScrollToBottom(ViewWindow window) {
        if (window != null) {
            ScrollToBottomRunnable runnable = new ScrollToBottomRunnable(window);
            SwingUtilities.invokeLater(runnable);
        }
    }

    private int resolveInternalTitlebarHeight() {
        int result = 24;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Height of titlebar: {}", (Object)result);
        }
        return result;
    }

    private void showApplicationPathChangedDialog() {
        int result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("showApplicationPathChangedDialog()");
        }
        Object[] options = new Object[]{"Exit", "Cancel"};
        ImageIcon icon = null;
        URL url = MainFrame.class.getResource("/tango/32x32/status/dialog-warning.png");
        if (url != null) {
            icon = new ImageIcon(url);
        }
        if ((result = JOptionPane.showOptionDialog(this, "You have changed the application path.\nYou need to restart for this change to take effect.\n\nExit now?", "Exit now?", -1, 2, icon, options, options[0])) == 0) {
            this.exit();
        }
    }

    private void showLookAndFeelChangedDialog() {
        int result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("showLookAndFeelChangedDialog()");
        }
        Object[] options = new Object[]{"Exit", "Cancel"};
        ImageIcon icon = null;
        URL url = MainFrame.class.getResource("/tango/32x32/status/dialog-warning.png");
        if (url != null) {
            icon = new ImageIcon(url);
        }
        if ((result = JOptionPane.showOptionDialog(this, "You have changed the look & feel.\nYou need to restart for this change to take effect.\n\nExit now?", "Exit now?", -1, 2, icon, options, options[0])) == 0) {
            this.exit();
        }
    }

    public void exit() {
        String dialogTitle;
        String message;
        int result;
        if (this.applicationPreferences.isAskingBeforeQuit() && 0 != (result = JOptionPane.showConfirmDialog(this, message = "Are you really 100% sure that you want to quit?\nPlease do yourself a favour and think about it before you answer...\nExit now?", dialogTitle = "Exit now?", 2, 3))) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Exiting...");
        }
        if (this.senderService != null) {
            this.senderService.stop();
        }
        if (this.applicationPreferences.isCleaningLogsOnExit()) {
            this.deleteInactiveLogs();
        }
        this.applicationPreferences.setPreviousImportPath(this.importFileChooser.getCurrentDirectory());
        this.applicationPreferences.setPreviousExportPath(this.exportFileChooser.getCurrentDirectory());
        this.applicationPreferences.setPreviousOpenPath(this.openFileChooser.getCurrentDirectory());
        this.applicationPreferences.flush();
        this.longTaskManager.shutDown();
        System.exit(0);
    }

    private void setGlobalLoggingEnabled(boolean globalLoggingEnabled) {
        this.loggingFileDump.setEnabled(globalLoggingEnabled);
        this.accessFileDump.setEnabled(globalLoggingEnabled);
    }

    private void setStatisticsEnabled(boolean statisticsEnabled) {
        this.rrdLoggingEventHandler.setEnabled(statisticsEnabled);
    }

    private void setCheckingForUpdate(boolean checkingForUpdate) {
        this.preferencesDialog.setCheckingForUpdate(checkingForUpdate);
        this.checkForUpdateDialog.setCheckingForUpdate(checkingForUpdate);
    }

    private void setCheckingForSnapshot(boolean checkingForSnapshot) {
        this.preferencesDialog.setCheckingForSnapshot(checkingForSnapshot);
    }

    private void setShowingStatusbar(boolean showingStatusbar) {
        this.statusBar.setVisible(showingStatusbar);
        SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> views = this.getSortedLoggingViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingStatusbar(current.getValue(), showingStatusbar);
        }
        views = this.getSortedAccessViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingStatusbar(current.getValue(), showingStatusbar);
        }
    }

    private void setShowingTipOfTheDay(boolean showingTipOfTheDay) {
        this.preferencesDialog.setShowingTipOfTheDay(showingTipOfTheDay);
        this.tipOfTheDayDialog.setShowingTipOfTheDay(showingTipOfTheDay);
    }

    private void setShowingToolbar(boolean showingToolbar) {
        this.toolbar.setVisible(showingToolbar);
        SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> views = this.getSortedLoggingViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingToolbar(current.getValue(), showingToolbar);
        }
        views = this.getSortedAccessViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingToolbar(current.getValue(), showingToolbar);
        }
    }

    private void setShowingToolbar(ViewContainer container, boolean showingToolbar) {
        ViewWindow viewWindow = container.resolveViewWindow();
        if (viewWindow instanceof ViewContainerFrame) {
            ViewContainerFrame viewContainerFrame = (ViewContainerFrame)viewWindow;
            viewContainerFrame.setShowingToolbar(showingToolbar);
        }
    }

    private void setShowingStatusbar(ViewContainer container, boolean showingStatusbar) {
        ViewWindow viewWindow = container.resolveViewWindow();
        if (viewWindow != null) {
            viewWindow.setShowingStatusbar(showingStatusbar);
        }
    }

    private void updatePreviousSearchStrings() {
        ViewContainer value;
        List<String> previousSearchStrings = this.applicationPreferences.getPreviousSearchStrings();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            value = current.getValue();
            value.setPreviousSearchStrings(previousSearchStrings);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            value = current.getValue();
            value.setPreviousSearchStrings(previousSearchStrings);
        }
    }

    private void updateRecentFiles() {
        this.viewActions.updateRecentFiles();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateRecentFiles();
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateRecentFiles();
        }
    }

    public Condition getFindActiveCondition() {
        return this.findActiveCondition;
    }

    private void updateConditions() {
        ViewContainer<Object> value;
        List<SavedCondition> conditions = this.applicationPreferences.getConditions();
        ArrayList<SavedCondition> active = new ArrayList<SavedCondition>();
        if (conditions != null) {
            for (SavedCondition current : conditions) {
                if (!current.isActive()) continue;
                active.add(current);
            }
        }
        this.activeConditions = active;
        int activeCount = active.size();
        if (activeCount > 0) {
            if (activeCount == 1) {
                this.findActiveCondition = ((SavedCondition)active.get(0)).getCondition();
            } else {
                Or or = new Or();
                ArrayList<Condition> cond = new ArrayList<Condition>(activeCount);
                for (SavedCondition savedCondition : active) {
                    cond.add(savedCondition.getCondition());
                }
                or.setConditions(cond);
                this.findActiveCondition = or;
            }
        }
        this.updateAllViews();
        List<String> conditionNames = this.applicationPreferences.getConditionNames();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry<Object, ViewContainer<Object>> entry : loggingViews.entrySet()) {
            value = entry.getValue();
            value.setConditionNames(conditionNames);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry<Object, ViewContainer<Object>> entry : accessViews.entrySet()) {
            value = entry.getValue();
            value.setConditionNames(conditionNames);
        }
        this.viewActions.setConditionNames(conditionNames);
    }

    private void updateViewScale(double scale) {
        ViewContainer value;
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            value = current.getValue();
            value.updateViewScale(scale);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            value = current.getValue();
            value.updateViewScale(scale);
        }
    }

    private void updateLoggingViews() {
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            value.updateViews();
        }
    }

    private void updateAccessViews() {
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            value.updateViews();
        }
    }

    private void updateAllViews() {
        this.updateLoggingViews();
        this.updateAccessViews();
    }

    public void cleanObsoleteFiles() {
        File obsoleteDir = new File(this.startupApplicationPath, "sources");
        if (obsoleteDir.isDirectory()) {
            this.longTaskManager.startTask((Callable)((Object)new CleanObsoleteCallable(obsoleteDir)), "Clean obsolete files", "Deletes the directory '" + obsoleteDir.getAbsolutePath() + "' recursively.");
        }
    }

    public void deleteInactiveLogs() {
        this.deleteInactiveLogs(this.loggingFileFactory);
        this.deleteInactiveLogs(this.accessFileFactory);
    }

    protected void deleteInactiveLogs(LogFileFactory fileFactory) {
        List<SourceIdentifier> inactives = this.collectInactiveLogs(fileFactory);
        for (SourceIdentifier si : inactives) {
            File dataFile = fileFactory.getDataFile(si);
            File indexFile = fileFactory.getIndexFile(si);
            if (dataFile.delete() && this.logger.isInfoEnabled()) {
                this.logger.info("Deleted {}", (Object)dataFile);
            }
            if (!indexFile.delete() || !this.logger.isInfoEnabled()) continue;
            this.logger.info("Deleted {}", (Object)indexFile);
        }
    }

    public List<SourceIdentifier> collectInactiveLogs(LogFileFactory fileFactory) {
        ArrayList<SourceIdentifier> result = new ArrayList<SourceIdentifier>();
        File logsRoot = fileFactory.getBaseDir();
        File[] sources = logsRoot.listFiles(new DirectoryFilter());
        if (sources != null) {
            for (File f : sources) {
                this.collectInactiveLogs(fileFactory, f, result);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Inactive logs: {}", result);
            }
        }
        return result;
    }

    private void collectInactiveLogs(LogFileFactory fileFactory, File sourceDir, List<SourceIdentifier> inactiveLogs) {
        String primary = sourceDir.getName();
        File[] logs = sourceDir.listFiles(new LogFileFilter(fileFactory));
        String extension = fileFactory.getDataFileExtension();
        for (File f : logs) {
            String abs = f.getAbsolutePath();
            File active = new File((abs = abs.substring(0, abs.length() - extension.length())) + ".active");
            if (active.isFile()) continue;
            String secondary = f.getName();
            secondary = secondary.substring(0, secondary.length() - extension.length());
            inactiveLogs.add(new SourceIdentifier(primary, secondary));
        }
    }

    public static void copyText(String text) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferableText = new StringSelection(text);
        systemClipboard.setContents(transferableText, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(String url) {
        Logger logger = LoggerFactory.getLogger(MainFrame.class);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        BasicHttpContext localContext = new BasicHttpContext();
        HttpGet httpget = new HttpGet(url);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpget, (HttpContext)localContext);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != HttpStatus.OK.getCode()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Status while retrieving '{}': {}", (Object)url, (Object)status);
                }
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (IOException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Exception while retrieving '{}'!", (Object)url, (Object)e);
            }
            String string = null;
            return string;
        }
        finally {
            block17: {
                try {
                    client.close();
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block17;
                    logger.warn("Exception while closing down HttpClient!", (Throwable)e);
                }
            }
        }
    }

    private void showUpdateDialog(String message, String changes) {
        this.checkForUpdateDialog.setMessage(message);
        this.checkForUpdateDialog.setChanges(changes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Check for update: message='{}', changes='{}'", (Object)message, (Object)changes);
        }
        Windows.showWindow((Window)this.checkForUpdateDialog, (Window)this, (boolean)true);
    }

    static {
        DefaultApplication app = new DefaultApplication();
        isMac = app.isMac();
        if (!isMac) {
            String osName = System.getProperty("os.name").toLowerCase();
            isWindows = osName.startsWith("windows");
        } else {
            isWindows = false;
        }
        MAC_OPEN_URL_ARRAY = new String[]{"open", null};
        WINDOWS_OPEN_URL_ARRAY = new String[]{"cmd", "/C", "start", null};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MainTaskListener
    implements TaskListener<Long> {
        private final Logger logger = LoggerFactory.getLogger(MainTaskListener.class);

        private MainTaskListener() {
        }

        public void taskCreated(Task<Long> longTask) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task {} created.", (Object)longTask.getName());
            }
            MainFrame.this.updateTaskStatus();
        }

        public void executionFailed(Task<Long> longTask, ExecutionException exception) {
            String causeMsg;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Execution of task {} failed!", (Object)longTask.getName(), (Object)exception);
            }
            String message = "Execution of task " + longTask.getName() + " failed!";
            Throwable cause = exception.getCause();
            if (cause == null) {
                cause = exception;
            }
            if ((causeMsg = cause.getMessage()) == null) {
                causeMsg = cause.toString();
            }
            message = message + "\n" + causeMsg;
            JOptionPane.showMessageDialog(MainFrame.this, message, "Exception while executing task...", 0);
            MainFrame.this.updateTaskStatus();
        }

        public void executionFinished(Task<Long> longTask, Long result) {
            JulImportCallable iCallable;
            AppendOperation buffer;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Execution of task {} finished!", (Object)longTask.getName());
            }
            MainFrame.this.updateTaskStatus();
            Callable callable = longTask.getCallable();
            if (callable instanceof IndexingCallable) {
                IndexingCallable iCallable2 = (IndexingCallable)((Object)callable);
                File dataFile = iCallable2.getDataFile();
                File indexFile = iCallable2.getIndexFile();
                MainFrame.this.createViewFor(dataFile, indexFile, true);
                return;
            }
            if (callable instanceof Log4jImportCallable) {
                Log4jImportCallable iCallable3 = (Log4jImportCallable)callable;
                AppendOperation buffer2 = iCallable3.getBuffer();
                if (buffer2 instanceof CodecFileBuffer) {
                    CodecFileBuffer cfb = (CodecFileBuffer)buffer2;
                    File dataFile = cfb.getDataFile();
                    File indexFile = cfb.getIndexFile();
                    cfb.dispose();
                    MainFrame.this.createViewFor(dataFile, indexFile, false);
                }
                return;
            }
            if (callable instanceof JulImportCallable && (buffer = (iCallable = (JulImportCallable)callable).getBuffer()) instanceof CodecFileBuffer) {
                CodecFileBuffer cfb = (CodecFileBuffer)buffer;
                File dataFile = cfb.getDataFile();
                File indexFile = cfb.getIndexFile();
                cfb.dispose();
                MainFrame.this.createViewFor(dataFile, indexFile, false);
            }
        }

        public void executionCanceled(Task<Long> longTask) {
            Callable c;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Execution of task {} canceled!", (Object)longTask.getName());
            }
            if ((c = longTask.getCallable()) instanceof ExportCallable) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Done? {}", (Object)longTask.getFuture().isDone());
                }
                ExportCallable ec = (ExportCallable)((Object)c);
                FileBuffer output = ec.getOutput();
                output.reset();
                File dataFile = output.getDataFile();
                if (dataFile.isFile()) {
                    if (dataFile.delete()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Deleted {}.", (Object)dataFile.getAbsolutePath());
                        }
                        if (dataFile.isFile() && this.logger.isWarnEnabled()) {
                            this.logger.warn("WTF???? I just deleted {} and now it's still a file?!", (Object)dataFile.getAbsolutePath());
                        }
                        if (dataFile.exists() && this.logger.isWarnEnabled()) {
                            this.logger.warn("WTF???? I just deleted {} and now it still exists?!", (Object)dataFile.getAbsolutePath());
                        }
                    } else if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Couldn't delete {}.", (Object)dataFile.getAbsolutePath());
                    }
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("WTF? {}", (Object)dataFile.getAbsolutePath());
                }
            }
            MainFrame.this.updateTaskStatus();
        }

        public void progressUpdated(Task<Long> longTask, int progress) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Progress of task {} updated to {}.", (Object)longTask.getName(), (Object)progress);
            }
            MainFrame.this.updateTaskStatus();
        }
    }

    private class ShowUpdateDialog
    implements Runnable {
        private String message;
        private String changes;

        public ShowUpdateDialog(String message, String changes) {
            this.message = message;
            this.changes = changes;
        }

        public void run() {
            MainFrame.this.showUpdateDialog(this.message, this.changes);
        }
    }

    private class CheckForUpdateRunnable
    implements Runnable {
        private static final String RELEASE_VERSION_URL = "http://lilith.huxhorn.de/release-version.txt";
        private static final String SNAPSHOT_VERSION_URL = "http://lilith.huxhorn.de/snapshot-version.txt";
        private boolean showAlways;
        private boolean checkSnapshot;

        public CheckForUpdateRunnable(boolean showAlways, boolean checkSnapshot) {
            this.showAlways = showAlways;
            this.checkSnapshot = checkSnapshot;
        }

        public VersionBundle retrieveVersion(String url) {
            return VersionBundle.fromString(MainFrame.readUrl(url));
        }

        public String retrieveChanges(String currentVersion) {
            String url = "http://lilith.huxhorn.de/releases/" + currentVersion + ".xhtml";
            return MainFrame.readUrl(url);
        }

        public void run() {
            VersionBundle releaseVersionBundle = this.retrieveVersion(RELEASE_VERSION_URL);
            int compare = Lilith.APP_VERSION_BUNDLE.compareTo(releaseVersionBundle);
            if (compare < 0) {
                String version = releaseVersionBundle.getVersion();
                String message = "New release: " + version;
                String changes = this.retrieveChanges(version);
                SwingUtilities.invokeLater(new ShowUpdateDialog(message, changes));
                return;
            }
            if (!Lilith.APP_SNAPSHOT && compare > 0) {
                String version = releaseVersionBundle.getVersion();
                String message = "OH HAI! You can haz newzest release version!!1";
                String changes = this.retrieveChanges(version);
                SwingUtilities.invokeLater(new ShowUpdateDialog(message, changes));
                return;
            }
            if (Lilith.APP_SNAPSHOT || this.checkSnapshot) {
                VersionBundle snapshotVersionBundle = this.retrieveVersion(SNAPSHOT_VERSION_URL);
                compare = Lilith.APP_VERSION_BUNDLE.compareTo(snapshotVersionBundle);
                if (compare < 0) {
                    String version = snapshotVersionBundle.getVersion();
                    Date d = new Date(snapshotVersionBundle.getTimestamp());
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    String message = "New snapshot: " + version + "-" + format.format(d);
                    String changes = this.retrieveChanges(version);
                    SwingUtilities.invokeLater(new ShowUpdateDialog(message, changes));
                    return;
                }
                if (compare > 0) {
                    String version = snapshotVersionBundle.getVersion();
                    String message = "OH HAI! You can haz newzest snapshot version!!1";
                    String changes = this.retrieveChanges(version);
                    SwingUtilities.invokeLater(new ShowUpdateDialog(message, changes));
                    return;
                }
            }
            if (this.showAlways) {
                String message = null;
                String changes = this.retrieveChanges(Lilith.APP_VERSION_BUNDLE.getVersion());
                SwingUtilities.invokeLater(new ShowUpdateDialog(message, changes));
            }
        }
    }

    public static class ProcessConsumerRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
        private Process process;

        public ProcessConsumerRunnable(Process process) {
            this.process = process;
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        public void run() {
            block3: {
                try {
                    Thread errThread = new Thread(new ErrorConsumerRunnable(this.process.getErrorStream()));
                    errThread.setDaemon(true);
                    errThread.start();
                    Thread outThread = new Thread(new OutConsumerRunnable(this.process.getInputStream()));
                    outThread.setDaemon(true);
                    outThread.start();
                    int exitCode = this.process.waitFor();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Execution finished with exitCode {}.", (Object)exitCode);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug("Execution of openUrl process was interrupted.", (Throwable)e);
                }
            }
        }

        private class ErrorConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public ErrorConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                System.err.println("openUrl: " + line);
            }
        }

        private class OutConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public OutConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                if (ProcessConsumerRunnable.this.logger.isDebugEnabled()) {
                    ProcessConsumerRunnable.this.logger.debug("{}", (Object)line);
                }
            }
        }

        abstract class AbstractOutputConsumerRunnable
        implements Runnable {
            private BufferedReader inputReader;

            public AbstractOutputConsumerRunnable(InputStream input) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
            }

            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = this.inputReader.readLine()) != null) {
                            this.processLine(line);
                        }
                    }
                    catch (IOException e) {
                        if (!ProcessConsumerRunnable.this.logger.isDebugEnabled()) break block3;
                        ProcessConsumerRunnable.this.logger.debug("Exception while reading from openUrl process.", (Throwable)e);
                    }
                }
            }

            public abstract void processLine(String var1);
        }
    }

    public static class AutostartRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
        private File file;
        private Process process;

        public AutostartRunnable(File file) {
            this.file = file;
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        public void run() {
            block6: {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Starting '{}'.", (Object)this.file.getAbsolutePath());
                    }
                    this.process = Runtime.getRuntime().exec(this.file.getAbsolutePath());
                    Thread errThread = new Thread(new ErrorConsumerRunnable(this.process.getErrorStream()));
                    errThread.setDaemon(true);
                    errThread.start();
                    Thread outThread = new Thread(new OutConsumerRunnable(this.process.getInputStream()));
                    outThread.setDaemon(true);
                    outThread.start();
                    int exitCode = this.process.waitFor();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Execution of '{}' finished with exitCode {}.", (Object)this.file.getAbsolutePath(), (Object)exitCode);
                    }
                }
                catch (IOException e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Exception while executing '" + this.file.getAbsolutePath() + "'!", (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("Execution of '" + this.file.getAbsolutePath() + "' was interrupted.", (Throwable)e);
                }
            }
        }

        private class ErrorConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public ErrorConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                System.err.println(AutostartRunnable.this.file.getAbsolutePath() + ": " + line);
            }
        }

        private class OutConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public OutConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                if (AutostartRunnable.this.logger.isInfoEnabled()) {
                    AutostartRunnable.this.logger.info("{}: {}", (Object)AutostartRunnable.this.file.getAbsolutePath(), (Object)line);
                }
            }
        }

        abstract class AbstractOutputConsumerRunnable
        implements Runnable {
            private BufferedReader inputReader;

            public AbstractOutputConsumerRunnable(InputStream input) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
            }

            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = this.inputReader.readLine()) != null) {
                            this.processLine(line);
                        }
                    }
                    catch (IOException e) {
                        if (!AutostartRunnable.this.logger.isDebugEnabled()) break block3;
                        AutostartRunnable.this.logger.debug("Exception while reading from process '" + AutostartRunnable.this.file.getAbsolutePath() + "'.", (Throwable)e);
                    }
                }
            }

            public abstract void processLine(String var1);
        }
    }

    private class ShutdownRunnable
    implements Runnable {
        private ShutdownRunnable() {
        }

        public void run() {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Executing shutdown hook...");
            }
            if (MainFrame.this.gotoSource != null) {
                MainFrame.this.gotoSource.stop();
                MainFrame.this.gotoSource = null;
            }
            for (AutostartRunnable current : MainFrame.this.autostartProcesses) {
                current.destroyProcess();
            }
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Finished executing shutdown hook...");
            }
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (MainFrame.this.traySupport != null && MainFrame.this.traySupport.isActive() && MainFrame.this.applicationPreferences.isHidingOnClose()) {
                MainFrame.this.setFramesVisible(false);
            } else {
                MainFrame.this.exit();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventSourceComparator<T extends Serializable>
    implements Comparator<EventSource<T>> {
        @Override
        public int compare(EventSource<T> o1, EventSource<T> o2) {
            int compare;
            SourceIdentifier si2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            SourceIdentifier si1 = o1.getSourceIdentifier();
            if (si1 == (si2 = o2.getSourceIdentifier())) {
                return 0;
            }
            if (si1 == null) {
                return -1;
            }
            if (si2 == null) {
                return 1;
            }
            String primary1 = MainFrame.this.getPrimarySourceTitle(si1);
            String primary2 = MainFrame.this.getPrimarySourceTitle(si2);
            if (primary1 != null && primary2 != null && (compare = primary1.compareTo(primary2)) != 0) {
                return compare;
            }
            return o1.compareTo(o2);
        }
    }

    private class PreferencesChangeListener
    implements PropertyChangeListener {
        private PreferencesChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propName;
            block35: {
                propName = evt.getPropertyName();
                if ("soundLocations".equals(propName)) {
                    if (MainFrame.this.sounds != null) {
                        MainFrame.this.sounds.setSoundLocations((Map)evt.getNewValue());
                    }
                    return;
                }
                if ("sourceNames".equals(propName) || "showingIdentifier".equals(propName)) {
                    this.updateSourceTitles();
                    return;
                }
                if ("sourceFiltering".equals(propName)) {
                    MainFrame.this.updateStatus();
                    return;
                }
                if ("blackListName".equals(propName)) {
                    MainFrame.this.updateStatus();
                    return;
                }
                if ("whiteListName".equals(propName)) {
                    MainFrame.this.updateStatus();
                    return;
                }
                if ("mute".equals(propName)) {
                    if (MainFrame.this.sounds != null) {
                        MainFrame.this.sounds.setMute(((Boolean)evt.getNewValue()).booleanValue());
                    }
                    return;
                }
                if (!"applicationPath".equals(propName)) break block35;
                File newPath = (File)evt.getNewValue();
                File oldPath = MainFrame.this.applicationPreferences.getStartupApplicationPath();
                if (oldPath != null) {
                    File previousApplicationPathFile = new File(newPath, ".previous.application.path");
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(previousApplicationPathFile);
                        writer.append(oldPath.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        block34: {
                            try {
                                if (!MainFrame.this.logger.isWarnEnabled()) break block34;
                                MainFrame.this.logger.warn("Exception while writing previous application path to file '" + previousApplicationPathFile.getAbsolutePath() + "'!", (Throwable)ex);
                            }
                            catch (Throwable throwable) {
                                IOUtilities.closeQuietly(writer);
                                throw throwable;
                            }
                        }
                        IOUtilities.closeQuietly((Writer)writer);
                    }
                    IOUtilities.closeQuietly((Writer)writer);
                }
                MainFrame.this.showApplicationPathChangedDialog();
                return;
            }
            if ("lookAndFeel".equals(propName)) {
                MainFrame.this.showLookAndFeelChangedDialog();
                return;
            }
            if ("conditions".equals(propName)) {
                MainFrame.this.updateConditions();
                return;
            }
            if ("previousSearchStrings".equals(propName)) {
                MainFrame.this.updatePreviousSearchStrings();
                return;
            }
            if ("recentFiles".equals(propName)) {
                MainFrame.this.updateRecentFiles();
                return;
            }
            if ("showingFullRecentPath".equals(propName)) {
                MainFrame.this.updateRecentFiles();
                return;
            }
            if ("levelColors".equals(propName)) {
                MainFrame.this.levelColors = null;
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("statusColors".equals(propName)) {
                MainFrame.this.statusColors = null;
                MainFrame.this.updateAccessViews();
                return;
            }
            if ("showingFullCallstack".equals(propName)) {
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("usingWrappedExceptionStyle".equals(propName)) {
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("showingStackTrace".equals(propName)) {
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("scaleFactor".equals(propName)) {
                MainFrame.this.updateViewScale(MainFrame.this.applicationPreferences.getScaleFactor());
                return;
            }
            if ("showingToolbar".equals(propName)) {
                MainFrame.this.setShowingToolbar(MainFrame.this.applicationPreferences.isShowingToolbar());
                return;
            }
            if ("showingStatusbar".equals(propName)) {
                MainFrame.this.setShowingStatusbar(MainFrame.this.applicationPreferences.isShowingStatusbar());
                return;
            }
            if ("showingTipOfTheDay".equals(propName)) {
                MainFrame.this.setShowingTipOfTheDay(MainFrame.this.applicationPreferences.isShowingTipOfTheDay());
                return;
            }
            if ("checkingForUpdate".equals(propName)) {
                MainFrame.this.setCheckingForUpdate(MainFrame.this.applicationPreferences.isCheckingForUpdate());
                return;
            }
            if ("checkingForSnapshot".equals(propName)) {
                MainFrame.this.setCheckingForSnapshot(MainFrame.this.applicationPreferences.isCheckingForSnapshot());
                return;
            }
            if ("globalLoggingEnabled".equals(propName)) {
                MainFrame.this.setGlobalLoggingEnabled(MainFrame.this.applicationPreferences.isGlobalLoggingEnabled());
                return;
            }
            if ("loggingStatisticEnabled".equals(propName)) {
                MainFrame.this.setStatisticsEnabled(MainFrame.this.applicationPreferences.isLoggingStatisticEnabled());
                return;
            }
            if ("trayActive".equals(propName)) {
                if (MainFrame.this.traySupport != null) {
                    MainFrame.this.traySupport.setActive(MainFrame.this.applicationPreferences.isTrayActive());
                }
                return;
            }
            if ("coloringWholeRow".equals(propName)) {
                MainFrame.this.coloringWholeRow = MainFrame.this.applicationPreferences.isColoringWholeRow();
                MainFrame.this.updateLoggingViews();
            }
        }

        private void updateSourceTitles() {
            MainFrame.this.updateWindowMenus();
            Map loggingViews = MainFrame.this.loggingEventViewManager.getViews();
            for (Map.Entry current : loggingViews.entrySet()) {
                ViewContainer value = current.getValue();
                ViewWindow window = value.resolveViewWindow();
                if (window == null) continue;
                String title = MainFrame.this.resolveSourceTitle(value);
                window.setTitle(title);
            }
            Map accessViews = MainFrame.this.accessEventViewManager.getViews();
            for (Map.Entry current : accessViews.entrySet()) {
                ViewContainer value = current.getValue();
                ViewWindow window = value.resolveViewWindow();
                if (window == null) continue;
                String title = MainFrame.this.resolveSourceTitle(value);
                window.setTitle(title);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowViewRunnable
    implements Runnable {
        private ViewContainer<?> container;

        public ShowViewRunnable(ViewContainer<?> container) {
            this.container = container;
        }

        @Override
        public void run() {
            boolean isNew = false;
            if (this.container.getParent() == null) {
                isNew = true;
                if (!MainFrame.this.applicationPreferences.isUsingInternalFrames()) {
                    MainFrame.this.showFrame(this.container);
                } else {
                    MainFrame.this.showInternalFrame(this.container);
                }
            }
            MainFrame.this.updateWindowMenus();
            ViewWindow window = this.container.resolveViewWindow();
            if (!isNew || MainFrame.this.applicationPreferences.isAutoFocusingWindow()) {
                window.focusWindow();
            }
        }
    }

    private static class ScrollToBottomRunnable
    implements Runnable {
        private ViewWindow window;

        private ScrollToBottomRunnable(ViewWindow window) {
            this.window = window;
        }

        public void run() {
            ViewContainer viewContainer = this.window.getViewContainer();
            if (viewContainer != null) {
                viewContainer.scrollToEvent();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessEventSourceListener
    implements EventSourceListener<AccessEvent> {
        AccessEventSourceListener() {
        }

        public void eventSourceAdded(EventSource<AccessEvent> eventSource) {
            SwingUtilities.invokeLater(new AccessSourceAddedRunnable(eventSource));
        }

        public void eventSourceRemoved(EventSource<AccessEvent> eventSource) {
            SwingUtilities.invokeLater(new AccessSourceRemovedRunnable(eventSource));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AccessSourceRemovedRunnable
        implements Runnable {
            EventSource<AccessEvent> eventSource;

            public AccessSourceRemovedRunnable(EventSource<AccessEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveAccessViewContainer((EventSource<AccessEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.INACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceRemoved");
                }
                if (MainFrame.this.applicationPreferences.isAutoClosing()) {
                    MainFrame.this.accessEventViewManager.closeViewContainer(container);
                }
                MainFrame.this.accessEventSourceManager.removeEventProducer(this.eventSource.getSourceIdentifier());
                MainFrame.this.updateWindowMenus();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AccessSourceAddedRunnable
        implements Runnable {
            EventSource<AccessEvent> eventSource;

            public AccessSourceAddedRunnable(EventSource<AccessEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveAccessViewContainer((EventSource<AccessEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.ACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceAdded");
                }
                String primary = this.eventSource.getSourceIdentifier().getIdentifier();
                Map<String, String> sourceNames = MainFrame.this.applicationPreferences.getSourceNames();
                if (!sourceNames.containsKey(primary)) {
                    sourceNames = new HashMap<String, String>(sourceNames);
                    sourceNames.put(primary, primary);
                    MainFrame.this.applicationPreferences.setSourceNames(sourceNames);
                }
                if (MainFrame.this.applicationPreferences.isAutoOpening()) {
                    MainFrame.this.showAccessView(this.eventSource);
                } else {
                    MainFrame.this.updateWindowMenus();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingEventSourceListener
    implements EventSourceListener<LoggingEvent> {
        LoggingEventSourceListener() {
        }

        public void eventSourceAdded(EventSource<LoggingEvent> eventSource) {
            SwingUtilities.invokeLater(new LoggingSourceAddedRunnable(eventSource));
        }

        public void eventSourceRemoved(EventSource<LoggingEvent> eventSource) {
            SwingUtilities.invokeLater(new LoggingSourceRemovedRunnable(eventSource));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoggingSourceRemovedRunnable
        implements Runnable {
            EventSource<LoggingEvent> eventSource;

            public LoggingSourceRemovedRunnable(EventSource<LoggingEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.INACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceRemoved");
                }
                if (MainFrame.this.applicationPreferences.isAutoClosing()) {
                    MainFrame.this.loggingEventViewManager.closeViewContainer(container);
                }
                MainFrame.this.loggingEventSourceManager.removeEventProducer(this.eventSource.getSourceIdentifier());
                MainFrame.this.updateWindowMenus();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoggingSourceAddedRunnable
        implements Runnable {
            EventSource<LoggingEvent> eventSource;

            public LoggingSourceAddedRunnable(EventSource<LoggingEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.ACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceAdded");
                }
                String primary = this.eventSource.getSourceIdentifier().getIdentifier();
                Map<String, String> sourceNames = MainFrame.this.applicationPreferences.getSourceNames();
                if (!sourceNames.containsKey(primary)) {
                    sourceNames = new HashMap<String, String>(sourceNames);
                    sourceNames.put(primary, primary);
                    MainFrame.this.applicationPreferences.setSourceNames(sourceNames);
                }
                if (MainFrame.this.applicationPreferences.isAutoOpening()) {
                    MainFrame.this.showLoggingView(this.eventSource);
                } else {
                    MainFrame.this.updateWindowMenus();
                }
            }
        }
    }

    public class MyApplicationListener
    implements ApplicationListener {
        private final Logger logger = LoggerFactory.getLogger(MyApplicationListener.class);

        public void handleAbout(ApplicationEvent applicationEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleAbout: {}", (Object)applicationEvent);
            }
            MainFrame.this.viewActions.getAboutAction().actionPerformed(null);
            applicationEvent.setHandled(true);
        }

        public void handleOpenApplication(ApplicationEvent applicationEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleOpenApplication: {}", (Object)applicationEvent);
            }
        }

        public void handleOpenFile(ApplicationEvent applicationEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleOpenFile: {}\n\tfilename: {}", (Object)applicationEvent, (Object)applicationEvent.getFilename());
            }
            MainFrame.this.open(new File(applicationEvent.getFilename()));
        }

        public void handlePreferences(ApplicationEvent applicationEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handlePreferences: {}", (Object)applicationEvent);
            }
            MainFrame.this.viewActions.getPreferencesAction().actionPerformed(null);
        }

        public void handlePrintFile(ApplicationEvent applicationEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handlePrintFile: {}", (Object)applicationEvent);
            }
        }

        public void handleQuit(ApplicationEvent applicationEvent) {
            MainFrame.this.exit();
        }

        public void handleReOpenApplication(ApplicationEvent applicationEvent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleReOpenApplication: {}", (Object)applicationEvent);
            }
            MainFrame.this.setVisible(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportType {
        LOG4J,
        JUL;

    }
}

