/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.gotosrc;

import de.huxhorn.lilith.services.gotosrc.GoToSource;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingGoToSource
implements GoToSource {
    public static final int DEFAULT_PORT = 11111;
    private final BlockingQueue<StackTraceElement> queue = new LinkedBlockingQueue<StackTraceElement>();
    private final GoToSourceRunnable goToSourceRunnable = new GoToSourceRunnable();
    private Thread goToSourceThread = null;

    public SerializingGoToSource(int port) {
        this.setPort(port);
    }

    public SerializingGoToSource() {
        this(11111);
    }

    public int getPort() {
        return this.goToSourceRunnable.getPort();
    }

    public void setPort(int port) {
        this.goToSourceRunnable.setPort(port);
    }

    public void goToSource(StackTraceElement ste) {
        if (this.goToSourceThread == null) {
            this.goToSourceThread = new Thread(this.goToSourceRunnable);
            this.goToSourceThread.setDaemon(true);
            this.goToSourceThread.start();
        }
        if (ste == null) {
            return;
        }
        try {
            this.queue.put(ste);
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    public void stop() {
        if (this.goToSourceThread != null) {
            this.goToSourceThread.interrupt();
            this.goToSourceThread = null;
        }
    }

    private class GoToSourceRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(GoToSourceRunnable.class);
        private int port;
        private Socket socket;
        private ObjectOutputStream oos;

        private GoToSourceRunnable() {
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
            this.closeConnection();
        }

        private void openConnection() {
            try {
                this.socket = new Socket("localhost", this.port);
                this.oos = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            }
            catch (IOException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Exception while creating connection with IDE!", (Throwable)e);
                }
                this.closeConnection();
            }
        }

        private void closeConnection() {
            if (this.oos != null) {
                IOUtilities.closeQuietly((OutputStream)this.oos);
                this.oos = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
        }

        public void run() {
            while (true) {
                StackTraceElement ste;
                try {
                    ste = (StackTraceElement)SerializingGoToSource.this.queue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Go to source of {}.", (Object)ste);
                }
                if (this.oos == null) {
                    this.openConnection();
                }
                boolean error = false;
                if (this.oos != null) {
                    try {
                        this.oos.writeObject(ste);
                        this.oos.flush();
                    }
                    catch (IOException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Exception on first try, probably lingering connection.", (Throwable)e);
                        }
                        this.closeConnection();
                        error = true;
                    }
                }
                if (!error) continue;
                this.openConnection();
                if (this.oos == null) continue;
                try {
                    this.oos.writeObject(ste);
                    this.oos.flush();
                }
                catch (IOException e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Exception on second try!", (Throwable)e);
                    }
                    this.closeConnection();
                }
            }
        }
    }
}

