/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.clipboard;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class LoggingMdcFormatter
implements ClipboardFormatter {
    private static final long serialVersionUID = -8079057597454959907L;

    public String getName() {
        return "Copy MDC";
    }

    public String getDescription() {
        return "Copies the Mapped Diagnostic Context of the logging event to the clipboard.";
    }

    public String getAccelerator() {
        return null;
    }

    public boolean isCompatible(Object object) {
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
            LoggingEvent loggingEvent = (LoggingEvent)eventObj;
            Map mdc = loggingEvent.getMdc();
            return mdc != null && mdc.size() > 0;
        }
        return false;
    }

    public String toString(Object object) {
        LoggingEvent loggingEvent;
        Map mdc;
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent && (mdc = (loggingEvent = (LoggingEvent)eventObj).getMdc()) != null && mdc.size() > 0) {
            StringBuilder text = new StringBuilder();
            TreeMap sorted = new TreeMap(mdc);
            for (Map.Entry current : sorted.entrySet()) {
                text.append((String)current.getKey()).append("\t").append((String)current.getValue()).append("\n");
            }
            return text.toString();
        }
        return null;
    }
}

