/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.eventhandlers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventHandler;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDumpEventHandler<T extends Serializable>
implements EventHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(FileDumpEventHandler.class);
    private FileBuffer<EventWrapper<T>> fileBuffer;
    private boolean enabled = true;

    public FileDumpEventHandler(SourceIdentifier sourceIdentifier, FileBufferFactory<T> fileBufferFactory) {
        this.fileBuffer = fileBufferFactory.createActiveBuffer(sourceIdentifier);
    }

    public void handle(List<EventWrapper<T>> events) {
        if (this.enabled) {
            this.fileBuffer.addAll(events);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Wrote {} events to file.", (Object)events.size());
            }
        }
    }

    public Buffer<EventWrapper<T>> getBuffer() {
        return this.fileBuffer;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

