/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import java.io.Serializable;

public class MarkerContainsCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -4925872725394540757L;
    public static final String DESCRIPTION = "Marker.contains";
    private String searchString;

    public MarkerContainsCondition() {
        this(null);
    }

    public MarkerContainsCondition(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public boolean isTrue(Object element) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (element instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)element).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            Marker marker = event.getMarker();
            if (marker == null) {
                return false;
            }
            return marker.contains(this.searchString);
        }
        return false;
    }

    public MarkerContainsCondition clone() throws CloneNotSupportedException {
        return (MarkerContainsCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription()).append("(");
        if (this.searchString != null) {
            result.append("\"");
            result.append(this.searchString);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerContainsCondition that = (MarkerContainsCondition)o;
        return !(this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null);
    }

    public int hashCode() {
        return this.searchString != null ? this.searchString.hashCode() : 0;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

