/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db.configuration;

import de.akquinet.jbosscc.needle.db.configuration.EJB3Configuration;
import de.akquinet.jbosscc.needle.db.configuration.PersistenceConfiguration;
import de.akquinet.jbosscc.needle.db.configuration.PersistenceUnitConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public final class PersistenceConfigurationFactory
implements PersistenceConfiguration {
    private static final Map<PersistenceConfigurationFactory, PersistenceConfiguration> PERSISTENCE_MAP = new HashMap<PersistenceConfigurationFactory, PersistenceConfiguration>();
    private String persistenceUnit;
    private Class<?>[] cfgClazzes;

    public PersistenceConfigurationFactory(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public PersistenceConfigurationFactory(Class<?>[] cfgClazzes) {
        this.cfgClazzes = Arrays.copyOf(cfgClazzes, cfgClazzes.length);
    }

    private PersistenceConfiguration getPersistenceConfiguration() {
        return PersistenceConfigurationFactory.getPersistenceConfiguration(this);
    }

    String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    Class<?>[] getCfgClazzes() {
        return this.cfgClazzes;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.getPersistenceConfiguration().getEntityManager();
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return this.getPersistenceConfiguration().getEntityManagerFactory();
    }

    private static PersistenceConfiguration getPersistenceConfiguration(PersistenceConfigurationFactory configuration) {
        PersistenceConfiguration result = PERSISTENCE_MAP.get(configuration);
        if (result == null) {
            result = PersistenceConfigurationFactory.createPersistenceConfiguration(configuration);
            PERSISTENCE_MAP.put(configuration, result);
        }
        return result;
    }

    private static PersistenceConfiguration createPersistenceConfiguration(PersistenceConfigurationFactory configuration) {
        if (configuration.getPersistenceUnit() != null) {
            return new PersistenceUnitConfiguration(configuration.getPersistenceUnit());
        }
        if (configuration.getCfgClazzes() != null) {
            return new EJB3Configuration(configuration.getCfgClazzes());
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.cfgClazzes);
        result = 31 * result + (this.persistenceUnit == null ? 0 : this.persistenceUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceConfigurationFactory other = (PersistenceConfigurationFactory)obj;
        if (!Arrays.equals(this.cfgClazzes, other.cfgClazzes)) {
            return false;
        }
        return !(this.persistenceUnit == null ? other.persistenceUnit != null : !this.persistenceUnit.equals(other.persistenceUnit));
    }
}

