/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle;

import de.akquinet.jbosscc.needle.NeedleContext;
import de.akquinet.jbosscc.needle.ObjectUnderTestInstantiationException;
import de.akquinet.jbosscc.needle.annotation.ObjectUnderTest;
import de.akquinet.jbosscc.needle.injection.InjectionAnnotationProcessor;
import de.akquinet.jbosscc.needle.injection.InjectionConfiguration;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.injection.TestcaseInjectionProcessor;
import de.akquinet.jbosscc.needle.mock.MockAnnotationProcessor;
import de.akquinet.jbosscc.needle.mock.MockProvider;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NeedleTestcase {
    private static final Logger LOG = LoggerFactory.getLogger(NeedleTestcase.class);
    private final InjectionAnnotationProcessor injectionIntoAnnotationProcessor = new InjectionAnnotationProcessor();
    private final TestcaseInjectionProcessor testcaseInjectionProcessor = new TestcaseInjectionProcessor();
    private final MockAnnotationProcessor mockAnnotationProcessor = new MockAnnotationProcessor();
    private final InjectionConfiguration configuration = new InjectionConfiguration();
    private NeedleContext context;

    protected NeedleTestcase(InjectionProvider<?> ... injectionProvider) {
        this.addInjectionProvider(injectionProvider);
    }

    @Deprecated
    protected final void addInjectionProvider(InjectionProvider<?> ... injectionProvider) {
        this.configuration.addInjectionProvider(injectionProvider);
    }

    protected final void initTestcase(Object test) throws Exception {
        LOG.info("init testcase {}", test);
        this.context = new NeedleContext(test);
        List<Field> fields = this.context.getAnnotatedTestcaseFields(ObjectUnderTest.class);
        LOG.debug("found fields {}", fields);
        for (Field field : fields) {
            LOG.debug("found field {}", (Object)field.getName());
            try {
                Object instance = this.setInstanceIfNotNull(field, test);
                this.initInstance(instance);
            }
            catch (InstantiationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        this.mockAnnotationProcessor.process(this.context, this.configuration);
        this.injectionIntoAnnotationProcessor.process(this.context);
        this.testcaseInjectionProcessor.process(this.context, this.configuration);
    }

    protected final void initInstance(Object instance) {
        this.initFields(instance);
        this.initMethodInjection(instance);
    }

    private void initMethodInjection(Object instance) {
        List<Method> methods = ReflectionUtil.getMethods(instance.getClass());
        for (final Method method : methods) {
            Annotation[] annotations = method.getDeclaredAnnotations();
            if (!this.checkAnnotationIsSupported(annotations)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            InjectionTargetInformationFactory injectionTargetInformationFactory = new InjectionTargetInformationFactory(){

                @Override
                public InjectionTargetInformation create(Class<?> parameterType, int parameterIndex) {
                    return new InjectionTargetInformation(parameterType, method, method.getParameterAnnotations()[parameterIndex]);
                }
            };
            Object[] arguments = this.createArguments(parameterTypes, injectionTargetInformationFactory);
            try {
                ReflectionUtil.invokeMethod(method, instance, arguments);
            }
            catch (Exception e) {
                LOG.warn("could not invoke method", (Throwable)e);
            }
        }
    }

    private Object[] createArguments(Class<?>[] parameterTypes, InjectionTargetInformationFactory injectionTargetInformationFactory) {
        Object[] arguments = new Object[parameterTypes.length];
        block0: for (int i = 0; i < parameterTypes.length; ++i) {
            InjectionTargetInformation injectionTargetInformation = injectionTargetInformationFactory.create(parameterTypes[i], i);
            for (List<InjectionProvider<?>> collection : this.configuration.getInjectionProvider()) {
                Map.Entry<Object, Object> injection = this.configuration.handleInjectionProvider(collection, injectionTargetInformation);
                if (injection == null) continue;
                arguments[i] = injection.getValue();
                this.context.addInjectedObject(injection.getKey(), injection.getValue());
                continue block0;
            }
        }
        return arguments;
    }

    private void initFields(Object instance) {
        List<Field> fields = ReflectionUtil.getAllFields(instance.getClass());
        block2: for (Field field : fields) {
            InjectionTargetInformation injectionTargetInformation = new InjectionTargetInformation(field.getType(), field);
            for (List<InjectionProvider<?>> collection : this.configuration.getInjectionProvider()) {
                Map.Entry<Object, Object> injection = this.configuration.handleInjectionProvider(collection, injectionTargetInformation);
                if (injection == null) continue;
                try {
                    ReflectionUtil.setField(field, instance, injection.getValue());
                    this.context.addInjectedObject(injection.getKey(), injection.getValue());
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                continue block2;
            }
        }
    }

    private Object setInstanceIfNotNull(Field field, Object test) throws Exception {
        ObjectUnderTest objectUnderTestAnnotation = field.getAnnotation(ObjectUnderTest.class);
        String id = objectUnderTestAnnotation.id().equals("") ? field.getName() : objectUnderTestAnnotation.id();
        Object instance = ReflectionUtil.getFieldValue(test, field);
        if (instance == null) {
            Class<?> implementation;
            Class<?> clazz = implementation = objectUnderTestAnnotation.implementation() != Void.class ? objectUnderTestAnnotation.implementation() : field.getType();
            if (implementation.isInterface()) {
                throw new ObjectUnderTestInstantiationException("could not create an instance of object under test " + implementation + ", no implementation class configured");
            }
            instance = this.getInstanceByConstructorInjection(implementation);
            if (instance == null) {
                instance = this.createInstanceByNoArgConstructor(implementation);
            }
            try {
                ReflectionUtil.setField(field, test, instance);
            }
            catch (Exception e) {
                throw new ObjectUnderTestInstantiationException(e);
            }
        }
        this.context.addObjectUnderTest(id, instance);
        return instance;
    }

    private Object createInstanceByNoArgConstructor(Class<?> implementation) throws ObjectUnderTestInstantiationException {
        try {
            implementation.getConstructor(new Class[0]);
            return implementation.newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new ObjectUnderTestInstantiationException("could not create an instance of object under test " + implementation + ",implementation has no public no-arguments constructor", e);
        }
        catch (InstantiationException e) {
            throw new ObjectUnderTestInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectUnderTestInstantiationException(e);
        }
    }

    private Object getInstanceByConstructorInjection(Class<?> implementation) throws ObjectUnderTestInstantiationException {
        Constructor<?>[] constructors;
        for (final Constructor<?> constructor : constructors = implementation.getConstructors()) {
            Annotation[] annotations = constructor.getAnnotations();
            if (!this.checkAnnotationIsSupported(annotations)) continue;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            InjectionTargetInformationFactory injectionTargetInformationFactory = new InjectionTargetInformationFactory(){

                @Override
                public InjectionTargetInformation create(Class<?> parameterType, int parameterIndex) {
                    return new InjectionTargetInformation(parameterType, constructor, constructor.getParameterAnnotations()[parameterIndex]);
                }
            };
            Object[] arguments = this.createArguments(parameterTypes, injectionTargetInformationFactory);
            try {
                return constructor.newInstance(arguments);
            }
            catch (Exception e) {
                throw new ObjectUnderTestInstantiationException(e);
            }
        }
        return null;
    }

    private boolean checkAnnotationIsSupported(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!this.configuration.isAnnotationSupported(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public <X> X getInjectedObject(Object key) {
        return this.context.getInjectedObject(key);
    }

    public <X extends MockProvider> X getMockProvider() {
        return (X)this.configuration.getMockProvider();
    }

    private static interface InjectionTargetInformationFactory {
        public InjectionTargetInformation create(Class<?> var1, int var2);
    }
}

