/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jetty;

import com.google.common.collect.ImmutableList;
import com.yammer.dropwizard.validation.InvalidEntityException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class UnbrandedErrorHandler
extends ErrorHandler {
    public UnbrandedErrorHandler() {
        this.setShowStacks(false);
    }

    public void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        super.writeErrorPage(request, writer, code, message, showStacks);
    }

    protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        String uri = request.getRequestURI();
        this.writeErrorPageMessage(request, writer, code, message, uri);
        if (showStacks) {
            this.writeErrorPageStacks(request, writer);
        }
        for (int i = 0; i < 20; ++i) {
            writer.write("<br/>                                                \n");
        }
    }

    public void writeValidationErrorPage(HttpServletRequest request, StringWriter writer, InvalidEntityException exception) throws IOException {
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(request, writer, 422, "Unprocessable Entity");
        writer.write("</head>\n<body>");
        this.writeInvalidationErrorPageBody(request, writer, exception.getMessage(), exception.getErrors());
        writer.write("\n</body>\n</html>\n");
    }

    private void writeInvalidationErrorPageBody(HttpServletRequest request, StringWriter writer, String message, ImmutableList<String> errors) throws IOException {
        String uri = request.getRequestURI();
        this.writeErrorPageMessage(request, writer, 422, "Unprocessable Entity", uri);
        writer.write("<h2>");
        this.write(writer, message);
        writer.write("</h2>");
        writer.write("<ul>");
        for (String error : errors) {
            writer.write("<li>");
            this.write(writer, error);
            writer.write("</li>");
        }
        writer.write("</ul>");
    }
}

