/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.jetty.servlet.ServletHolder;

public class ServletBuilder {
    private final ServletHolder holder;
    private final ImmutableMap.Builder<String, ServletHolder> mappings;

    public ServletBuilder(ServletHolder holder, ImmutableMap.Builder<String, ServletHolder> mappings) {
        this.holder = holder;
        this.mappings = mappings;
    }

    public ServletBuilder setName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must be non-empty");
        this.holder.setName(name);
        return this;
    }

    public ServletBuilder setInitOrder(int order) {
        this.holder.setInitOrder(order);
        return this;
    }

    public ServletBuilder setInitParam(String name, String value) {
        this.holder.setInitParameter((String)Preconditions.checkNotNull((Object)name), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public ServletBuilder addInitParams(Map<String, String> params) {
        for (Map.Entry entry : ((Map)Preconditions.checkNotNull(params)).entrySet()) {
            this.setInitParam((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public ServletBuilder addUrlPattern(String urlPattern) {
        try {
            this.mappings.put(Preconditions.checkNotNull((Object)urlPattern), (Object)this.holder);
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException("Can't map this servlet to " + urlPattern + ", another servlet is already mapped to that.");
        }
        return this;
    }

    public ServletBuilder addUrlPatterns(String urlPattern, String ... urlPatterns) {
        this.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        for (String pattern : (String[])Preconditions.checkNotNull((Object)urlPatterns)) {
            this.addUrlPattern((String)Preconditions.checkNotNull((Object)pattern));
        }
        return this;
    }
}

