/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.google.common.base.Optional;
import com.yammer.dropwizard.config.LoggingConfiguration;
import com.yammer.dropwizard.logging.AsyncAppender;
import com.yammer.dropwizard.logging.LogbackFactory;
import com.yammer.metrics.logback.InstrumentedAppender;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.TimeZone;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggingFactory {
    private final LoggingConfiguration config;
    private final String name;

    public static void bootstrap() {
        LoggingConfiguration.ConsoleConfiguration console = new LoggingConfiguration.ConsoleConfiguration();
        console.setEnabled(true);
        console.setTimeZone(TimeZone.getDefault());
        console.setThreshold(Level.WARN);
        Logger root = LoggingFactory.getCleanRoot();
        root.addAppender(LogbackFactory.buildConsoleAppender(console, root.getLoggerContext(), (Optional<String>)Optional.absent()));
    }

    public LoggingFactory(LoggingConfiguration config, String name) {
        this.config = config;
        this.name = name;
    }

    public void configure() {
        LoggingConfiguration.SyslogConfiguration syslog;
        LoggingConfiguration.FileConfiguration file;
        this.hijackJDKLogging();
        Logger root = this.configureLevels();
        LoggingConfiguration.ConsoleConfiguration console = this.config.getConsoleConfiguration();
        if (console.isEnabled()) {
            root.addAppender(AsyncAppender.wrap(LogbackFactory.buildConsoleAppender(console, root.getLoggerContext(), console.getLogFormat())));
        }
        if ((file = this.config.getFileConfiguration()).isEnabled()) {
            root.addAppender(AsyncAppender.wrap(LogbackFactory.buildFileAppender(file, root.getLoggerContext(), file.getLogFormat())));
        }
        if ((syslog = this.config.getSyslogConfiguration()).isEnabled()) {
            root.addAppender(AsyncAppender.wrap((Appender<ILoggingEvent>)LogbackFactory.buildSyslogAppender(syslog, root.getLoggerContext(), this.name, syslog.getLogFormat())));
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("com.yammer:type=Logging");
            if (!server.isRegistered(objectName)) {
                server.registerMBean(new JMXConfigurator(root.getLoggerContext(), server, objectName), objectName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.configureInstrumentation(root);
    }

    private void configureInstrumentation(Logger root) {
        InstrumentedAppender appender = new InstrumentedAppender();
        appender.setContext((Context)root.getLoggerContext());
        appender.start();
        root.addAppender((Appender)appender);
    }

    private void hijackJDKLogging() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    private Logger configureLevels() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.getLoggerContext().reset();
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)root.getLoggerContext());
        propagator.setResetJUL(true);
        root.getLoggerContext().addListener((LoggerContextListener)propagator);
        root.setLevel(this.config.getLevel());
        for (Map.Entry entry : this.config.getLoggers().entrySet()) {
            ((Logger)LoggerFactory.getLogger((String)((String)entry.getKey()))).setLevel((Level)entry.getValue());
        }
        return root;
    }

    private static Logger getCleanRoot() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.detachAndStopAllAppenders();
        return root;
    }
}

