/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.assets;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import com.google.common.net.MediaType;
import com.yammer.dropwizard.assets.ResourceURL;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;

public class AssetServlet
extends HttpServlet {
    private static final long serialVersionUID = 6393345594784987908L;
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.HTML_UTF_8;
    private final String resourcePath;
    private final String uriPath;
    private final String indexFile;
    private final transient MimeTypes mimeTypes;
    private Charset defaultCharset = Charsets.UTF_8;

    public AssetServlet(String resourcePath, String uriPath, String indexFile) {
        String trimmedPath = CharMatcher.is((char)'/').trimFrom((CharSequence)resourcePath);
        this.resourcePath = trimmedPath.isEmpty() ? trimmedPath : trimmedPath + "/";
        String trimmedUri = CharMatcher.is((char)'/').trimTrailingFrom((CharSequence)uriPath);
        this.uriPath = trimmedUri.length() == 0 ? "/" : trimmedUri;
        this.indexFile = indexFile;
        this.mimeTypes = new MimeTypes();
    }

    public URL getResourceURL() {
        return Resources.getResource((String)this.resourcePath);
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            CachedAsset cachedAsset = this.loadAsset(req.getRequestURI());
            if (cachedAsset == null) {
                resp.sendError(404);
                return;
            }
            if (this.isCachedClientSide(req, cachedAsset)) {
                resp.sendError(304);
                return;
            }
            resp.setDateHeader("Last-Modified", cachedAsset.getLastModifiedTime());
            resp.setHeader("ETag", cachedAsset.getETag());
            Buffer mimeTypeOfExtension = this.mimeTypes.getMimeByExtension(req.getRequestURI());
            MediaType mediaType = DEFAULT_MEDIA_TYPE;
            if (mimeTypeOfExtension != null) {
                try {
                    mediaType = MediaType.parse((String)mimeTypeOfExtension.toString());
                    if (this.defaultCharset != null && mediaType.is(MediaType.ANY_TEXT_TYPE)) {
                        mediaType = mediaType.withCharset(this.defaultCharset);
                    }
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
            }
            resp.setContentType(mediaType.type() + "/" + mediaType.subtype());
            if (mediaType.charset().isPresent()) {
                resp.setCharacterEncoding(((Charset)mediaType.charset().get()).toString());
            }
            ServletOutputStream output = resp.getOutputStream();
            try {
                output.write(cachedAsset.getResource());
            }
            finally {
                output.close();
            }
        }
        catch (RuntimeException ignored) {
            resp.sendError(404);
        }
        catch (URISyntaxException ignored) {
            resp.sendError(404);
        }
    }

    private CachedAsset loadAsset(String key) throws URISyntaxException, IOException {
        long lastModified;
        Preconditions.checkArgument((boolean)key.startsWith(this.uriPath));
        String requestedResourcePath = CharMatcher.is((char)'/').trimFrom((CharSequence)key.substring(this.uriPath.length()));
        String absoluteRequestedResourcePath = this.resourcePath + requestedResourcePath;
        URL requestedResourceURL = Resources.getResource((String)absoluteRequestedResourcePath);
        if (ResourceURL.isDirectory(requestedResourceURL)) {
            if (this.indexFile != null) {
                requestedResourceURL = Resources.getResource((String)(absoluteRequestedResourcePath + '/' + this.indexFile));
            } else {
                return null;
            }
        }
        if ((lastModified = ResourceURL.getLastModified(requestedResourceURL)) < 1L) {
            lastModified = System.currentTimeMillis();
        }
        lastModified = lastModified / 1000L * 1000L;
        return new CachedAsset(Resources.toByteArray((URL)requestedResourceURL), lastModified);
    }

    private boolean isCachedClientSide(HttpServletRequest req, CachedAsset cachedAsset) {
        return cachedAsset.getETag().equals(req.getHeader("If-None-Match")) || req.getDateHeader("If-Modified-Since") >= cachedAsset.getLastModifiedTime();
    }

    private static class CachedAsset {
        private final byte[] resource;
        private final String eTag;
        private final long lastModifiedTime;

        private CachedAsset(byte[] resource, long lastModifiedTime) {
            this.resource = resource;
            this.eTag = Hashing.murmur3_128().hashBytes(resource).toString();
            this.lastModifiedTime = lastModifiedTime;
        }

        public byte[] getResource() {
            return this.resource;
        }

        public String getETag() {
            return this.eTag;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }
    }
}

