/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.PathSummaryImpl;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.ResourceImpl;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;

public class PathBasedResourceGroupImpl
implements ResourceGroup {
    private final String contextPath;
    private final String path;
    private final List<Resource> resources;

    public PathBasedResourceGroupImpl(String contextPath, String path, List<Resource> resources) {
        this.contextPath = contextPath;
        this.path = path;
        this.resources = resources;
    }

    public String getSlug() {
        return "resource_" + PathBasedResourceGroupImpl.scrubPathForSlug(this.path);
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getLabel() {
        return this.path;
    }

    public String getSortKey() {
        return this.path;
    }

    public String getDescription() {
        String description = null;
        TreeSet<com.webcohesion.enunciate.modules.jaxrs.model.Resource> definingResourceClasses = new TreeSet<com.webcohesion.enunciate.modules.jaxrs.model.Resource>((Comparator<com.webcohesion.enunciate.modules.jaxrs.model.Resource>)new TypeElementComparator());
        int methodCount = 0;
        block0: for (Resource resource : this.resources) {
            for (Method method : resource.getMethods()) {
                ++methodCount;
                if (description != null && method.getDescription() != null && !description.equals(method.getDescription())) {
                    description = null;
                    break block0;
                }
                description = method.getDescription();
                if (description == null || !description.trim().isEmpty()) continue;
                description = null;
            }
            if (!(resource instanceof ResourceImpl)) continue;
            definingResourceClasses.add(((ResourceImpl)resource).resourceMethod.getParent());
        }
        if ((methodCount > 1 || description == null) && definingResourceClasses.size() == 1) {
            description = ((com.webcohesion.enunciate.modules.jaxrs.model.Resource)definingResourceClasses.iterator().next()).getDocValue();
        }
        return description;
    }

    public String getDeprecated() {
        String deprecated = null;
        for (Resource resource : this.resources) {
            deprecated = resource.getDeprecated();
            if (deprecated != null) continue;
            return null;
        }
        return deprecated;
    }

    public List<PathSummary> getPaths() {
        TreeSet<String> methods = new TreeSet<String>();
        TreeSet<String> styles = new TreeSet<String>();
        for (Resource resource : this.resources) {
            for (Method method : resource.getMethods()) {
                methods.add(method.getHttpMethod());
                styles.addAll(method.getStyles());
            }
        }
        return Collections.singletonList(new PathSummaryImpl(this.path, methods, styles));
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    private static String scrubPathForSlug(String facetValue) {
        return facetValue.replace('/', '_').replace(':', '_').replace('{', '_').replace('}', '_');
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }

    public Set<Facet> getFacets() {
        TreeSet<Facet> facets = new TreeSet<Facet>();
        for (Resource resource : this.resources) {
            facets.addAll(resource.getFacets());
        }
        return facets;
    }

    public JavaDoc getJavaDoc() {
        return JavaDoc.EMPTY;
    }

    public Set<String> getStyles() {
        TreeSet<String> styles = new TreeSet<String>();
        for (Resource resource : this.resources) {
            styles.addAll(resource.getStyles());
        }
        return styles;
    }
}

