/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.PropertyMetadata;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.ReadOnly;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.Value;
import com.webcohesion.enunciate.util.BeanValidationUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class PropertyImpl
implements Property {
    private final Accessor accessor;
    private ApiRegistrationContext registrationContext;

    public PropertyImpl(Accessor accessor, ApiRegistrationContext registrationContext) {
        this.accessor = accessor;
        this.registrationContext = registrationContext;
    }

    public String getName() {
        if (this.accessor.isValue()) {
            return "(value)";
        }
        return this.accessor.getName();
    }

    public String getType() {
        return this.accessor.isAttribute() ? "attribute" : (this.accessor.isValue() ? "(value)" : "element");
    }

    public PropertyMetadata getNamespaceInfo() {
        return new PropertyMetadata(this.getNamespacePrefix(), this.getNamespace(), null);
    }

    public String getNamespacePrefix() {
        String namespace = this.getNamespace();
        String prefix = this.accessor.getContext().getNamespacePrefixes().get(namespace);
        if (namespace == null || "".equals(namespace)) {
            prefix = "";
        }
        return prefix;
    }

    public String getNamespace() {
        return this.accessor.getNamespace();
    }

    public boolean isRequired() {
        if (this.accessor instanceof Attribute) {
            return ((Attribute)this.accessor).isRequired();
        }
        if (this.accessor instanceof Value) {
            return true;
        }
        if (this.accessor instanceof com.webcohesion.enunciate.modules.jaxb.model.Element) {
            return ((com.webcohesion.enunciate.modules.jaxb.model.Element)this.accessor).isRequired();
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.accessor.getAnnotation(ReadOnly.class) != null || this.accessor.getJavaDoc().get((Object)"readonly") != null;
    }

    public String getMinMaxOccurs() {
        String minMaxOccurs = null;
        if (this.accessor instanceof Attribute) {
            minMaxOccurs = String.format("%s/1", ((Attribute)this.accessor).isRequired() ? "1" : "0");
        } else if (this.accessor instanceof Value) {
            minMaxOccurs = "0/1";
        } else if (this.accessor instanceof com.webcohesion.enunciate.modules.jaxb.model.Element) {
            minMaxOccurs = String.format("%s/%s", ((com.webcohesion.enunciate.modules.jaxb.model.Element)this.accessor).getMinOccurs(), ((com.webcohesion.enunciate.modules.jaxb.model.Element)this.accessor).getMaxOccurs());
        }
        return minMaxOccurs;
    }

    public String getDefaultValue() {
        String defaultValue = null;
        if (this.accessor instanceof com.webcohesion.enunciate.modules.jaxb.model.Element) {
            defaultValue = ((com.webcohesion.enunciate.modules.jaxb.model.Element)this.accessor).getDefaultValue();
        }
        return defaultValue;
    }

    public String getConstraints() {
        boolean required = false;
        if (this.accessor instanceof com.webcohesion.enunciate.modules.jaxb.model.Element) {
            required = ((com.webcohesion.enunciate.modules.jaxb.model.Element)this.accessor).isRequired();
        } else if (this.accessor instanceof Attribute) {
            required = ((Attribute)this.accessor).isRequired();
        }
        return BeanValidationUtils.describeConstraints((Element)((Object)this.accessor), (boolean)required);
    }

    public String getDescription() {
        JavaDoc.JavaDocTagList tags;
        JavaDoc doc = this.accessor.getJavaDoc(this.registrationContext.getTagHandler());
        String description = doc.toString();
        if (description.trim().isEmpty()) {
            description = null;
        }
        if (description == null && (tags = (JavaDoc.JavaDocTagList)doc.get((Object)"return")) != null && !tags.isEmpty()) {
            description = tags.toString();
        }
        return description;
    }

    public boolean isAttribute() {
        return this.accessor.isAttribute();
    }

    public DataTypeReference getDataType() {
        return new DataTypeReferenceImpl(this.accessor.getXmlType(), this.accessor.isCollectionType(), this.registrationContext);
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.accessor, (JavaDocTagHandler)this.registrationContext.getTagHandler());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.accessor.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.accessor.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.accessor.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.accessor.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.accessor), (Map)this.accessor.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public String getSince() {
        JavaDoc.JavaDocTagList sinceTags = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"since");
        return sinceTags == null ? null : sinceTags.toString();
    }
}

