/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedVariableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedReferenceType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.ParamDocComment;
import com.webcohesion.enunciate.javac.javadoc.ReturnDocComment;
import com.webcohesion.enunciate.javac.javadoc.ThrowsDocComment;
import java.beans.Introspector;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DecoratedExecutableElement
extends DecoratedElement<ExecutableElement>
implements ExecutableElement {
    private List<? extends VariableElement> parameters;
    private List<? extends TypeMirror> thrownTypes;
    private List<? extends TypeParameterElement> typeParameters;
    private TypeMirror typeMirror;

    public DecoratedExecutableElement(ExecutableElement delegate, DecoratedProcessingEnvironment env) {
        super(delegate, env);
    }

    protected DecoratedExecutableElement(DecoratedExecutableElement copy) {
        super(copy.delegate, copy.env);
        this.parameters = copy.parameters;
        this.thrownTypes = copy.thrownTypes;
        this.typeParameters = copy.typeParameters;
        this.typeMirror = copy.typeMirror;
    }

    private List<? extends TypeMirror> loadDecoratedThrownTypes(ExecutableElement delegate) {
        List<? extends TypeMirror> thrownTypes = TypeMirrorDecorator.decorate(delegate.getThrownTypes(), this.env);
        if (thrownTypes != null && !thrownTypes.isEmpty()) {
            for (TypeMirror typeMirror : thrownTypes) {
                ((DecoratedReferenceType)typeMirror).setDeferredDocComment(new ThrowsDocComment(this, String.valueOf(typeMirror)));
            }
        }
        return thrownTypes;
    }

    private List<? extends VariableElement> loadDecoratedParameters() {
        List<? extends VariableElement> parameters = ElementDecorator.decorate(((ExecutableElement)this.delegate).getParameters(), this.env);
        if (parameters != null) {
            for (VariableElement variableElement : parameters) {
                ((DecoratedVariableElement)variableElement).setDocComment(this.createParamDocComment(variableElement));
            }
        }
        return parameters;
    }

    protected ParamDocComment createParamDocComment(VariableElement param) {
        return new ParamDocComment(this, param.getSimpleName().toString());
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = ElementDecorator.decorate(((ExecutableElement)this.delegate).getTypeParameters(), this.env);
        }
        return this.typeParameters;
    }

    @Override
    public TypeMirror getReturnType() {
        if (this.typeMirror == null) {
            this.typeMirror = TypeMirrorDecorator.decorate(((ExecutableElement)this.delegate).getReturnType(), this.env);
            ((DecoratedTypeMirror)this.typeMirror).setDeferredDocComment(new ReturnDocComment(this));
        }
        return this.typeMirror;
    }

    @Override
    public boolean isVarArgs() {
        return ((ExecutableElement)this.delegate).isVarArgs();
    }

    @Override
    public TypeMirror getReceiverType() {
        return TypeMirrorDecorator.decorate(((ExecutableElement)this.delegate).getReceiverType(), this.env);
    }

    @Override
    public boolean isDefault() {
        return ((ExecutableElement)this.delegate).isDefault();
    }

    @Override
    public AnnotationValue getDefaultValue() {
        return ((ExecutableElement)this.delegate).getDefaultValue();
    }

    @Override
    public List<? extends VariableElement> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.loadDecoratedParameters();
        }
        return this.parameters;
    }

    @Override
    public List<? extends TypeMirror> getThrownTypes() {
        if (this.thrownTypes == null) {
            this.thrownTypes = this.loadDecoratedThrownTypes((ExecutableElement)this.delegate);
        }
        return this.thrownTypes;
    }

    public boolean isGetter() {
        return (this.getSimpleName().toString().startsWith("get") || this.isIs()) && this.getParameters().isEmpty();
    }

    private boolean isIs() {
        return this.getSimpleName().toString().startsWith("is") && (this.getReturnType().getKind() == TypeKind.BOOLEAN || ((DecoratedTypeMirror)this.getReturnType()).isInstanceOf(Boolean.class));
    }

    public boolean isSetter() {
        return this.getSimpleName().toString().startsWith("set") && this.getParameters().size() == 1;
    }

    public String getPropertyName() {
        String propertyName = null;
        if (this.isIs()) {
            propertyName = Introspector.decapitalize(this.getSimpleName().toString().substring(2));
        } else if (this.isGetter() || this.isSetter()) {
            propertyName = Introspector.decapitalize(this.getSimpleName().toString().substring(3));
        }
        return propertyName;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitExecutable(this, p);
    }
}

