/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.hilla.engine.ConfigurationException;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.commandrunner.CommandRunner;
import com.vaadin.hilla.engine.commandrunner.CommandRunnerException;
import com.vaadin.hilla.engine.commandrunner.GradleRunner;
import com.vaadin.hilla.engine.commandrunner.MavenRunner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTaskEndpointGenerator
implements FallibleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTaskEndpointGenerator.class);
    private static boolean firstRun = true;
    private final String buildDirectoryName;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final File outputDirectory;
    private final File projectDirectory;
    private final Function<String, URL> resourceFinder;
    private EngineConfiguration engineConfiguration;

    AbstractTaskEndpointGenerator(File projectDirectory, String buildDirectoryName, File outputDirectory, Function<String, URL> resourceFinder) {
        this.projectDirectory = Objects.requireNonNull(projectDirectory, "Project directory cannot be null");
        this.buildDirectoryName = Objects.requireNonNull(buildDirectoryName, "Build directory name cannot be null");
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "Output directory name cannot be null");
        this.resourceFinder = Objects.requireNonNull(resourceFinder, "Class finder cannot be null");
    }

    protected EngineConfiguration getEngineConfiguration() throws ExecutionFailedException {
        if (this.engineConfiguration == null) {
            this.prepareEngineConfiguration();
        }
        return this.engineConfiguration;
    }

    protected void prepareEngineConfiguration() throws ExecutionFailedException {
        Path configDir = this.projectDirectory.toPath().resolve(this.buildDirectoryName);
        ArrayList<Object> errorMessages = new ArrayList<Object>();
        if (firstRun) {
            this.logger.debug("Configure Hilla engine using build system plugin");
            Optional mavenConfigure = MavenRunner.forProject((File)this.projectDirectory, (String[])new String[]{"-q", "vaadin:configure"});
            Optional mavenConfigureVersion = this.getVaadinVersion().flatMap(version -> MavenRunner.forProject((File)this.projectDirectory, (String[])new String[]{"-q", "com.vaadin:vaadin-maven-plugin:" + version + ":configure"}));
            Optional gradleConfigure = GradleRunner.forProject((File)this.projectDirectory, (String[])new String[]{"-q", "hillaConfigure"});
            List runners = Stream.of(mavenConfigure, mavenConfigureVersion, gradleConfigure).flatMap(Optional::stream).toList();
            if (runners.isEmpty()) {
                throw new ExecutionFailedException(String.format("Failed to determine project directory for dev mode. Directory '%s' does not look like a Maven or Gradle project.", this.projectDirectory));
            }
            for (CommandRunner runner : runners) {
                try {
                    runner.run(null, false);
                    firstRun = false;
                    break;
                }
                catch (CommandRunnerException e) {
                    String message = "Failed to configure Hilla engine using " + runner.getClass().getSimpleName() + " with arguments " + Arrays.toString(runner.arguments());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(message, (Throwable)e);
                        continue;
                    }
                    errorMessages.add(message + ": " + e.getMessage());
                }
            }
            if (firstRun) {
                errorMessages.forEach((Consumer<Object>)((Consumer<String>)arg_0 -> ((Logger)this.logger).warn(arg_0)));
                throw new ExecutionFailedException("Failed to configure Hilla engine: no runner succeeded. Set log level to debug to see more details.");
            }
        }
        try {
            EngineConfiguration config = EngineConfiguration.loadDirectory((Path)configDir);
            if (config == null) {
                throw new ExecutionFailedException("Engine configuration is missing");
            }
            this.engineConfiguration = new EngineConfiguration.Builder(config).outputDir(this.outputDirectory.toPath()).create();
        }
        catch (ConfigurationException | IOException e) {
            throw new ExecutionFailedException("Failed to read Hilla engine configuration", e);
        }
    }

    private Optional<String> getVaadinVersion() {
        String vaadinVersion = null;
        try (InputStream vaadinPomProperties = this.resourceFinder.apply("META-INF/maven/com.vaadin/vaadin-core/pom.properties").openStream();){
            if (vaadinPomProperties != null) {
                Properties properties = new Properties();
                properties.load(vaadinPomProperties);
                vaadinVersion = properties.getProperty("version", "");
            } else {
                LOGGER.debug("Unable to determine Vaadin version. No META-INF/maven/com.vaadin/vaadin-core/pom.properties found");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to determine Vaadin version", (Throwable)e);
        }
        return Optional.ofNullable(vaadinVersion);
    }
}

