/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FewestConnectionsServerSet
extends ServerSet {
    private final BindRequest bindRequest;
    private final int[] ports;
    private final LDAPConnectionOptions connectionOptions;
    private final List<LDAPConnection> establishedConnections;
    private final PostConnectProcessor postConnectProcessor;
    private final SocketFactory socketFactory;
    private final String[] addresses;

    public FewestConnectionsServerSet(String[] addresses, int[] ports) {
        this(addresses, ports, null, null);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, socketFactory, connectionOptions, null, null);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "FewestConnectionsServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "FewestConnectionsServerSet addresses and ports arrays must be the same size.");
        this.addresses = addresses;
        this.ports = ports;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.establishedConnections = new ArrayList<LDAPConnection>(100);
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @Override
    public boolean includesAuthentication() {
        return this.bindRequest != null;
    }

    @Override
    public boolean includesPostConnectProcessing() {
        return this.postConnectProcessor != null;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    public synchronized LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        int[] counts = new int[this.addresses.length];
        Iterator<LDAPConnection> iterator = this.establishedConnections.iterator();
        while (iterator.hasNext()) {
            LDAPConnection conn = iterator.next();
            if (!conn.isConnected()) {
                iterator.remove();
                continue;
            }
            int slot = -1;
            for (int i = 0; i < this.addresses.length; ++i) {
                if (!this.addresses[i].equals(conn.getConnectedAddress()) || this.ports[i] != conn.getConnectedPort()) continue;
                slot = i;
                break;
            }
            if (slot < 0) {
                iterator.remove();
                break;
            }
            int n = slot;
            counts[n] = counts[n] + 1;
        }
        TreeMap<Integer, ArrayList<ObjectPair<String, Integer>>> m = new TreeMap<Integer, ArrayList<ObjectPair<String, Integer>>>();
        for (int i = 0; i < counts.length; ++i) {
            Integer count = counts[i];
            ArrayList<ObjectPair<String, Integer>> serverList = (ArrayList<ObjectPair<String, Integer>>)m.get(count);
            if (serverList == null) {
                serverList = new ArrayList<ObjectPair<String, Integer>>(counts.length);
                m.put(count, serverList);
            }
            serverList.add(new ObjectPair<String, Integer>(this.addresses[i], this.ports[i]));
        }
        LDAPException lastException = null;
        for (List l : m.values()) {
            for (ObjectPair p : l) {
                try {
                    LDAPConnection conn = new LDAPConnection(this.socketFactory, this.connectionOptions, (String)p.getFirst(), (Integer)p.getSecond());
                    FewestConnectionsServerSet.doBindPostConnectAndHealthCheckProcessing(conn, this.bindRequest, this.postConnectProcessor, healthCheck);
                    this.establishedConnections.add(conn);
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    lastException = le;
                }
            }
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("FewestConnectionsServerSet(servers={");
        for (int i = 0; i < this.addresses.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.addresses[i]);
            buffer.append(':');
            buffer.append(this.ports[i]);
        }
        buffer.append("}, includesAuthentication=");
        buffer.append(this.bindRequest != null);
        buffer.append(", includesPostConnectProcessing=");
        buffer.append(this.postConnectProcessor != null);
        buffer.append(", establishedConnections=");
        FewestConnectionsServerSet fewestConnectionsServerSet = this;
        synchronized (fewestConnectionsServerSet) {
            Iterator<LDAPConnection> iterator = this.establishedConnections.iterator();
            while (iterator.hasNext()) {
                LDAPConnection conn = iterator.next();
                if (conn.isConnected()) continue;
                iterator.remove();
            }
            buffer.append(this.establishedConnections.size());
        }
        buffer.append(')');
    }
}

