/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.ArgumentException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public abstract class Argument
implements Serializable {
    private static final long serialVersionUID = -6938320885602903919L;
    private boolean isHidden;
    private boolean isRegistered;
    private final boolean isRequired;
    private boolean isUsageArgument;
    private final ArrayList<Character> shortIdentifiers;
    private int maxOccurrences;
    private int numOccurrences;
    private final String description;
    private final ArrayList<String> longIdentifiers;
    private final String valuePlaceholder;

    protected Argument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        if (description == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_DESCRIPTION_NULL.get());
        }
        if (shortIdentifier == null && longIdentifier == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_NO_IDENTIFIERS.get());
        }
        this.shortIdentifiers = new ArrayList(1);
        if (shortIdentifier != null) {
            this.shortIdentifiers.add(shortIdentifier);
        }
        this.longIdentifiers = new ArrayList(1);
        if (longIdentifier != null) {
            this.longIdentifiers.add(longIdentifier);
        }
        this.isRequired = isRequired;
        this.valuePlaceholder = valuePlaceholder;
        this.description = description;
        this.maxOccurrences = maxOccurrences > 0 ? maxOccurrences : Integer.MAX_VALUE;
        this.numOccurrences = 0;
        this.isHidden = false;
        this.isRegistered = false;
        this.isUsageArgument = false;
    }

    public final boolean hasShortIdentifier() {
        return !this.shortIdentifiers.isEmpty();
    }

    public final Character getShortIdentifier() {
        if (this.shortIdentifiers.isEmpty()) {
            return null;
        }
        return this.shortIdentifiers.get(0);
    }

    public final List<Character> getShortIdentifiers() {
        return Collections.unmodifiableList(this.shortIdentifiers);
    }

    public final void addShortIdentifier(Character c) throws ArgumentException {
        if (this.isRegistered) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_ID_CHANGE_AFTER_REGISTERED.get(this.getIdentifierString()));
        }
        this.shortIdentifiers.add(c);
    }

    public final boolean hasLongIdentifier() {
        return !this.longIdentifiers.isEmpty();
    }

    public final String getLongIdentifier() {
        if (this.longIdentifiers.isEmpty()) {
            return null;
        }
        return this.longIdentifiers.get(0);
    }

    public final List<String> getLongIdentifiers() {
        return Collections.unmodifiableList(this.longIdentifiers);
    }

    public final void addLongIdentifier(String s) throws ArgumentException {
        if (this.isRegistered) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_ID_CHANGE_AFTER_REGISTERED.get(this.getIdentifierString()));
        }
        this.longIdentifiers.add(s);
    }

    public final String getIdentifierString() {
        if (this.longIdentifiers.isEmpty()) {
            return "-" + this.shortIdentifiers.get(0);
        }
        return "--" + this.longIdentifiers.get(0);
    }

    public final boolean isRequired() {
        return this.isRequired;
    }

    public final int getMaxOccurrences() {
        return this.maxOccurrences;
    }

    public final void setMaxOccurrences(int maxOccurrences) {
        this.maxOccurrences = maxOccurrences <= 0 ? Integer.MAX_VALUE : maxOccurrences;
    }

    public boolean takesValue() {
        return this.valuePlaceholder != null;
    }

    public final String getValuePlaceholder() {
        return this.valuePlaceholder;
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean isHidden() {
        return this.isHidden;
    }

    public final void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public final boolean isUsageArgument() {
        return this.isUsageArgument;
    }

    public final void setUsageArgument(boolean isUsageArgument) {
        this.isUsageArgument = isUsageArgument;
    }

    public final boolean isPresent() {
        return this.numOccurrences > 0 || this.hasDefaultValue();
    }

    public final int getNumOccurrences() {
        return this.numOccurrences;
    }

    final void incrementOccurrences() throws ArgumentException {
        if (this.numOccurrences >= this.maxOccurrences) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        ++this.numOccurrences;
    }

    protected abstract void addValue(String var1) throws ArgumentException;

    protected abstract boolean hasDefaultValue();

    boolean isRegistered() {
        return this.isRegistered;
    }

    void setRegistered() throws ArgumentException {
        if (this.isRegistered) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_ALREADY_REGISTERED.get(this.getIdentifierString()));
        }
        this.isRegistered = true;
    }
}

