/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum UtilityMessages {
    ERR_BASE64_DECODE_INVALID_LENGTH("A base64-encoded string must have a length that is a multiple of 4 bytes."),
    ERR_BASE64_DECODE_UNEXPECTED_CHAR("Invalid character ''{0}'' encountered."),
    ERR_BASE64_DECODE_UNEXPECTED_EQUAL("Unexpected equal sign found at position {0,number,0}."),
    ERR_BS_BUFFER_ARRAY_NULL("The provided array is null."),
    ERR_BS_BUFFER_BUFFER_NULL("The provided buffer is null."),
    ERR_BS_BUFFER_BYTE_STRING_NULL("The provided byte string is null."),
    ERR_BS_BUFFER_CAPACITY_NEGATIVE("The provided capacity {0,number,0} is negative."),
    ERR_BS_BUFFER_CHAR_SEQUENCE_NULL("The provided character sequence is null."),
    ERR_BS_BUFFER_LENGTH_NEGATIVE("The provided length {0,number,0} is negative."),
    ERR_BS_BUFFER_OFFSET_NEGATIVE("The provided offset {0,number,0} is negative."),
    ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE("The provided offset {0,number,0} plus the provided length {1,number,0} is greater than the size of the provided array ({2,number,0})."),
    ERR_BS_BUFFER_POS_NEGATIVE("The provided position {0,number,0} is negative."),
    ERR_BS_BUFFER_POS_TOO_LARGE("The provided position {0,number,0} is greater than the length of the buffer ({1,number,0})."),
    ERR_FILE_VALUE_PATTERN_NOT_USABLE("Unable to access data in file ''{0}'' for use in the value pattern:  {1}"),
    ERR_FIXED_ARRAY_OS_WRITE_BEYOND_END("Attempted to write beyond the end of the array backing the output stream"),
    ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH("Unable to parse the provided timestamp ''{0}'' because it had an invalid number of characters before the sub-second and/or time zone portion."),
    ERR_GENTIME_DECODE_CANNOT_PARSE_TZ("Unable to parse time zone information from the provided timestamp ''{0}''."),
    ERR_HTTP_VALUE_PATTERN_NOT_USABLE("Unable to access data from ''{0}'' for use in the value pattern:  {1}"),
    ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER("Unable to create the key manager for secure communication:  {0}"),
    ERR_LDAP_TOOL_CANNOT_CREATE_SSL_CONTEXT("Unable to create the SSL context to for StartTLS communication with the server:  {0}"),
    ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY("Unable to create the SSL socket factory to use for secure communication with the server:  {0}"),
    ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD("Unable to read the bind password:  {0}"),
    ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD("Unable to read the key store password:  {0}"),
    ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD("Unable to read the trust store password:  {0}"),
    ERR_LDAP_TOOL_HOST_PORT_COUNT_MISMATCH("If either the ''--{0}'' or ''--{1}'' arguments are provided multiple times, then both arguments must be provided the same number of times."),
    ERR_LDAP_TOOL_INVALID_SASL_OPTION("SASL option ''{0}'' cannot be used with the {1} mechanism."),
    ERR_LDAP_TOOL_MALFORMED_SASL_OPTION("SASL option ''{0}'' is invalid.  SASL options must be in the form ''name=value''."),
    ERR_LDAP_TOOL_MISSING_REQUIRED_SASL_OPTION("SASL option ''{0}'' is required for use with the {1} mechanism."),
    ERR_LDAP_TOOL_NO_SASL_MECH("One or more SASL options were provided, but the ''mech'' option was not given to indicate which SASL mechanism to use."),
    ERR_LDAP_TOOL_START_TLS_FAILED("StartTLS negotiation failed:  {0}"),
    ERR_LDAP_TOOL_UNSUPPORTED_SASL_MECH("SASL mechanism ''{0}'' is not supported."),
    ERR_NO_EXCEPTION("No Exception"),
    ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE("{0}.  Thread stack trace:  {1}"),
    ERR_VALIDATOR_FALSE_CHECK_FAILURE("A result of true was found for a condition which the LDAP SDK requires to be false.  Thread stack trace {0}"),
    ERR_VALIDATOR_NULL_CHECK_FAILURE("A null object was provided where a non-null object is required (non-null index {0,number,0}).  Thread stack trace:  {1}"),
    ERR_VALIDATOR_TRUE_CHECK_FAILURE("A result of false was found for a condition which the LDAP SDK requires to be true.  Thread stack trace {0}"),
    ERR_VALUE_PATTERN_COMPONENT_EMPTY_FILE("The specified file does not contain any data."),
    ERR_VALUE_PATTERN_EMPTY_FORMAT("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length format string."),
    ERR_VALUE_PATTERN_EMPTY_INCREMENT("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length increment."),
    ERR_VALUE_PATTERN_EMPTY_LOWER_BOUND("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length lower bound."),
    ERR_VALUE_PATTERN_EMPTY_UPPER_BOUND("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length upper bound."),
    ERR_VALUE_PATTERN_INVALID_CHARACTER("The provided value pattern string contained an invalid character ''{0}'' at position {1,number,0}."),
    ERR_VALUE_PATTERN_NO_DELIMITER("The provided value pattern string contained a numeric range starting at position {0,number,0} which did not contain either a dash or colon to separate the lower bound from the upper bound."),
    ERR_VALUE_PATTERN_UNMATCHED_CLOSE("The provided value pattern string contained an unmatched closing brace at position {0,number,0}."),
    ERR_VALUE_PATTERN_UNMATCHED_OPEN("The provided value pattern string contained an unmatched opening brace at position {0,number,0}."),
    ERR_VALUE_PATTERN_VALUE_NOT_LONG("The provided value pattern string contained a numeric range starting at position {0,number,0} with a value that is outside the acceptable range.  Values must be between {1,number,0} and {2,number,0}."),
    INFO_CL_TOOL_DESCRIPTION_HELP("Display usage information for this program."),
    INFO_CL_TOOL_LABEL_EXAMPLES("Examples"),
    INFO_COLUMN_LABEL_TIMESTAMP("Timestamp"),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_DN("The DN to use to bind to the directory server when performing simple authentication."),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_PW("The password to use to bind to the directory server when performing simple authentication or a password-based SASL mechanism."),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_FILE("The path to the file containing the password to use to bind to the directory server when performing simple authentication or a password-based SASL mechanism."),
    INFO_LDAP_TOOL_DESCRIPTION_CERT_NICKNAME("The nickname (alias) of the client certificate in the key store to present to the directory server for SSL client authentication."),
    INFO_LDAP_TOOL_DESCRIPTION_HOST("The IP address or resolvable name to use to connect to the directory server.  If this is not provided, then a default value of 'localhost' will be used."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD("The password to use to access the key store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the key store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PATH("The path to the file to use as the key store for obtaining client certificates when communicating securely with the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_PORT("The port to use to connect to the directory server.  If this is not provided, then a default value of 389 will be used."),
    INFO_LDAP_TOOL_DESCRIPTION_SASL_OPTION("A name-value pair providing information to use when performing SASL authentication."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_ALL("Trust any certificate presented by the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD("The password to use to access the trust store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the trust store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PATH("The path to the file to use as trust store when determining whether to trust a certificate presented by the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_USE_SSL("Use SSL when communicating with the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_USE_START_TLS("Use StartTLS when communicating with the directory server."),
    INFO_LDAP_TOOL_PLACEHOLDER_CERT_NICKNAME("{nickname}"),
    INFO_LDAP_TOOL_PLACEHOLDER_DN("{dn}"),
    INFO_LDAP_TOOL_PLACEHOLDER_HOST("{host}"),
    INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD("{password}"),
    INFO_LDAP_TOOL_PLACEHOLDER_PATH("{path}"),
    INFO_LDAP_TOOL_PLACEHOLDER_PORT("{port}"),
    INFO_LDAP_TOOL_PLACEHOLDER_SASL_OPTION("{name=value}"),
    INFO_NUM_DAYS_PLURAL("{0,number,0} days"),
    INFO_NUM_DAYS_SINGULAR("{0,number,0} day"),
    INFO_NUM_HOURS_PLURAL("{0,number,0} hours"),
    INFO_NUM_HOURS_SINGULAR("{0,number,0} hour"),
    INFO_NUM_MINUTES_PLURAL("{0,number,0} minutes"),
    INFO_NUM_MINUTES_SINGULAR("{0,number,0} minute"),
    INFO_NUM_SECONDS_PLURAL("{0,number,0} seconds"),
    INFO_NUM_SECONDS_SINGULAR("{0,number,0} second"),
    INFO_NUM_SECONDS_WITH_DECIMAL("{0} seconds");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<UtilityMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<UtilityMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private UtilityMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            s = RESOURCE_BUNDLE.getString(this.name());
            MESSAGE_STRINGS.putIfAbsent(this, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            f = RESOURCE_BUNDLE == null ? new MessageFormat(this.defaultText) : new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            return f.format(args);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("util");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

