/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.text.ParseException;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    public static String encode(String data) {
        Validator.ensureNotNull(data);
        return Base64.encode(StaticUtils.getBytes(data));
    }

    public static String encode(byte[] data) {
        Validator.ensureNotNull(data);
        StringBuilder buffer = new StringBuilder(4 * data.length / 3 + 1);
        Base64.encode(data, buffer);
        return buffer.toString();
    }

    public static void encode(String data, StringBuilder buffer) {
        Validator.ensureNotNull(data);
        Base64.encode(StaticUtils.getBytes(data), buffer);
    }

    public static void encode(byte[] data, StringBuilder buffer) {
        Validator.ensureNotNull(data);
        if (data.length == 0) {
            return;
        }
        int pos = 0;
        for (int i = 0; i < data.length / 3; ++i) {
            int intValue = (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
            buffer.append(BASE64_ALPHABET[intValue >> 18 & 0x3F]);
            buffer.append(BASE64_ALPHABET[intValue >> 12 & 0x3F]);
            buffer.append(BASE64_ALPHABET[intValue >> 6 & 0x3F]);
            buffer.append(BASE64_ALPHABET[intValue & 0x3F]);
        }
        switch (data.length - pos) {
            case 1: {
                int intValue = (data[pos] & 0xFF) << 16;
                buffer.append(BASE64_ALPHABET[intValue >> 18 & 0x3F]);
                buffer.append(BASE64_ALPHABET[intValue >> 12 & 0x3F]);
                buffer.append("==");
                return;
            }
            case 2: {
                int intValue = (data[pos++] & 0xFF) << 16 | (data[pos] & 0xFF) << 8;
                buffer.append(BASE64_ALPHABET[intValue >> 18 & 0x3F]);
                buffer.append(BASE64_ALPHABET[intValue >> 12 & 0x3F]);
                buffer.append(BASE64_ALPHABET[intValue >> 6 & 0x3F]);
                buffer.append('=');
                return;
            }
        }
    }

    public static void encode(byte[] data, ByteStringBuffer buffer) {
        Validator.ensureNotNull(data);
        if (data.length == 0) {
            return;
        }
        int pos = 0;
        for (int i = 0; i < data.length / 3; ++i) {
            int intValue = (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
            buffer.append(BASE64_ALPHABET[intValue >> 18 & 0x3F]);
            buffer.append(BASE64_ALPHABET[intValue >> 12 & 0x3F]);
            buffer.append(BASE64_ALPHABET[intValue >> 6 & 0x3F]);
            buffer.append(BASE64_ALPHABET[intValue & 0x3F]);
        }
        switch (data.length - pos) {
            case 1: {
                int intValue = (data[pos] & 0xFF) << 16;
                buffer.append(BASE64_ALPHABET[intValue >> 18 & 0x3F]);
                buffer.append(BASE64_ALPHABET[intValue >> 12 & 0x3F]);
                buffer.append("==");
                return;
            }
            case 2: {
                int intValue = (data[pos++] & 0xFF) << 16 | (data[pos] & 0xFF) << 8;
                buffer.append(BASE64_ALPHABET[intValue >> 18 & 0x3F]);
                buffer.append(BASE64_ALPHABET[intValue >> 12 & 0x3F]);
                buffer.append(BASE64_ALPHABET[intValue >> 6 & 0x3F]);
                buffer.append('=');
                return;
            }
        }
    }

    public static byte[] decode(String data) throws ParseException {
        Validator.ensureNotNull(data);
        int length = data.length();
        if (length == 0) {
            return new byte[0];
        }
        if (length % 4 != 0) {
            throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_INVALID_LENGTH.get(), length);
        }
        int numBytes = 3 * (length / 4);
        if (data.charAt(length - 2) == '=') {
            numBytes -= 2;
        } else if (data.charAt(length - 1) == '=') {
            --numBytes;
        }
        byte[] b = new byte[numBytes];
        int stringPos = 0;
        int arrayPos = 0;
        while (stringPos < length) {
            int intValue = 0;
            block72: for (int i = 0; i < 4; ++i) {
                intValue <<= 6;
                switch (data.charAt(stringPos++)) {
                    case 'A': {
                        intValue |= 0;
                        continue block72;
                    }
                    case 'B': {
                        intValue |= 1;
                        continue block72;
                    }
                    case 'C': {
                        intValue |= 2;
                        continue block72;
                    }
                    case 'D': {
                        intValue |= 3;
                        continue block72;
                    }
                    case 'E': {
                        intValue |= 4;
                        continue block72;
                    }
                    case 'F': {
                        intValue |= 5;
                        continue block72;
                    }
                    case 'G': {
                        intValue |= 6;
                        continue block72;
                    }
                    case 'H': {
                        intValue |= 7;
                        continue block72;
                    }
                    case 'I': {
                        intValue |= 8;
                        continue block72;
                    }
                    case 'J': {
                        intValue |= 9;
                        continue block72;
                    }
                    case 'K': {
                        intValue |= 0xA;
                        continue block72;
                    }
                    case 'L': {
                        intValue |= 0xB;
                        continue block72;
                    }
                    case 'M': {
                        intValue |= 0xC;
                        continue block72;
                    }
                    case 'N': {
                        intValue |= 0xD;
                        continue block72;
                    }
                    case 'O': {
                        intValue |= 0xE;
                        continue block72;
                    }
                    case 'P': {
                        intValue |= 0xF;
                        continue block72;
                    }
                    case 'Q': {
                        intValue |= 0x10;
                        continue block72;
                    }
                    case 'R': {
                        intValue |= 0x11;
                        continue block72;
                    }
                    case 'S': {
                        intValue |= 0x12;
                        continue block72;
                    }
                    case 'T': {
                        intValue |= 0x13;
                        continue block72;
                    }
                    case 'U': {
                        intValue |= 0x14;
                        continue block72;
                    }
                    case 'V': {
                        intValue |= 0x15;
                        continue block72;
                    }
                    case 'W': {
                        intValue |= 0x16;
                        continue block72;
                    }
                    case 'X': {
                        intValue |= 0x17;
                        continue block72;
                    }
                    case 'Y': {
                        intValue |= 0x18;
                        continue block72;
                    }
                    case 'Z': {
                        intValue |= 0x19;
                        continue block72;
                    }
                    case 'a': {
                        intValue |= 0x1A;
                        continue block72;
                    }
                    case 'b': {
                        intValue |= 0x1B;
                        continue block72;
                    }
                    case 'c': {
                        intValue |= 0x1C;
                        continue block72;
                    }
                    case 'd': {
                        intValue |= 0x1D;
                        continue block72;
                    }
                    case 'e': {
                        intValue |= 0x1E;
                        continue block72;
                    }
                    case 'f': {
                        intValue |= 0x1F;
                        continue block72;
                    }
                    case 'g': {
                        intValue |= 0x20;
                        continue block72;
                    }
                    case 'h': {
                        intValue |= 0x21;
                        continue block72;
                    }
                    case 'i': {
                        intValue |= 0x22;
                        continue block72;
                    }
                    case 'j': {
                        intValue |= 0x23;
                        continue block72;
                    }
                    case 'k': {
                        intValue |= 0x24;
                        continue block72;
                    }
                    case 'l': {
                        intValue |= 0x25;
                        continue block72;
                    }
                    case 'm': {
                        intValue |= 0x26;
                        continue block72;
                    }
                    case 'n': {
                        intValue |= 0x27;
                        continue block72;
                    }
                    case 'o': {
                        intValue |= 0x28;
                        continue block72;
                    }
                    case 'p': {
                        intValue |= 0x29;
                        continue block72;
                    }
                    case 'q': {
                        intValue |= 0x2A;
                        continue block72;
                    }
                    case 'r': {
                        intValue |= 0x2B;
                        continue block72;
                    }
                    case 's': {
                        intValue |= 0x2C;
                        continue block72;
                    }
                    case 't': {
                        intValue |= 0x2D;
                        continue block72;
                    }
                    case 'u': {
                        intValue |= 0x2E;
                        continue block72;
                    }
                    case 'v': {
                        intValue |= 0x2F;
                        continue block72;
                    }
                    case 'w': {
                        intValue |= 0x30;
                        continue block72;
                    }
                    case 'x': {
                        intValue |= 0x31;
                        continue block72;
                    }
                    case 'y': {
                        intValue |= 0x32;
                        continue block72;
                    }
                    case 'z': {
                        intValue |= 0x33;
                        continue block72;
                    }
                    case '0': {
                        intValue |= 0x34;
                        continue block72;
                    }
                    case '1': {
                        intValue |= 0x35;
                        continue block72;
                    }
                    case '2': {
                        intValue |= 0x36;
                        continue block72;
                    }
                    case '3': {
                        intValue |= 0x37;
                        continue block72;
                    }
                    case '4': {
                        intValue |= 0x38;
                        continue block72;
                    }
                    case '5': {
                        intValue |= 0x39;
                        continue block72;
                    }
                    case '6': {
                        intValue |= 0x3A;
                        continue block72;
                    }
                    case '7': {
                        intValue |= 0x3B;
                        continue block72;
                    }
                    case '8': {
                        intValue |= 0x3C;
                        continue block72;
                    }
                    case '9': {
                        intValue |= 0x3D;
                        continue block72;
                    }
                    case '+': {
                        intValue |= 0x3E;
                        continue block72;
                    }
                    case '/': {
                        intValue |= 0x3F;
                        continue block72;
                    }
                    case '=': {
                        switch (length - stringPos) {
                            case 0: {
                                b[arrayPos++] = (byte)((intValue >>= 8) >> 8 & 0xFF);
                                b[arrayPos] = (byte)(intValue & 0xFF);
                                return b;
                            }
                            case 1: {
                                b[arrayPos] = (byte)((intValue >>= 10) & 0xFF);
                                return b;
                            }
                        }
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_EQUAL.get(stringPos - 1), stringPos - 1);
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_CHAR.get(Character.valueOf(data.charAt(stringPos - 1))), stringPos - 1);
                    }
                }
            }
            b[arrayPos++] = (byte)(intValue >> 16 & 0xFF);
            b[arrayPos++] = (byte)(intValue >> 8 & 0xFF);
            b[arrayPos++] = (byte)(intValue & 0xFF);
        }
        return b;
    }

    public static String decodeToString(String data) throws ParseException {
        Validator.ensureNotNull(data);
        byte[] decodedBytes = Base64.decode(data);
        return StaticUtils.toUTF8String(decodedBytes);
    }
}

