/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSet;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Modification
implements Serializable {
    private static final ASN1OctetString[] NO_VALUES = new ASN1OctetString[0];
    private static final String[] NO_STRING_VALUES = new String[0];
    private static final byte[][] NO_BYTE_VALUES = new byte[0][];
    private static final long serialVersionUID = 5170107037390858876L;
    private final ASN1OctetString[] values;
    private final ModificationType modificationType;
    private final String attributeName;

    public Modification(ModificationType modificationType, String attributeName) {
        Validator.ensureNotNull(attributeName);
        this.modificationType = modificationType;
        this.attributeName = attributeName;
        this.values = NO_VALUES;
    }

    public Modification(ModificationType modificationType, String attributeName, String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.modificationType = modificationType;
        this.attributeName = attributeName;
        this.values = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
    }

    public Modification(ModificationType modificationType, String attributeName, byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.modificationType = modificationType;
        this.attributeName = attributeName;
        this.values = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
    }

    public Modification(ModificationType modificationType, String attributeName, String ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        this.modificationType = modificationType;
        this.attributeName = attributeName;
        this.values = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ASN1OctetString(attributeValues[i]);
        }
    }

    public Modification(ModificationType modificationType, String attributeName, byte[] ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        this.modificationType = modificationType;
        this.attributeName = attributeName;
        this.values = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ASN1OctetString(attributeValues[i]);
        }
    }

    public Modification(ModificationType modificationType, String attributeName, ASN1OctetString[] attributeValues) {
        this.modificationType = modificationType;
        this.attributeName = attributeName;
        this.values = attributeValues;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public Attribute getAttribute() {
        return new Attribute(this.attributeName, (MatchingRule)CaseIgnoreStringMatchingRule.getInstance(), this.values);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String[] getValues() {
        if (this.values.length == 0) {
            return NO_STRING_VALUES;
        }
        String[] stringValues = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringValues[i] = this.values[i].stringValue();
        }
        return stringValues;
    }

    public byte[][] getValueByteArrays() {
        if (this.values.length == 0) {
            return NO_BYTE_VALUES;
        }
        byte[][] byteValues = new byte[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            byteValues[i] = this.values[i].getValue();
        }
        return byteValues;
    }

    public ASN1OctetString[] getRawValues() {
        return this.values;
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence modSequence = buffer.beginSequence();
        buffer.addEnumerated(this.modificationType.intValue());
        ASN1BufferSequence attrSequence = buffer.beginSequence();
        buffer.addOctetString(this.attributeName);
        ASN1BufferSet valueSet = buffer.beginSet();
        for (ASN1OctetString v : this.values) {
            buffer.addElement(v);
        }
        valueSet.end();
        attrSequence.end();
        modSequence.end();
    }

    public ASN1Sequence encode() {
        ASN1Element[] attrElements = new ASN1Element[]{new ASN1OctetString(this.attributeName), new ASN1Set(this.values)};
        ASN1Element[] modificationElements = new ASN1Element[]{new ASN1Enumerated(this.modificationType.intValue()), new ASN1Sequence(attrElements)};
        return new ASN1Sequence(modificationElements);
    }

    public static Modification readFrom(ASN1StreamReader reader) throws LDAPException {
        try {
            Validator.ensureNotNull(reader.beginSequence());
            ModificationType modType = ModificationType.valueOf(reader.readEnumerated());
            Validator.ensureNotNull(reader.beginSequence());
            String attrName = reader.readString();
            ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(5);
            ASN1StreamReaderSet valueSet = reader.beginSet();
            while (valueSet.hasMoreElements()) {
                valueList.add(new ASN1OctetString(reader.readBytes()));
            }
            ASN1OctetString[] values = new ASN1OctetString[valueList.size()];
            valueList.toArray(values);
            return new Modification(modType, attrName, values);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public static Modification decode(ASN1Sequence modificationSequence) throws LDAPException {
        ASN1Set valueSet;
        ASN1Sequence attrSequence;
        int modType;
        Validator.ensureNotNull(modificationSequence);
        ASN1Element[] modificationElements = modificationSequence.elements();
        if (modificationElements.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_INVALID_ELEMENT_COUNT.get(modificationElements.length));
        }
        try {
            ASN1Enumerated typeEnumerated = ASN1Enumerated.decodeAsEnumerated(modificationElements[0]);
            modType = typeEnumerated.intValue();
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_CANNOT_PARSE_MOD_TYPE.get(StaticUtils.getExceptionMessage(ae)), ae);
        }
        try {
            attrSequence = ASN1Sequence.decodeAsSequence(modificationElements[1]);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_CANNOT_PARSE_ATTR.get(StaticUtils.getExceptionMessage(ae)), ae);
        }
        ASN1Element[] attrElements = attrSequence.elements();
        if (attrElements.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_INVALID_ATTR_ELEMENT_COUNT.get(attrElements.length));
        }
        String attrName = ASN1OctetString.decodeAsOctetString(attrElements[0]).stringValue();
        try {
            valueSet = ASN1Set.decodeAsSet(attrElements[1]);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_CANNOT_PARSE_ATTR_VALUE_SET.get(StaticUtils.getExceptionMessage(ae)), ae);
        }
        ASN1Element[] valueElements = valueSet.elements();
        ASN1OctetString[] values = new ASN1OctetString[valueElements.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ASN1OctetString.decodeAsOctetString(valueElements[i]);
        }
        return new Modification(ModificationType.valueOf(modType), attrName, values);
    }

    public int hashCode() {
        int hashCode = this.modificationType.intValue() + StaticUtils.toLowerCase(this.attributeName).hashCode();
        for (ASN1OctetString value : this.values) {
            hashCode += value.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Modification)) {
            return false;
        }
        Modification mod = (Modification)o;
        if (this.modificationType != mod.modificationType) {
            return false;
        }
        if (!this.attributeName.equalsIgnoreCase(mod.attributeName)) {
            return false;
        }
        if (this.values.length != mod.values.length) {
            return false;
        }
        for (ASN1OctetString value : this.values) {
            boolean found = false;
            for (int j = 0; j < mod.values.length; ++j) {
                if (!value.equalsIgnoreType(mod.values[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPModification(type=");
        switch (this.modificationType.intValue()) {
            case 0: {
                buffer.append("add");
                break;
            }
            case 1: {
                buffer.append("delete");
                break;
            }
            case 2: {
                buffer.append("replace");
                break;
            }
            case 3: {
                buffer.append("increment");
                break;
            }
            default: {
                buffer.append(this.modificationType);
            }
        }
        buffer.append(", attr=");
        buffer.append(this.attributeName);
        buffer.append(", values={");
        if (this.values.length > 0) {
            buffer.append('\'');
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    buffer.append("', '");
                }
                buffer.append(this.values[i].stringValue());
            }
            buffer.append('\'');
        }
        buffer.append("})");
    }
}

