/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.extensions.NoticeOfDisconnectionExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.WakeableSleeper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@InternalUseOnly
final class LDAPConnectionReader
extends Thread
implements HandshakeCompletedListener {
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 4096;
    private volatile ASN1StreamReader asn1StreamReader;
    private volatile boolean closeRequested;
    private final ConcurrentHashMap<Integer, ResponseAcceptor> acceptorMap;
    private volatile Exception startTLSException;
    private volatile InputStream inputStream;
    private volatile OutputStream startTLSOutputStream;
    private final LDAPConnection connection;
    private Socket socket;
    private volatile SSLContext sslContext;
    private volatile Thread thread;
    private final WakeableSleeper startTLSSleeper;

    LDAPConnectionReader(LDAPConnection connection, LDAPConnectionInternals connectionInternals) throws IOException {
        this.connection = connection;
        this.setName(this.constructThreadName(connectionInternals));
        this.setDaemon(true);
        this.socket = connectionInternals.getSocket();
        this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 4096);
        this.asn1StreamReader = new ASN1StreamReader(this.inputStream, connection.getConnectionOptions().getMaxMessageSize());
        this.acceptorMap = new ConcurrentHashMap();
        this.closeRequested = false;
        this.sslContext = null;
        this.startTLSException = null;
        this.startTLSOutputStream = null;
        this.startTLSSleeper = new WakeableSleeper();
        if (!connectionInternals.synchronousMode()) {
            if (this.socket instanceof SSLSocket) {
                this.socket.setSoTimeout(0);
                SSLSocket sslSocket = (SSLSocket)this.socket;
                sslSocket.addHandshakeCompletedListener(this);
                sslSocket.startHandshake();
            } else {
                this.socket.setSoTimeout(50);
            }
        }
    }

    void registerResponseAcceptor(int messageID, ResponseAcceptor acceptor) throws LDAPException {
        if (this.acceptorMap.putIfAbsent(messageID, acceptor) != null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_MSGID_IN_USE.get());
        }
    }

    void deregisterResponseAcceptor(int messageID) {
        this.acceptorMap.remove(messageID);
    }

    int getActiveOperationCount() {
        return this.acceptorMap.size();
    }

    public void run() {
        boolean reconnect = false;
        this.thread = Thread.currentThread();
        while (!this.closeRequested) {
            try {
                ResponseAcceptor responseAcceptor;
                LDAPResponse response;
                try {
                    response = LDAPMessage.readLDAPResponseFrom(this.asn1StreamReader, true, this.connection.getCachedSchema());
                }
                catch (LDAPException le) {
                    String message;
                    Throwable t = le.getCause();
                    if (t != null && t instanceof SocketTimeoutException) {
                        SocketTimeoutException ste = (SocketTimeoutException)t;
                        Debug.debugException(Level.FINEST, ste);
                        if (this.sslContext == null) continue;
                        try {
                            this.socket.setSoTimeout(0);
                            SSLSocketFactory socketFactory = this.sslContext.getSocketFactory();
                            SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(this.socket, this.connection.getConnectedAddress(), this.socket.getPort(), true);
                            sslSocket.addHandshakeCompletedListener(this);
                            sslSocket.startHandshake();
                            this.inputStream = new BufferedInputStream(sslSocket.getInputStream(), 4096);
                            this.asn1StreamReader = new ASN1StreamReader(this.inputStream, this.connection.getConnectionOptions().getMaxMessageSize());
                            this.startTLSOutputStream = sslSocket.getOutputStream();
                            this.socket = sslSocket;
                            this.startTLSSleeper.wakeup();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            this.connection.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, StaticUtils.getExceptionMessage(e), e);
                            this.startTLSException = e;
                            this.closeRequested = true;
                            if (this.thread != null) {
                                this.thread.setName(this.thread.getName() + " (closed)");
                                this.thread = null;
                            }
                            this.closeInternal(true, StaticUtils.getExceptionMessage(e));
                            this.startTLSSleeper.wakeup();
                            return;
                        }
                        this.sslContext = null;
                        continue;
                    }
                    Debug.debugException(le);
                    Level debugLevel = Level.SEVERE;
                    if (t == null) {
                        this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                        message = le.getMessage();
                        debugLevel = Level.WARNING;
                    } else if (t instanceof IOException) {
                        this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                        debugLevel = Level.WARNING;
                    } else if (t instanceof ASN1Exception) {
                        this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                    } else {
                        this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, le.getMessage(), t);
                        message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                    }
                    Debug.debug(debugLevel, DebugType.LDAP, message, t);
                    if (this.connection.getConnectionOptions().autoReconnect()) {
                        reconnect = true;
                        break;
                    }
                    this.closeRequested = true;
                    if (this.thread != null) {
                        this.thread.setName(this.thread.getName() + " (closed)");
                        this.thread = null;
                    }
                    this.closeInternal(true, message);
                    return;
                }
                if (response == null) {
                    this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITHOUT_NOTICE, null, null);
                    if (!this.closeRequested && !this.connection.unbindRequestSent() && this.connection.getConnectionOptions().autoReconnect()) {
                        reconnect = true;
                        break;
                    }
                    this.closeRequested = true;
                    if (this.thread != null) {
                        this.thread.setName(this.thread.getName() + " (closed)");
                        this.thread = null;
                    }
                    this.closeInternal(true, null);
                    return;
                }
                Debug.debugLDAPResult(response);
                if (response instanceof SearchResultEntry || response instanceof SearchResultReference) {
                    responseAcceptor = this.acceptorMap.get(response.getMessageID());
                } else {
                    if (response instanceof IntermediateResponse) {
                        IntermediateResponse ir = (IntermediateResponse)response;
                        responseAcceptor = this.acceptorMap.get(response.getMessageID());
                        IntermediateResponseListener l = null;
                        if (responseAcceptor instanceof LDAPRequest) {
                            LDAPRequest r = (LDAPRequest)((Object)responseAcceptor);
                            l = r.getIntermediateResponseListener();
                        } else if (responseAcceptor instanceof IntermediateResponseListener) {
                            l = (IntermediateResponseListener)((Object)responseAcceptor);
                        }
                        if (l == null) {
                            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(ir)));
                            continue;
                        }
                        try {
                            l.intermediateResponseReturned(ir);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                        continue;
                    }
                    responseAcceptor = this.acceptorMap.remove(response.getMessageID());
                }
                if (responseAcceptor == null) {
                    if (response instanceof ExtendedResult && response.getMessageID() == 0) {
                        ExtendedResult extendedResult = (ExtendedResult)response;
                        String oid = extendedResult.getOID();
                        if ("1.3.6.1.4.1.1466.20036".equals(oid)) {
                            extendedResult = new NoticeOfDisconnectionExtendedResult(extendedResult);
                            this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITH_NOTICE, extendedResult.getDiagnosticMessage(), null);
                        } else if ("1.3.6.1.4.1.30221.2.6.5".equals(oid)) {
                            try {
                                Class<?> c = Class.forName("com.unboundid.ldap.sdk.unboundidds.extensions.InteractiveTransactionAbortedExtendedResult");
                                Constructor<?> ctor = c.getConstructor(ExtendedResult.class);
                                extendedResult = (ExtendedResult)ctor.newInstance(extendedResult);
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        UnsolicitedNotificationHandler handler = this.connection.getConnectionOptions().getUnsolicitedNotificationHandler();
                        if (handler == null) {
                            if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION.get(response));
                            continue;
                        }
                        handler.handleUnsolicitedNotification(this.connection, extendedResult);
                        continue;
                    }
                    if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                    Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_NO_ACCEPTOR.get(response));
                    continue;
                }
                try {
                    responseAcceptor.responseReceived(response);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.ERR_READER_ACCEPTOR_ERROR.get(String.valueOf(response), this.connection.getHostPort(), StaticUtils.getExceptionMessage(le)), le);
                }
            }
            catch (Exception e) {
                String message;
                Debug.debugException(e);
                Level debugLevel = Level.SEVERE;
                if (e instanceof IOException) {
                    this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, null, e);
                    message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                    debugLevel = Level.WARNING;
                } else if (e instanceof ASN1Exception) {
                    this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, null, e);
                    message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                } else {
                    this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, e);
                    message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                }
                Debug.debug(debugLevel, DebugType.LDAP, message, e);
                if (this.connection.getConnectionOptions().autoReconnect()) {
                    reconnect = true;
                    break;
                }
                this.closeRequested = true;
                if (this.thread != null) {
                    this.thread.setName(this.thread.getName() + " (closed)");
                    this.thread = null;
                }
                this.closeInternal(true, message);
                return;
            }
        }
        if (this.thread != null) {
            this.thread.setName(this.constructThreadName(null));
            this.thread = null;
        }
        if (reconnect && !this.connection.closeRequested()) {
            try {
                this.connection.reconnect();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else {
            this.closeInternal(true, null);
        }
    }

    LDAPResponse readResponse(int messageID) throws LDAPException {
        try {
            while (true) {
                LDAPResponse response;
                if ((response = LDAPMessage.readLDAPResponseFrom(this.asn1StreamReader, false, this.connection.getCachedSchema())) == null) {
                    return new ConnectionClosedResponse(ResultCode.SERVER_DOWN, null);
                }
                if (response.getMessageID() == messageID) {
                    return response;
                }
                if (response instanceof ExtendedResult && response.getMessageID() == 0) {
                    ExtendedResult extendedResult = (ExtendedResult)response;
                    String oid = extendedResult.getOID();
                    if ("1.3.6.1.4.1.1466.20036".equals(oid)) {
                        extendedResult = new NoticeOfDisconnectionExtendedResult(extendedResult);
                        this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITH_NOTICE, extendedResult.getDiagnosticMessage(), null);
                    } else if ("1.3.6.1.4.1.30221.2.6.5".equals(oid)) {
                        try {
                            Class<?> c = Class.forName("com.unboundid.ldap.sdk.unboundidds.extensions.InteractiveTransactionAbortedExtendedResult");
                            Constructor<?> ctor = c.getConstructor(ExtendedResult.class);
                            extendedResult = (ExtendedResult)ctor.newInstance(extendedResult);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    UnsolicitedNotificationHandler handler = this.connection.getConnectionOptions().getUnsolicitedNotificationHandler();
                    if (handler == null) {
                        if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                        Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION.get(response));
                        continue;
                    }
                    handler.handleUnsolicitedNotification(this.connection, extendedResult);
                    continue;
                }
                if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_DISCARDING_UNEXPECTED_RESPONSE.get(response, messageID));
            }
        }
        catch (LDAPException le) {
            String message;
            Debug.debugException(le);
            Throwable t = le.getCause();
            if (t != null && t instanceof SocketTimeoutException) {
                throw new LDAPException(ResultCode.TIMEOUT, le.getMessage(), le);
            }
            Level debugLevel = Level.SEVERE;
            if (t == null) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                message = le.getMessage();
                debugLevel = Level.WARNING;
            } else if (t instanceof IOException) {
                this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, le.getMessage(), t);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
                debugLevel = Level.WARNING;
            } else if (t instanceof ASN1Exception) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, le.getMessage(), t);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
            } else {
                this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, le.getMessage(), t);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(t));
            }
            Debug.debug(debugLevel, DebugType.LDAP, message, t);
            if (this.connection.getConnectionOptions().autoReconnect() && !this.closeRequested) {
                this.connection.reconnect();
            } else {
                this.closeRequested = true;
                this.closeInternal(true, message);
            }
            throw le;
        }
        catch (Exception e) {
            String message;
            Debug.debugException(e);
            Level debugLevel = Level.SEVERE;
            if (e instanceof IOException) {
                this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, null, e);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
                debugLevel = Level.WARNING;
            } else if (e instanceof ASN1Exception) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, null, e);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
            } else {
                this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, e);
                message = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(e));
            }
            Debug.debug(debugLevel, DebugType.LDAP, message, e);
            if (this.connection.getConnectionOptions().autoReconnect() && !this.closeRequested) {
                this.connection.reconnect();
            } else {
                this.closeRequested = true;
                this.closeInternal(true, message);
            }
            throw new LDAPException(ResultCode.SERVER_DOWN, message, e);
        }
    }

    OutputStream doStartTLS(SSLContext sslContext) throws LDAPException {
        if (this.connection.synchronousMode()) {
            try {
                this.socket.setSoTimeout(0);
                SSLSocketFactory socketFactory = sslContext.getSocketFactory();
                SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(this.socket, this.connection.getConnectedAddress(), this.socket.getPort(), true);
                sslSocket.startHandshake();
                this.inputStream = new BufferedInputStream(sslSocket.getInputStream(), 4096);
                this.asn1StreamReader = new ASN1StreamReader(this.inputStream, this.connection.getConnectionOptions().getMaxMessageSize());
                this.startTLSOutputStream = sslSocket.getOutputStream();
                this.socket = sslSocket;
                OutputStream outputStream = this.startTLSOutputStream;
                this.startTLSOutputStream = null;
                return outputStream;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.connection.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, StaticUtils.getExceptionMessage(e), e);
                this.startTLSException = e;
                this.closeRequested = true;
                this.closeInternal(true, StaticUtils.getExceptionMessage(e));
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        this.sslContext = sslContext;
        while (true) {
            if (this.startTLSOutputStream != null) {
                OutputStream outputStream = this.startTLSOutputStream;
                this.startTLSOutputStream = null;
                return outputStream;
            }
            if (this.thread == null) {
                if (this.startTLSException == null) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED_NO_EXCEPTION.get());
                }
                Exception e = this.startTLSException;
                this.startTLSException = null;
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
            }
            this.startTLSSleeper.sleep(10L);
        }
    }

    void close(boolean notifyConnection) {
        this.closeRequested = true;
        for (int i = 0; i < 5; ++i) {
            try {
                Thread t = this.thread;
                if (t == null || t == Thread.currentThread() || !t.isAlive()) break;
                t.interrupt();
                t.join(100L);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.closeInternal(notifyConnection, null);
    }

    private void closeInternal(boolean notifyConnection, String message) {
        InputStream is = this.inputStream;
        this.inputStream = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (notifyConnection) {
            this.connection.setClosed();
        }
        Iterator iterator = this.acceptorMap.keySet().iterator();
        while (iterator.hasNext()) {
            int messageID = (Integer)iterator.next();
            ResponseAcceptor acceptor = this.acceptorMap.get(messageID);
            try {
                if (message == null) {
                    DisconnectType disconnectType = this.connection.getDisconnectType();
                    if (disconnectType == null) {
                        acceptor.responseReceived(new ConnectionClosedResponse(ResultCode.SERVER_DOWN, null));
                    } else {
                        acceptor.responseReceived(new ConnectionClosedResponse(disconnectType.getResultCode(), this.connection.getDisconnectMessage()));
                    }
                } else {
                    acceptor.responseReceived(new ConnectionClosedResponse(ResultCode.SERVER_DOWN, message));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            iterator.remove();
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        try {
            event.getSocket().setSoTimeout(50);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    Thread getReaderThread() {
        return this.thread;
    }

    void updateThreadName() {
        Thread t = this.thread;
        if (t != null) {
            t.setName(this.constructThreadName(this.connection.getConnectionInternals()));
        }
    }

    private String constructThreadName(LDAPConnectionInternals connectionInternals) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Connection reader for connection ");
        String name = this.connection.getConnectionName();
        if (name != null) {
            buffer.append('\'');
            buffer.append(name);
            buffer.append("' ");
        }
        if ((name = this.connection.getConnectionPoolName()) != null) {
            buffer.append("in pool '");
            buffer.append(name);
            buffer.append("' ");
        }
        if (connectionInternals == null) {
            buffer.append("(not connected)");
        } else {
            buffer.append("to ");
            buffer.append(connectionInternals.getHost());
            buffer.append(':');
            buffer.append(connectionInternals.getPort());
        }
        return buffer.toString();
    }
}

