/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.extensions.CancelExtendedRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import javax.net.ssl.SSLContext;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InternalSDKHelper {
    private InternalSDKHelper() {
    }

    @InternalUseOnly
    public static void convertToTLS(LDAPConnection connection, SSLContext sslContext) throws LDAPException {
        connection.convertToTLS(sslContext);
    }

    @InternalUseOnly
    public static AsyncRequestID createAsyncRequestID(int targetMessageID) {
        return new AsyncRequestID(targetMessageID);
    }

    @InternalUseOnly
    public static void cancel(LDAPConnection connection, int targetMessageID, Control ... controls) throws LDAPException {
        CancelExtendedRequest cancelRequest = new CancelExtendedRequest(targetMessageID);
        connection.sendMessage(new LDAPMessage(connection.nextMessageID(), (ProtocolOp)new ExtendedRequest(cancelRequest), controls));
    }

    @InternalUseOnly
    public static LDAPResult readLDAPResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return LDAPResult.readLDAPResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static BindResult readBindResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return BindResult.readBindResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static CompareResult readCompareResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return CompareResult.readCompareResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static ExtendedResult readExtendedResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return ExtendedResult.readExtendedResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static SearchResultEntry readSearchResultEntryFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader, Schema schema) throws LDAPException {
        return SearchResultEntry.readSearchEntryFrom(messageID, messageSequence, reader, schema);
    }

    @InternalUseOnly
    public static SearchResultReference readSearchResultReferenceFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return SearchResultReference.readSearchReferenceFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static SearchResult readSearchResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return SearchResult.readSearchResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static IntermediateResponse readIntermediateResponseFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return IntermediateResponse.readFrom(messageID, messageSequence, reader);
    }
}

