/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.Parameter;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jElement;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.util.Neo4jEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.neo4j.util.Neo4jVertexSequence;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;

public class Neo4jIndex<T extends Neo4jElement, S extends PropertyContainer>
implements Index<T> {
    private final Class<T> indexClass;
    protected final Neo4jGraph graph;
    private final String indexName;
    protected org.neo4j.graphdb.index.Index<S> rawIndex;

    public Neo4jIndex(String indexName, Class<T> indexClass, Neo4jGraph graph, Parameter ... indexParameters) {
        this.indexClass = indexClass;
        this.graph = graph;
        this.indexName = indexName;
        this.generateIndex(indexParameters);
    }

    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    public Class<T> getIndexClass() {
        if (Vertex.class.isAssignableFrom(this.indexClass)) {
            return Vertex.class;
        }
        return Edge.class;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void put(String key, Object value, T element) {
        try {
            this.graph.autoStartTransaction();
            this.rawIndex.add(((Neo4jElement)element).getRawElement(), key, value);
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CloseableSequence<T> get(String key, Object value) {
        IndexHits itty = value instanceof String && ((String)value).startsWith("%query%") ? this.rawIndex.query(key, (Object)((String)value).substring("%query%".length())) : this.rawIndex.get(key, value);
        if (this.indexClass.isAssignableFrom(Neo4jVertex.class)) {
            return new Neo4jVertexSequence((Iterable<Node>)itty, this.graph);
        }
        return new Neo4jEdgeSequence((Iterable<Relationship>)itty, this.graph);
    }

    public long count(String key, Object value) {
        return this.rawIndex.get(key, value).size();
    }

    public void remove(String key, Object value, T element) {
        try {
            this.graph.autoStartTransaction();
            this.rawIndex.remove(((Neo4jElement)element).getRawElement(), key, value);
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void removeBasic(String key, Object value, T element) {
        this.rawIndex.remove(((Neo4jElement)element).getRawElement(), key, value);
    }

    protected void putBasic(String key, Object value, T element) {
        this.rawIndex.add(((Neo4jElement)element).getRawElement(), key, value);
    }

    private void generateIndex(Parameter<Object, Object> ... indexParameters) {
        this.rawIndex = this.indexClass.isAssignableFrom(Neo4jVertex.class) ? (indexParameters.length > 0 ? this.graph.getRawGraph().index().forNodes(this.indexName, Neo4jIndex.generateParameterMap(indexParameters)) : this.graph.getRawGraph().index().forNodes(this.indexName)) : (indexParameters.length > 0 ? this.graph.getRawGraph().index().forRelationships(this.indexName, Neo4jIndex.generateParameterMap(indexParameters)) : this.graph.getRawGraph().index().forRelationships(this.indexName));
        IndexManager manager = this.getIndexManager();
        String storedType = (String)manager.getConfiguration(this.rawIndex).get("_blueprints:type");
        if (null == storedType) {
            if (this instanceof AutomaticIndex) {
                this.getIndexManager().setConfiguration(this.rawIndex, "_blueprints:type", Index.Type.AUTOMATIC.toString());
            } else {
                this.getIndexManager().setConfiguration(this.rawIndex, "_blueprints:type", Index.Type.MANUAL.toString());
            }
        } else if (this.getIndexType() != Index.Type.valueOf((String)storedType)) {
            throw new RuntimeException("Stored index is " + storedType + " and is being loaded as a " + this.getIndexType() + " index");
        }
    }

    protected IndexManager getIndexManager() {
        return this.graph.getRawGraph().index();
    }

    public String toString() {
        return StringFactory.indexString((Index)this);
    }

    private static Map<String, String> generateParameterMap(Parameter<Object, Object> ... indexParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter<Object, Object> parameter : indexParameters) {
            map.put(parameter.getKey().toString(), parameter.getValue().toString());
        }
        return map;
    }
}

