/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public abstract class Neo4jElement
implements Element {
    protected final Neo4jGraph graph;
    protected PropertyContainer rawElement;

    public Neo4jElement(Neo4jGraph graph) {
        this.graph = graph;
    }

    public Object getProperty(String key) {
        if (this.rawElement.hasProperty(key)) {
            return this.rawElement.getProperty(key);
        }
        return null;
    }

    public void setProperty(String key, Object value) {
        if (key.equals("id") || key.equals("label") && this instanceof Edge) {
            throw new RuntimeException(key + " is a reserved property key");
        }
        try {
            this.graph.autoStartTransaction();
            Object oldValue = this.getProperty(key);
            for (Neo4jAutomaticIndex<?, PropertyContainer> autoIndex : this.graph.getAutoIndices(this.getClass())) {
                autoIndex.autoUpdate(key, value, oldValue, this);
            }
            this.rawElement.setProperty(key, value);
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object removeProperty(String key) {
        try {
            this.graph.autoStartTransaction();
            Object oldValue = this.rawElement.removeProperty(key);
            if (null != oldValue) {
                for (Neo4jAutomaticIndex<?, PropertyContainer> autoIndex : this.graph.getAutoIndices(this.getClass())) {
                    autoIndex.autoRemove(key, oldValue, this);
                }
            }
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            return oldValue;
        }
        catch (NotFoundException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            return null;
        }
        catch (RuntimeException e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw e;
        }
        catch (Exception e) {
            this.graph.autoStopTransaction(TransactionalGraph.Conclusion.FAILURE);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.rawElement.getPropertyKeys()) {
            keys.add(key);
        }
        return keys;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public PropertyContainer getRawElement() {
        return this.rawElement;
    }

    public Object getId() {
        if (this.rawElement instanceof Node) {
            return ((Node)this.rawElement).getId();
        }
        return ((Relationship)this.rawElement).getId();
    }

    public boolean equals(Object object) {
        return null != object && this.getClass().equals(object.getClass()) && this.getId().equals(((Element)object).getId());
    }
}

