/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jElement;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class Neo4jEdge
extends Neo4jElement
implements Edge {
    public Neo4jEdge(Relationship relationship, Neo4jGraph graph) {
        this(relationship, graph, false);
    }

    protected Neo4jEdge(Relationship relationship, Neo4jGraph graph, boolean isNew) {
        super(graph);
        this.rawElement = relationship;
        if (isNew) {
            for (Neo4jAutomaticIndex<Neo4jEdge, PropertyContainer> autoIndex : this.graph.getAutoIndices(Neo4jEdge.class)) {
                autoIndex.autoUpdate("label", this.getLabel(), null, this);
            }
        }
    }

    public String getLabel() {
        return ((Relationship)this.rawElement).getType().name();
    }

    public Vertex getOutVertex() {
        return new Neo4jVertex(((Relationship)this.rawElement).getStartNode(), this.graph);
    }

    public Vertex getInVertex() {
        return new Neo4jVertex(((Relationship)this.rawElement).getEndNode(), this.graph);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Neo4jEdge && ((Neo4jEdge)object).getId().equals(this.getId());
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public Relationship getRawEdge() {
        return (Relationship)this.rawElement;
    }
}

