/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.storage.bytebuffer;

import com.thimbleware.jmemcached.storage.bytebuffer.BlockStoreFactory;
import com.thimbleware.jmemcached.storage.bytebuffer.Region;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ByteBufferBlockStore {
    protected ChannelBuffer storageBuffer;
    private long freeBytes;
    private long storeSizeBytes;
    private final int blockSizeBytes;
    private BitSet allocated;
    private static final ByteBufferBlockStoreFactory BYTE_BUFFER_BLOCK_STORE_FACTORY = new ByteBufferBlockStoreFactory();

    public static BlockStoreFactory getFactory() {
        return BYTE_BUFFER_BLOCK_STORE_FACTORY;
    }

    private ByteBufferBlockStore(ByteBuffer storageBuffer, int blockSizeBytes) throws IOException {
        this.storageBuffer = ChannelBuffers.wrappedBuffer((ByteBuffer)storageBuffer);
        this.blockSizeBytes = blockSizeBytes;
        this.initialize(storageBuffer.capacity());
    }

    protected ByteBufferBlockStore(int blockSizeBytes) {
        this.blockSizeBytes = blockSizeBytes;
    }

    protected void initialize(int storeSizeBytes) {
        this.storeSizeBytes = this.storageBuffer.capacity();
        this.freeBytes = storeSizeBytes;
        this.storageBuffer.clear();
        this.allocated = new BitSet(storeSizeBytes / this.blockSizeBytes);
        this.allocated.set((int)(ByteBufferBlockStore.roundUp(storeSizeBytes, this.blockSizeBytes) / (long)this.blockSizeBytes), false);
        this.clear();
    }

    public static long roundUp(long size, long blockSize) {
        return size - 1L + blockSize - (size - 1L) % blockSize;
    }

    public void close() throws IOException {
        this.clear();
        this.freeResources();
        this.storageBuffer = null;
    }

    protected void freeResources() throws IOException {
    }

    private int findPos(int numBlocks) {
        int startPos = 0;
        while (startPos < this.allocated.size()) {
            int clearSpot = this.allocated.nextClearBit(startPos);
            int endSpot = this.allocated.nextSetBit(clearSpot);
            if (endSpot - clearSpot >= numBlocks || endSpot == -1) {
                return clearSpot;
            }
            startPos = endSpot;
        }
        throw new BadAllocationException("unable to allocate room; all blocks consumed");
    }

    private void markPos(int start, int numBlocks) {
        this.allocated.set(start, start + numBlocks);
    }

    private void clear(int start, int numBlocks) {
        this.allocated.set(start, start + numBlocks, false);
    }

    public Region alloc(int desiredSize, ChannelBuffer data) {
        long desiredBlockSize = ByteBufferBlockStore.roundUp(desiredSize, this.blockSizeBytes);
        int numBlocks = (int)(desiredBlockSize / (long)this.blockSizeBytes);
        int pos = this.findPos(numBlocks);
        this.markPos(pos, numBlocks);
        this.freeBytes -= desiredBlockSize;
        int position = pos * this.blockSizeBytes;
        this.storageBuffer.writerIndex(position);
        this.storageBuffer.writeBytes(data);
        return new Region(desiredSize, numBlocks, pos);
    }

    public ChannelBuffer get(Region region) {
        return this.storageBuffer.slice(region.startBlock * this.blockSizeBytes, region.size);
    }

    public void free(Region region) {
        this.freeBytes += (long)(region.usedBlocks * this.blockSizeBytes);
        region.valid = false;
        int pos = region.startBlock;
        this.clear(pos, region.size / this.blockSizeBytes);
    }

    public void clear() {
        this.allocated.clear();
        this.freeBytes = this.storeSizeBytes;
    }

    public long getStoreSizeBytes() {
        return this.storeSizeBytes;
    }

    public int getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteBufferBlockStoreFactory
    implements BlockStoreFactory<ByteBufferBlockStore> {
        @Override
        public ByteBufferBlockStore manufacture(long sizeBytes, int blockSizeBytes) {
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect((int)sizeBytes);
                return new ByteBufferBlockStore(buffer, blockSizeBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class BadAllocationException
    extends RuntimeException {
        public BadAllocationException(String s) {
            super(s);
        }
    }
}

