/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.protocol.text;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.protocol.Op;
import com.thimbleware.jmemcached.protocol.ResponseMessage;
import com.thimbleware.jmemcached.protocol.exceptions.ClientException;
import com.thimbleware.jmemcached.protocol.text.MemcachedPipelineFactory;
import com.thimbleware.jmemcached.util.BufferUtils;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemcachedResponseEncoder<CACHE_ELEMENT extends CacheElement>
extends SimpleChannelUpstreamHandler {
    final Logger logger = LoggerFactory.getLogger(MemcachedResponseEncoder.class);
    public static final ChannelBuffer CRLF = ChannelBuffers.copiedBuffer((CharSequence)"\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer SPACE = ChannelBuffers.copiedBuffer((CharSequence)" ", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer VALUE = ChannelBuffers.copiedBuffer((CharSequence)"VALUE ", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer EXISTS = ChannelBuffers.copiedBuffer((CharSequence)"EXISTS\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer NOT_FOUND = ChannelBuffers.copiedBuffer((CharSequence)"NOT_FOUND\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer NOT_STORED = ChannelBuffers.copiedBuffer((CharSequence)"NOT_STORED\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer STORED = ChannelBuffers.copiedBuffer((CharSequence)"STORED\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer DELETED = ChannelBuffers.copiedBuffer((CharSequence)"DELETED\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer END = ChannelBuffers.copiedBuffer((CharSequence)"END\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer OK = ChannelBuffers.copiedBuffer((CharSequence)"OK\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer ERROR = ChannelBuffers.copiedBuffer((CharSequence)"ERROR\r\n", (Charset)MemcachedPipelineFactory.USASCII);
    private static final ChannelBuffer CLIENT_ERROR = ChannelBuffers.copiedBuffer((CharSequence)"CLIENT_ERROR\r\n", (Charset)MemcachedPipelineFactory.USASCII);

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        block4: {
            try {
                throw e.getCause();
            }
            catch (ClientException ce) {
                if (ctx.getChannel().isOpen()) {
                    ctx.getChannel().write((Object)CLIENT_ERROR);
                }
            }
            catch (Throwable tr) {
                this.logger.error("error", tr);
                if (!ctx.getChannel().isOpen()) break block4;
                ctx.getChannel().write((Object)ERROR);
            }
        }
    }

    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        ResponseMessage command = (ResponseMessage)messageEvent.getMessage();
        Op cmd = command.cmd.op;
        Channel channel = messageEvent.getChannel();
        switch (cmd) {
            case GET: 
            case GETS: {
                CACHE_ELEMENT[] results = command.elements;
                ChannelBuffer[] buffers = new ChannelBuffer[results.length * 3 + 1];
                int i = 0;
                for (Object result : results) {
                    if (result == null) continue;
                    buffers[i++] = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{VALUE, result.getKey().bytes, SPACE, BufferUtils.itoa(result.getFlags()), SPACE, BufferUtils.itoa(result.size())});
                    if (cmd == Op.GETS) {
                        buffers[i++] = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{SPACE, BufferUtils.ltoa(result.getCasUnique())});
                    }
                    buffers[i++] = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CRLF, result.getData(), CRLF});
                }
                buffers[i] = END;
                Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((ChannelBuffer[])buffers));
                break;
            }
            case APPEND: 
            case PREPEND: 
            case ADD: 
            case SET: 
            case REPLACE: 
            case CAS: {
                if (command.cmd.noreply) break;
                Channels.write((Channel)channel, (Object)this.storeResponse(command.response));
                break;
            }
            case DELETE: {
                if (command.cmd.noreply) break;
                Channels.write((Channel)channel, (Object)this.deleteResponseString(command.deleteResponse));
                break;
            }
            case DECR: 
            case INCR: {
                if (command.cmd.noreply) break;
                Channels.write((Channel)channel, (Object)this.incrDecrResponseString(command.incrDecrResponse));
                break;
            }
            case STATS: {
                for (Map.Entry<String, Set<String>> stat : command.stats.entrySet()) {
                    for (String statVal : stat.getValue()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("STAT ");
                        builder.append(stat.getKey());
                        builder.append(" ");
                        builder.append(String.valueOf(statVal));
                        builder.append("\r\n");
                        Channels.write((Channel)channel, (Object)ChannelBuffers.copiedBuffer((CharSequence)builder.toString(), (Charset)MemcachedPipelineFactory.USASCII));
                    }
                }
                Channels.write((Channel)channel, (Object)END.duplicate());
                break;
            }
            case VERSION: {
                Channels.write((Channel)channel, (Object)ChannelBuffers.copiedBuffer((CharSequence)("VERSION " + command.version + "\r\n"), (Charset)MemcachedPipelineFactory.USASCII));
                break;
            }
            case QUIT: {
                Channels.disconnect((Channel)channel);
                break;
            }
            case FLUSH_ALL: {
                if (command.cmd.noreply) break;
                ChannelBuffer ret = command.flushSuccess ? OK.duplicate() : ERROR.duplicate();
                Channels.write((Channel)channel, (Object)ret);
                break;
            }
            case VERBOSITY: {
                break;
            }
            default: {
                Channels.write((Channel)channel, (Object)ERROR.duplicate());
                this.logger.error("error; unrecognized command: " + (Object)((Object)cmd));
            }
        }
    }

    private ChannelBuffer deleteResponseString(Cache.DeleteResponse deleteResponse) {
        if (deleteResponse == Cache.DeleteResponse.DELETED) {
            return DELETED.duplicate();
        }
        return NOT_FOUND.duplicate();
    }

    private ChannelBuffer incrDecrResponseString(Integer ret) {
        if (ret == null) {
            return NOT_FOUND.duplicate();
        }
        return ChannelBuffers.copiedBuffer((CharSequence)(String.valueOf(ret) + "\r\n"), (Charset)MemcachedPipelineFactory.USASCII);
    }

    private ChannelBuffer storeResponse(Cache.StoreResponse storeResponse) {
        switch (storeResponse) {
            case EXISTS: {
                return EXISTS.duplicate();
            }
            case NOT_FOUND: {
                return NOT_FOUND.duplicate();
            }
            case NOT_STORED: {
                return NOT_STORED.duplicate();
            }
            case STORED: {
                return STORED.duplicate();
            }
        }
        throw new RuntimeException("unknown store response from cache: " + (Object)((Object)storeResponse));
    }
}

