/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.protocol.text;

import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.protocol.CommandMessage;
import com.thimbleware.jmemcached.protocol.Op;
import com.thimbleware.jmemcached.protocol.SessionStatus;
import com.thimbleware.jmemcached.protocol.exceptions.IncorrectlyTerminatedPayloadException;
import com.thimbleware.jmemcached.protocol.exceptions.InvalidProtocolStateException;
import com.thimbleware.jmemcached.protocol.exceptions.MalformedCommandException;
import com.thimbleware.jmemcached.protocol.exceptions.UnknownCommandException;
import com.thimbleware.jmemcached.protocol.text.MemcachedResponseEncoder;
import com.thimbleware.jmemcached.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemcachedCommandDecoder
extends FrameDecoder {
    private static final int MIN_BYTES_LINE = 2;
    private SessionStatus status;
    private static final ChannelBuffer NOREPLY = ChannelBuffers.wrappedBuffer((byte[])"noreply".getBytes());
    static ChannelBufferIndexFinder CRLF_OR_WS = new ChannelBufferIndexFinder(){

        public final boolean find(ChannelBuffer buffer, int guessedIndex) {
            byte b = buffer.getByte(guessedIndex);
            return b == 32 || b == 13 || b == 10;
        }
    };

    public MemcachedCommandDecoder(SessionStatus status) {
        this.status = status;
    }

    static boolean eol(int pos, ChannelBuffer buffer) {
        return buffer.readableBytes() >= 2 && buffer.getByte(buffer.readerIndex() + pos) == 13 && buffer.getByte(buffer.readerIndex() + pos + 1) == 10;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.status.state == SessionStatus.State.READY) {
            ChannelBuffer in = buffer.slice();
            ArrayList<ChannelBuffer> pieces = new ArrayList<ChannelBuffer>(6);
            if (in.readableBytes() < 2) {
                return null;
            }
            int pos = in.bytesBefore(CRLF_OR_WS);
            boolean eol = false;
            do {
                if (pos == -1) continue;
                eol = MemcachedCommandDecoder.eol(pos, in);
                int skip = eol ? 2 : 1;
                ChannelBuffer slice = in.slice(in.readerIndex(), pos);
                slice.readerIndex(0);
                pieces.add(slice);
                in.skipBytes(pos + skip);
                if (eol) break;
            } while ((pos = in.bytesBefore(CRLF_OR_WS)) != -1);
            if (eol) {
                buffer.skipBytes(in.readerIndex());
                return this.processLine(pieces, channel, ctx);
            }
            if (this.status.state != SessionStatus.State.WAITING_FOR_DATA) {
                this.status.ready();
            }
        } else if (this.status.state == SessionStatus.State.WAITING_FOR_DATA) {
            if (buffer.readableBytes() >= this.status.bytesNeeded + MemcachedResponseEncoder.CRLF.capacity()) {
                ChannelBuffer dest = buffer.slice(buffer.readerIndex() + this.status.bytesNeeded, 2);
                if (!dest.equals(MemcachedResponseEncoder.CRLF)) {
                    this.status.ready();
                    throw new IncorrectlyTerminatedPayloadException("payload not terminated correctly");
                }
                this.status.processingMultiline();
                ChannelBuffer result = buffer.copy(buffer.readerIndex(), this.status.bytesNeeded);
                buffer.skipBytes(this.status.bytesNeeded + MemcachedResponseEncoder.CRLF.capacity());
                CommandMessage commandMessage = this.continueSet(channel, this.status, result, ctx);
                if (this.status.state != SessionStatus.State.WAITING_FOR_DATA) {
                    this.status.ready();
                }
                return commandMessage;
            }
        } else {
            throw new InvalidProtocolStateException("invalid protocol state");
        }
        return null;
    }

    private Object processLine(List<ChannelBuffer> parts, Channel channel, ChannelHandlerContext channelHandlerContext) throws UnknownCommandException, MalformedCommandException {
        Op op;
        int numParts = parts.size();
        try {
            op = Op.FindOp(parts.get(0));
            if (op == null) {
                throw new IllegalArgumentException("unknown operation: " + parts.get(0).toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new UnknownCommandException("unknown operation: " + parts.get(0).toString());
        }
        CommandMessage cmd = CommandMessage.command(op);
        switch (op) {
            case DELETE: {
                cmd.setKey(parts.get(1));
                if (numParts >= 2) {
                    if (parts.get(numParts - 1).equals(NOREPLY)) {
                        cmd.noreply = true;
                        if (numParts == 4) {
                            cmd.time = BufferUtils.atoi(parts.get(2));
                        }
                    } else if (numParts == 3) {
                        cmd.time = BufferUtils.atoi(parts.get(2));
                    }
                }
                return cmd;
            }
            case DECR: 
            case INCR: {
                if (numParts < 2 || numParts > 3) {
                    throw new MalformedCommandException("invalid increment command");
                }
                cmd.setKey(parts.get(1));
                cmd.incrAmount = BufferUtils.atoi(parts.get(2));
                if (numParts == 3 && parts.get(2).equals(NOREPLY)) {
                    cmd.noreply = true;
                }
                return cmd;
            }
            case FLUSH_ALL: {
                if (numParts >= 1) {
                    if (parts.get(numParts - 1).equals(NOREPLY)) {
                        cmd.noreply = true;
                        if (numParts == 3) {
                            cmd.time = BufferUtils.atoi(parts.get(1));
                        }
                    } else if (numParts == 2) {
                        cmd.time = BufferUtils.atoi(parts.get(1));
                    }
                }
                return cmd;
            }
            case VERBOSITY: {
                if (numParts < 2 || numParts > 3) {
                    throw new MalformedCommandException("invalid verbosity command");
                }
                cmd.time = BufferUtils.atoi(parts.get(1));
                if (numParts > 1 && parts.get(2).equals(NOREPLY)) {
                    cmd.noreply = true;
                }
                return cmd;
            }
            case APPEND: 
            case PREPEND: 
            case REPLACE: 
            case ADD: 
            case SET: 
            case CAS: {
                if (numParts < 5) {
                    throw new MalformedCommandException("invalid command length");
                }
                int size = BufferUtils.atoi(parts.get(4));
                int expire = BufferUtils.atoi(parts.get(3));
                int flags = BufferUtils.atoi(parts.get(2));
                cmd.element = new LocalCacheElement(new Key(parts.get(1).slice()), flags, expire != 0 && expire < 2592000 ? LocalCacheElement.Now() + expire : expire, 0L);
                if (numParts > 5) {
                    int noreply;
                    int n = noreply = op == Op.CAS ? 6 : 5;
                    if (op == Op.CAS) {
                        cmd.cas_key = BufferUtils.atol(parts.get(5));
                    }
                    if (numParts == noreply + 1 && parts.get(noreply).equals(NOREPLY)) {
                        cmd.noreply = true;
                    }
                }
                this.status.needMore(size, cmd);
                break;
            }
            case GET: 
            case GETS: 
            case STATS: 
            case VERSION: 
            case QUIT: {
                cmd.setKeys(parts.subList(1, numParts));
                return cmd;
            }
            default: {
                throw new UnknownCommandException("unknown command: " + (Object)((Object)op));
            }
        }
        return null;
    }

    private CommandMessage continueSet(Channel channel, SessionStatus state, ChannelBuffer remainder, ChannelHandlerContext channelHandlerContext) {
        state.cmd.element.setData(remainder);
        return state.cmd;
    }
}

