/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.protocol;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.protocol.CommandMessage;
import com.thimbleware.jmemcached.protocol.Op;
import com.thimbleware.jmemcached.protocol.ResponseMessage;
import com.thimbleware.jmemcached.protocol.exceptions.UnknownCommandException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public final class MemcachedCommandHandler<CACHE_ELEMENT extends CacheElement>
extends SimpleChannelUpstreamHandler {
    final Logger logger = LoggerFactory.getLogger(MemcachedCommandHandler.class);
    public final AtomicInteger curr_conns = new AtomicInteger();
    public final AtomicInteger total_conns = new AtomicInteger();
    public final String version;
    public final int idle_limit;
    public final boolean verbose;
    private final Cache<CACHE_ELEMENT> cache;
    private final DefaultChannelGroup channelGroup;

    public MemcachedCommandHandler(Cache cache, String memcachedVersion, boolean verbosity, int idle, DefaultChannelGroup channelGroup) {
        this.cache = cache;
        this.version = memcachedVersion;
        this.verbose = verbosity;
        this.idle_limit = idle;
        this.channelGroup = channelGroup;
    }

    public void channelOpen(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) throws Exception {
        this.total_conns.incrementAndGet();
        this.curr_conns.incrementAndGet();
        this.channelGroup.add(channelHandlerContext.getChannel());
    }

    public void channelClosed(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) throws Exception {
        this.curr_conns.decrementAndGet();
        this.channelGroup.remove((Object)channelHandlerContext.getChannel());
    }

    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        if (!(messageEvent.getMessage() instanceof CommandMessage)) {
            channelHandlerContext.sendUpstream((ChannelEvent)messageEvent);
            return;
        }
        CommandMessage command = (CommandMessage)messageEvent.getMessage();
        Op cmd = command.op;
        int cmdKeysSize = command.keys == null ? 0 : command.keys.size();
        this.cache.asyncEventPing();
        if (this.verbose) {
            StringBuilder log = new StringBuilder();
            log.append((Object)cmd);
            if (command.element != null) {
                log.append(" ").append(command.element.getKey());
            }
            for (int i = 0; i < cmdKeysSize; ++i) {
                log.append(" ").append(command.keys.get(i));
            }
            this.logger.info(log.toString());
        }
        Channel channel = messageEvent.getChannel();
        if (cmd == null) {
            this.handleNoOp(channelHandlerContext, command);
        } else {
            switch (cmd) {
                case GET: 
                case GETS: {
                    this.handleGets(channelHandlerContext, command, channel);
                    break;
                }
                case APPEND: {
                    this.handleAppend(channelHandlerContext, command, channel);
                    break;
                }
                case PREPEND: {
                    this.handlePrepend(channelHandlerContext, command, channel);
                    break;
                }
                case DELETE: {
                    this.handleDelete(channelHandlerContext, command, channel);
                    break;
                }
                case DECR: {
                    this.handleDecr(channelHandlerContext, command, channel);
                    break;
                }
                case INCR: {
                    this.handleIncr(channelHandlerContext, command, channel);
                    break;
                }
                case REPLACE: {
                    this.handleReplace(channelHandlerContext, command, channel);
                    break;
                }
                case ADD: {
                    this.handleAdd(channelHandlerContext, command, channel);
                    break;
                }
                case SET: {
                    this.handleSet(channelHandlerContext, command, channel);
                    break;
                }
                case CAS: {
                    this.handleCas(channelHandlerContext, command, channel);
                    break;
                }
                case STATS: {
                    this.handleStats(channelHandlerContext, command, cmdKeysSize, channel);
                    break;
                }
                case VERSION: {
                    this.handleVersion(channelHandlerContext, command, channel);
                    break;
                }
                case QUIT: {
                    this.handleQuit(channel);
                    break;
                }
                case FLUSH_ALL: {
                    this.handleFlush(channelHandlerContext, command, channel);
                    break;
                }
                case VERBOSITY: {
                    this.handleVerbosity(channelHandlerContext, command, channel);
                    break;
                }
                default: {
                    throw new UnknownCommandException("unknown command");
                }
            }
        }
    }

    protected void handleNoOp(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command) {
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command));
    }

    protected void handleFlush(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withFlushResponse(this.cache.flush_all(command.time)), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleVerbosity(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleQuit(Channel channel) {
        channel.disconnect();
    }

    protected void handleVersion(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        ResponseMessage responseMessage = new ResponseMessage(command);
        responseMessage.version = this.version;
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, responseMessage, (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleStats(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, int cmdKeysSize, Channel channel) {
        String option = "";
        if (cmdKeysSize > 0) {
            option = command.keys.get((int)0).bytes.toString();
        }
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withStatResponse(this.cache.stat(option)), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleDelete(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.DeleteResponse dr = this.cache.delete(command.keys.get(0), command.time);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withDeleteResponse(dr), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleDecr(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Integer incrDecrResp = this.cache.get_add(command.keys.get(0), -1 * command.incrAmount);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withIncrDecrResponse(incrDecrResp), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleIncr(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Integer incrDecrResp = this.cache.get_add(command.keys.get(0), command.incrAmount);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withIncrDecrResponse(incrDecrResp), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handlePrepend(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.StoreResponse ret = this.cache.prepend(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleAppend(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.StoreResponse ret = this.cache.append(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleReplace(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.StoreResponse ret = this.cache.replace(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleAdd(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.StoreResponse ret = this.cache.add(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleCas(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.StoreResponse ret = this.cache.cas(command.cas_key, command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleSet(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Cache.StoreResponse ret = this.cache.set(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleGets(ChannelHandlerContext channelHandlerContext, CommandMessage<CACHE_ELEMENT> command, Channel channel) {
        Key[] keys = new Key[command.keys.size()];
        keys = command.keys.toArray(keys);
        CacheElement[] results = this.get(keys);
        ResponseMessage resp = new ResponseMessage(command).withElements(results);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)resp, (SocketAddress)channel.getRemoteAddress());
    }

    private CACHE_ELEMENT[] get(Key ... keys) {
        return this.cache.get(keys);
    }

    private static int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }
}

