/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;

public class FixedMimeTypePolicy
implements MimeTypePolicy {
    private boolean initialized = false;
    private String aMimeType;
    private DatabaseMapping binaryMapping;
    private DatabaseMapping contentTypeMapping;

    public FixedMimeTypePolicy() {
        this.initialized = true;
    }

    public FixedMimeTypePolicy(String aMimeTypeParameter) {
        this.aMimeType = aMimeTypeParameter;
        this.initialized = true;
    }

    public FixedMimeTypePolicy(String aMimeTypeParameter, DatabaseMapping mapping) {
        this.aMimeType = aMimeTypeParameter;
        this.binaryMapping = mapping;
        this.initialized = this.binaryMapping == null;
    }

    public String getMimeType(Object anObject) {
        String contentType;
        if (!this.initialized && this.contentTypeMapping == null) {
            ClassDescriptor descriptor = this.binaryMapping.getDescriptor();
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                XPathFragment xPathFragment;
                XMLField xmlField = (XMLField)mapping.getField();
                if (xmlField == null || (xPathFragment = xmlField.getXPathFragment()) == null || !xPathFragment.isAttribute() || !"http://www.w3.org/2005/05/xmlmime".equals(xPathFragment.getNamespaceURI()) || !"contentType".equals(xPathFragment.getLocalName())) continue;
                this.contentTypeMapping = mapping;
                break;
            }
            this.initialized = true;
        }
        if (this.contentTypeMapping != null && (contentType = (String)this.contentTypeMapping.getAttributeValueFromObject(anObject)) != null) {
            return contentType;
        }
        return this.aMimeType;
    }

    public String getMimeType() {
        return this.aMimeType;
    }

    public void setMimeType(String aString) {
        this.aMimeType = aString;
    }
}

