/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.osgi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFServiceProxyHandler
implements InvocationHandler,
ServiceFactory {
    protected EntityManagerFactory emf;
    protected PersistenceProvider provider;
    protected String puName;

    public EMFServiceProxyHandler(PersistenceProvider provider, String puName) {
        this.provider = provider;
        this.puName = puName;
    }

    EntityManagerFactory getEMF() {
        return this.emf;
    }

    void setEMF(EntityManagerFactory emf) {
        this.emf = emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (this.emf == null) {
            EMFServiceProxyHandler eMFServiceProxyHandler = this;
            synchronized (eMFServiceProxyHandler) {
                if (this.emf == null) {
                    this.emf = this.createEMF(new HashMap<String, Object>());
                }
            }
        }
        Object result = method.invoke((Object)this.emf, args);
        EMFServiceProxyHandler eMFServiceProxyHandler = this;
        synchronized (eMFServiceProxyHandler) {
            if (!this.emf.isOpen()) {
                this.emf = null;
            }
        }
        return result;
    }

    public Object getService(Bundle b, ServiceRegistration serviceReg) {
        return this;
    }

    public void ungetService(Bundle b, ServiceRegistration serviceReg, Object obj) {
    }

    protected EntityManagerFactory createEMF(Map<String, Object> props) {
        EntityManagerFactory result = this.provider.createEntityManagerFactory(this.puName, props);
        if (result == null) {
            this.fatalError("Proxy could not create EMF " + this.puName + " from provider " + this.provider, null);
        }
        return result;
    }

    private void fatalError(String string, Object object) {
        System.err.println(String.valueOf(this.getClass().getName()) + ": " + string + ": " + object);
    }
}

