/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaEmbeddable;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaEntity;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaTypeRepository;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaManagedTypeProvider
implements IManagedTypeProvider {
    private Map<String, IEmbeddable> embeddables;
    private Map<String, IEntity> entities;
    private boolean initialized;
    private Map<String, IManagedType> managedTypes;
    private AbstractSession session;
    private JavaTypeRepository typeRepository;

    public JavaManagedTypeProvider(AbstractSession session) {
        this.initialize(session);
    }

    private <T extends IManagedType> T addManagedType(ClassDescriptor descriptor, Boolean returnEntity) {
        if (descriptor == null) {
            return null;
        }
        String typeName = descriptor.getJavaClassName();
        if (descriptor.isAggregateDescriptor()) {
            JavaEmbeddable embeddable = new JavaEmbeddable(this, descriptor);
            this.embeddables.put(typeName, embeddable);
            this.managedTypes.put(typeName, embeddable);
            return (T)(returnEntity == null || returnEntity == false ? embeddable : null);
        }
        JavaEntity entity = new JavaEntity(this, descriptor);
        this.entities.put(typeName, entity);
        this.managedTypes.put(typeName, entity);
        return (T)(returnEntity == null || returnEntity != false ? entity : null);
    }

    private <T extends IManagedType> T addManagedType(String typeName, Boolean returnEntity) {
        return this.addManagedType(this.getDescriptor(typeName), returnEntity);
    }

    public IterableIterator<IEntity> entities() {
        this.initializeManagedTypes();
        return new CloneIterator(this.entities.values());
    }

    ClassLoader getClassLoader() {
        return this.getSession().getDatasourcePlatform().getConversionManager().getLoader();
    }

    private ClassDescriptor getDescriptor(String typeName) {
        for (Map.Entry<Class, ClassDescriptor> entry : this.session.getDescriptors().entrySet()) {
            if (!entry.getKey().getName().equals(typeName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public IEmbeddable getEmbeddable(IType type) {
        return this.getEmbeddable(type.getName());
    }

    public IEmbeddable getEmbeddable(String typeName) {
        IEmbeddable embeddable = this.embeddables.get(typeName);
        if (embeddable == null) {
            embeddable = (IEmbeddable)this.addManagedType(typeName, Boolean.FALSE);
        }
        return embeddable;
    }

    public IEntity getEntity(IType type) {
        return this.getEntity(type.getName());
    }

    public IEntity getEntity(String typeName) {
        IEntity entity = this.entities.get(typeName);
        if (entity == null) {
            entity = (IEntity)this.addManagedType(typeName, Boolean.TRUE);
        }
        return entity;
    }

    public IEntity getEntityNamed(String entityName) {
        ClassDescriptor descriptor = this.session.getDescriptorForAlias(entityName);
        if (descriptor != null) {
            IEntity entity = this.entities.get(descriptor.getJavaClassName());
            if (entity == null) {
                entity = (IEntity)this.addManagedType(descriptor, Boolean.TRUE);
            }
            return entity;
        }
        return null;
    }

    public IManagedType getManagedType(IType type) {
        return this.getManagedType(type.getName());
    }

    public IManagedType getManagedType(String typeName) {
        Object managedType = this.managedTypes.get(typeName);
        if (managedType == null) {
            managedType = this.addManagedType(typeName, null);
        }
        return managedType;
    }

    public IMappedSuperclass getMappedSuperclass(IType type) {
        return null;
    }

    public IMappedSuperclass getMappedSuperclass(String typeName) {
        return null;
    }

    AbstractSession getSession() {
        return this.session;
    }

    public ITypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JavaTypeRepository(this.getClassLoader());
        }
        return this.typeRepository;
    }

    private void initialize(AbstractSession session) {
        this.session = session;
        this.managedTypes = new HashMap<String, IManagedType>();
        this.embeddables = new HashMap<String, IEmbeddable>();
        this.entities = new HashMap<String, IEntity>();
    }

    private void initializeManagedTypes() {
        if (!this.initialized) {
            this.initialized = true;
            for (ClassDescriptor descriptor : this.session.getDescriptors().values()) {
                IManagedType managedType = this.managedTypes.get(descriptor.getJavaClassName());
                if (managedType != null) continue;
                this.addManagedType(descriptor, (Boolean)true);
            }
        }
    }

    public IterableIterator<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return new CloneIterator(this.managedTypes.values());
    }
}

