/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.jpql.AbstractRangeDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.JoinFetch;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RangeDeclaration
extends AbstractRangeDeclaration {
    private List<JoinFetch> joinFetches;

    RangeDeclaration(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    void addJoinFetch(JoinFetch joinFetch) {
        if (this.joinFetches == null) {
            this.joinFetches = new ArrayList<JoinFetch>();
        }
        this.joinFetches.add(joinFetch);
    }

    @Override
    Expression buildQueryExpression() {
        ClassDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            this.convertUnqualifiedDeclaration();
            return this.queryContext.getBaseExpression();
        }
        return new ExpressionBuilder(descriptor.getJavaClass());
    }

    private void convertUnqualifiedDeclaration() {
        Declaration parentDeclaration = this.queryContext.getParent().getFirstDeclarationImp();
        String outerVariableName = parentDeclaration.getVariableName();
        this.queryContext.getDeclarationResolver().convertUnqualifiedDeclaration(this, outerVariableName);
    }

    List<JoinFetch> getJoinFetches() {
        return this.joinFetches == null ? Collections.emptyList() : this.joinFetches;
    }

    boolean hasJoinFetches() {
        return this.joinFetches != null;
    }

    @Override
    boolean isDerived() {
        return false;
    }

    @Override
    boolean isRange() {
        return true;
    }

    @Override
    ClassDescriptor resolveDescriptor() {
        return this.queryContext.getDescriptor(this.rootPath);
    }

    @Override
    DatabaseMapping resolveMapping() {
        return null;
    }
}

