/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TransactionRolledBackException;

public class Transaction {
    protected SessionImpl session = null;
    protected ProtocolHandler protocolHandler = null;
    protected WriteChannel writeChannel = null;
    private long transactionID = -1L;
    private long nextTransactionID = -1L;
    private JMQXid jmqXid = null;
    private boolean setJMSXProducerTXID = false;
    private boolean debug = Debug.debug;
    private boolean resetFailOverFlag = false;
    protected static final int TRANSACTION_STARTED = 0;
    protected static final int TRANSACTION_ENDED = 1;
    protected static final int TRANSACTION_PREPARED = 2;
    protected static final int TRANSACTION_COMMITTED = 3;
    protected static final int TRANSACTION_ROLLBACK_ONLY = 4;
    protected static final int TRANSACTION_VERIFY_STATUS_COMMITTED = 7;
    protected static final int TRANSACTION_VERIFY_STATUS_ROLLEDBACK = 8;

    protected Transaction(SessionImpl sessionImpl, boolean bl) throws JMSException {
        this.session = sessionImpl;
        this.writeChannel = sessionImpl.connection.getWriteChannel();
        this.protocolHandler = sessionImpl.protocolHandler;
        this.setJMSXProducerTXID = sessionImpl.connection.connectionMetaData.setJMSXProducerTXID;
        if (bl) {
            if (sessionImpl.connection.isConnectedToHABroker) {
                sessionImpl.protocolHandler.twoPhaseCommitFlag = true;
            }
            this.startNewLocalTransaction();
        }
    }

    protected void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    protected void init() throws JMSException {
        this.startNewLocalTransaction();
        this.setJMSXProducerTXID = this.session.connection.connectionMetaData.setJMSXProducerTXID;
    }

    protected synchronized void commit() throws JMSException {
        try {
            if (this.session.connection.isConnectedToHABroker) {
                this.commitHATransaction();
                this.session.clearUnackedMessageQ();
                this.startHANewLocalTransaction();
            } else {
                this.nextTransactionID = this.protocolHandler.commit(this.transactionID, -1, null);
                this.session.clearUnackedMessageQ();
                this.startNewLocalTransaction();
            }
        }
        catch (JMSException jMSException) {
            this.checkCommitException(jMSException);
        }
    }

    private void checkCommitException(JMSException jMSException) throws JMSException {
        try {
            if (jMSException instanceof TransactionRolledBackException) {
                this.session.clearUnackedMessageQ();
            } else {
                String string = jMSException.getErrorCode();
                if ("C4001".equals(string) || "C4000".equals(string)) {
                    this.session.clearUnackedMessageQ();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        throw jMSException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitHATransaction() throws JMSException {
        block10: {
            this.resetFailOverFlag = false;
            int n = -1;
            try {
                try {
                    this.protocolHandler.endHATransaction(this.transactionID);
                    n = 1;
                    this.protocolHandler.prepareHATransaction(this.transactionID);
                    n = 2;
                    this.protocolHandler.commitHATransaction(this.transactionID);
                    n = 3;
                    this.resetFailOverFlag = true;
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    this.resetFailOverFlag = true;
                    this.throwRollbackException(transactionRolledBackException);
                    Object var5_3 = null;
                    if (this.resetFailOverFlag) {
                        this.session.failoverOccurred = false;
                        this.resetFailOverFlag = false;
                    }
                    break block10;
                }
                catch (JMSException jMSException) {
                    String string = jMSException.getErrorCode();
                    if (!"C4001".equals(string) && !"C4000".equals(string)) {
                        throw jMSException;
                    }
                    this.checkCommitStatus(jMSException, n);
                    this.resetFailOverFlag = true;
                    Object var5_4 = null;
                    if (this.resetFailOverFlag) {
                        this.session.failoverOccurred = false;
                        this.resetFailOverFlag = false;
                    }
                }
                Object var5_2 = null;
                if (this.resetFailOverFlag) {
                    this.session.failoverOccurred = false;
                    this.resetFailOverFlag = false;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.resetFailOverFlag) {
                    this.session.failoverOccurred = false;
                    this.resetFailOverFlag = false;
                }
                throw throwable;
            }
        }
    }

    private void startHANewLocalTransaction() throws JMSException {
        block7: {
            try {
                this.startNewLocalTransaction();
                if (this.session.failoverOccurred) {
                    this.session.failoverOccurred = false;
                }
            }
            catch (JMSException jMSException) {
                SessionImpl.yield();
                this.session.connection.checkReconnecting(null);
                if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
                    throw jMSException;
                }
                String string = jMSException.getErrorCode();
                if (!"C4001".equals(string) && !"C4000".equals(string)) break block7;
                try {
                    this.startNewLocalTransaction();
                    if (this.session.failoverOccurred) {
                        this.session.failoverOccurred = false;
                    }
                }
                catch (JMSException jMSException2) {
                    SessionImpl.sessionLogger.log(Level.WARNING, "C4105", jMSException2);
                }
            }
        }
    }

    private void checkCommitStatus(JMSException jMSException, int n) throws JMSException {
        if (!this.session.connection.imqReconnect) {
            throw jMSException;
        }
        SessionImpl.yield();
        this.session.connection.checkReconnecting(null);
        if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
            throw jMSException;
        }
        try {
            this.verifyTransaction(n);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            this.resetFailOverFlag = true;
            this.session.failoverOccurred = false;
            if (this.debug) {
                Debug.println("*** in checkCommitStatus(), reset session.failoverOccurred flag to false.");
            }
            throw transactionRolledBackException;
        }
        catch (JMSException jMSException2) {
            throw jMSException2;
        }
    }

    private void verifyTransaction(int n) throws JMSException {
        if (n < 1) {
            this.createAndThrowFailoverRollbackException();
        }
        int n2 = this.protocolHandler.verifyHATransaction(this.transactionID, n);
        switch (n2) {
            case 7: {
                if (this.debug) {
                    Debug.println("transaction verified: state is successful");
                }
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.protocolHandler.commitHATransaction(this.transactionID);
                    SessionImpl.sessionLogger.log(Level.INFO, "verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jMSException) {
                    if (!this.session.connection.imqReconnect) {
                        throw jMSException;
                    }
                    SessionImpl.yield();
                    this.session.connection.checkReconnecting(null);
                    if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
                        throw jMSException;
                    }
                    this.protocolHandler.rollback(this.transactionID);
                }
            }
        }
        this.createAndThrowFailoverRollbackException();
    }

    private void createAndThrowFailoverRollbackException() throws TransactionRolledBackException {
        String string = AdministeredObject.cr.getKString("C4074");
        TransactionRolledBackException transactionRolledBackException = new TransactionRolledBackException(string, "C4074");
        this.throwRollbackException(transactionRolledBackException);
    }

    private void throwRollbackException(TransactionRolledBackException transactionRolledBackException) throws TransactionRolledBackException {
        try {
            this.startNewLocalTransaction();
        }
        catch (Exception exception) {
            this.transactionID = -1L;
            Debug.printStackTrace(exception);
        }
        throw transactionRolledBackException;
    }

    protected synchronized void rollback() throws JMSException {
        if (!this.session.failoverOccurred) {
            this.protocolHandler.rollback(this.transactionID);
        } else {
            Debug.println("*** rollback pkt not sent because failover occurred.");
        }
        this.startNewLocalTransaction();
    }

    protected void rollbackToXA() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
        this.transactionID = -1L;
    }

    protected void send(Message message) throws JMSException {
        MessageImpl messageImpl = (MessageImpl)message;
        if (this.setJMSXProducerTXID) {
            messageImpl.setStringProperty("JMSXProducerTXID", String.valueOf(this.transactionID));
        }
        ReadWritePacket readWritePacket = messageImpl.getPacket();
        readWritePacket.setTransactionID(this.transactionID);
        this.writeChannel.writeJMSMessage(message);
    }

    protected JMQXid[] recoverXATransactions(int n) throws JMSException {
        return this.protocolHandler.recover(n);
    }

    protected void prepareXATransaction(JMQXid jMQXid) throws JMSException {
        this.protocolHandler.prepare(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, jMQXid);
    }

    protected void commitXATransaction(JMQXid jMQXid, boolean bl) throws JMSException {
        try {
            int n = bl ? 0x40000000 : 0;
            this.protocolHandler.commit(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, n, jMQXid);
            this.session.clearUnackedMessageQ();
        }
        catch (JMSException jMSException) {
            this.checkCommitException(jMSException);
        }
    }

    protected void rollbackXATransaction(JMQXid jMQXid) throws JMSException {
        this.protocolHandler.rollback(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, jMQXid);
    }

    protected void startXATransaction(int n, JMQXid jMQXid) throws JMSException {
        this.startTransaction(n, jMQXid);
    }

    protected void endXATransaction(int n, JMQXid jMQXid) throws JMSException {
        this.protocolHandler.endTransaction(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, n, jMQXid);
    }

    protected void startNewLocalTransaction() throws JMSException {
        this.transactionID = -1L;
        this.jmqXid = null;
        this.startTransaction(-1, null);
    }

    protected synchronized void startTransaction(int n, JMQXid jMQXid) throws JMSException {
        if (this.nextTransactionID != -1L) {
            this.transactionID = this.nextTransactionID;
            this.nextTransactionID = -1L;
            return;
        }
        if (this.transactionID == -1L) {
            boolean bl = false;
            while (!bl) {
                try {
                    this.transactionID = jMQXid == null ? this.protocolHandler.startTransaction(0L, n, jMQXid, this.session.getBrokerSessionID()) : this.protocolHandler.startTransaction(0L, n, jMQXid);
                    bl = true;
                }
                catch (JMSException jMSException) {
                    String string = jMSException.getErrorCode();
                    if (string == "C4028") continue;
                    throw jMSException;
                }
            }
            if (jMQXid != null) {
                this.jmqXid = jMQXid;
            }
        } else {
            this.transactionID = this.protocolHandler.startTransaction(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, n, jMQXid);
            if (jMQXid != null) {
                this.jmqXid = jMQXid;
            }
        }
        if (this.debug) {
            Debug.println("*** in Transaction.startTransaction(), new txID: " + this.transactionID);
        }
    }

    protected void releaseBrokerResource() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
    }

    private int getNextTransactionID() throws JMSException {
        return this.session.connection.getNextTransactionID();
    }

    protected synchronized long getTransactionID() {
        return this.transactionID;
    }

    public synchronized void setTransactionID(long l) {
        this.transactionID = l;
    }
}

