/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.ser;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.spotify.docker.client.shaded.com.google.common.collect.BoundType;
import com.spotify.docker.client.shaded.com.google.common.collect.Range;
import java.io.IOException;
import java.lang.reflect.Type;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
    }

    @Override
    @Deprecated
    public boolean isEmpty(Range<?> value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Range<?> value) {
        return value.isEmpty();
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer<?> cs;
        if (this._endpointSerializer == null) {
            JavaType endpointType = this._rangeType.containedTypeOrUnknown(0);
            if (endpointType != null && !endpointType.hasRawClass(Object.class)) {
                JsonSerializer<Object> ser = prov.findValueSerializer(endpointType, property);
                return new RangeSerializer(this._rangeType, ser);
            }
        } else if (this._endpointSerializer instanceof ContextualSerializer && (cs = ((ContextualSerializer)((Object)this._endpointSerializer)).createContextual(prov, property)) != this._endpointSerializer) {
            return new RangeSerializer(this._rangeType, cs);
        }
        return this;
    }

    @Override
    public void serialize(Range<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        gen.writeStartObject();
        this._writeContents(value, gen, provider);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Range<?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(value, gen);
        this._writeContents(value, gen, provider);
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonObjectFormatVisitor objectVisitor;
        if (visitor != null && (objectVisitor = visitor.expectObjectFormat(typeHint)) != null && this._endpointSerializer != null) {
            JavaType endpointType = this._rangeType.containedType(0);
            JavaType btType = visitor.getProvider().constructType((Type)((Object)BoundType.class));
            JsonSerializer<Object> btSer = visitor.getProvider().findValueSerializer(btType, null);
            objectVisitor.property("lowerEndpoint", this._endpointSerializer, endpointType);
            objectVisitor.property("lowerBoundType", btSer, btType);
            objectVisitor.property("upperEndpoint", this._endpointSerializer, endpointType);
            objectVisitor.property("upperBoundType", btSer, btType);
        }
    }

    private void _writeContents(Range<?> value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (value.hasLowerBound()) {
            if (this._endpointSerializer != null) {
                g.writeFieldName("lowerEndpoint");
                this._endpointSerializer.serialize(value.lowerEndpoint(), g, provider);
            } else {
                provider.defaultSerializeField("lowerEndpoint", value.lowerEndpoint(), g);
            }
            g.writeStringField("lowerBoundType", value.lowerBoundType().name());
        }
        if (value.hasUpperBound()) {
            if (this._endpointSerializer != null) {
                g.writeFieldName("upperEndpoint");
                this._endpointSerializer.serialize(value.upperEndpoint(), g, provider);
            } else {
                provider.defaultSerializeField("upperEndpoint", value.upperEndpoint(), g);
            }
            g.writeStringField("upperBoundType", value.upperBoundType().name());
        }
    }
}

