/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.spotify.docker.client.messages.swarm.AutoValue_ServiceSpec;
import com.spotify.docker.client.messages.swarm.EndpointSpec;
import com.spotify.docker.client.messages.swarm.NetworkAttachmentConfig;
import com.spotify.docker.client.messages.swarm.ServiceMode;
import com.spotify.docker.client.messages.swarm.TaskSpec;
import com.spotify.docker.client.messages.swarm.UpdateConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ServiceSpec {
    @Nullable
    @JsonProperty(value="Name")
    public abstract String name();

    @Nullable
    @JsonProperty(value="Labels")
    public abstract ImmutableMap<String, String> labels();

    @JsonProperty(value="TaskTemplate")
    public abstract TaskSpec taskTemplate();

    @Nullable
    @JsonProperty(value="Mode")
    public abstract ServiceMode mode();

    @Nullable
    @JsonProperty(value="UpdateConfig")
    public abstract UpdateConfig updateConfig();

    @Nullable
    @JsonProperty(value="Networks")
    public abstract ImmutableList<NetworkAttachmentConfig> networks();

    @Nullable
    @JsonProperty(value="EndpointSpec")
    public abstract EndpointSpec endpointSpec();

    public static Builder builder() {
        return new AutoValue_ServiceSpec.Builder();
    }

    @JsonCreator
    static ServiceSpec create(@JsonProperty(value="Name") String name, @JsonProperty(value="Labels") Map<String, String> labels, @JsonProperty(value="TaskTemplate") TaskSpec taskTemplate, @JsonProperty(value="Mode") ServiceMode mode, @JsonProperty(value="UpdateConfig") UpdateConfig updateConfig, @JsonProperty(value="Networks") List<NetworkAttachmentConfig> networks, @JsonProperty(value="EndpointSpec") EndpointSpec endpointSpec) {
        Builder builder = ServiceSpec.builder().name(name).labels(labels).taskTemplate(taskTemplate).mode(mode).updateConfig(updateConfig).endpointSpec(endpointSpec);
        if (labels != null) {
            builder.labels(labels);
        }
        if (networks != null) {
            builder.networks(networks);
        }
        return builder.build();
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        @Deprecated
        public Builder withName(String name) {
            this.name(name);
            return this;
        }

        abstract ImmutableMap.Builder<String, String> labelsBuilder();

        public Builder addLabel(String label, String value) {
            this.labelsBuilder().put(label, value);
            return this;
        }

        @Deprecated
        public Builder withLabel(String label, String value) {
            this.addLabel(label, value);
            return this;
        }

        public abstract Builder labels(Map<String, String> var1);

        @Deprecated
        public Builder withLabels(Map<String, String> labels) {
            this.labels(labels);
            return this;
        }

        public abstract Builder taskTemplate(TaskSpec var1);

        @Deprecated
        public Builder withTaskTemplate(TaskSpec taskTemplate) {
            this.taskTemplate(taskTemplate);
            return this;
        }

        public abstract Builder mode(ServiceMode var1);

        @Deprecated
        public Builder withServiceMode(ServiceMode mode) {
            this.mode(mode);
            return this;
        }

        public abstract Builder updateConfig(UpdateConfig var1);

        @Deprecated
        public Builder withUpdateConfig(UpdateConfig updateConfig) {
            this.updateConfig(updateConfig);
            return this;
        }

        public abstract Builder networks(NetworkAttachmentConfig ... var1);

        public abstract Builder networks(List<NetworkAttachmentConfig> var1);

        @Deprecated
        public Builder withNetworks(NetworkAttachmentConfig ... networks) {
            this.networks(networks);
            return this;
        }

        @Deprecated
        public Builder withNetworks(List<NetworkAttachmentConfig> networks) {
            this.networks(networks);
            return this;
        }

        public abstract Builder endpointSpec(EndpointSpec var1);

        @Deprecated
        public Builder withEndpointSpec(EndpointSpec endpointSpec) {
            this.endpointSpec(endpointSpec);
            return this;
        }

        public abstract ServiceSpec build();
    }
}

