/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.UIAutomatorRemoteAndroidTestRunner;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.AndroidTestRunListener;
import com.simpligility.maven.plugins.android.DeviceCallback;
import com.simpligility.maven.plugins.android.ScreenshotServiceWrapper;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.UIAutomator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="uiautomator", requiresProject=false)
public class UIAutomatorMojo
extends AbstractAndroidMojo {
    @Parameter(property="maven.test.skip", defaultValue="false", readonly=true)
    private boolean mavenTestSkip;
    @Parameter(property="skipTests", defaultValue="false", readonly=true)
    private boolean mavenSkipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false", readonly=true)
    private boolean mavenTestFailureIgnore;
    @Parameter(property="testFailureIgnore", defaultValue="false", readonly=true)
    private boolean mavenIgnoreTestFailure;
    @ConfigPojo
    @Parameter
    private UIAutomator uiautomator;
    @Parameter(property="android.uiautomator.skip")
    private Boolean uiautomatorSkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @Parameter(property="android.uiautomator.jarFile")
    private String uiautomatorJarFile;
    @PullParameter(defaultValueGetterMethod="getJarFile")
    private String parsedJarFile;
    @Parameter(property="android.uiautomator.testClassOrMethod")
    private String[] uiautomatorTestClassOrMethods;
    @PullParameter(required=false, defaultValueGetterMethod="getTestClassOrMethods")
    private String[] parsedTestClassOrMethods;
    @Parameter(property="android.uiautomator.noHup")
    private Boolean uiautomatorNoHup;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedNoHup;
    @Parameter(property="android.uiautomator.debug")
    private Boolean uiautomatorDebug = false;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedDebug;
    @Parameter(property="android.uiautomator.useDump")
    private Boolean uiautomatorUseDump;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedUseDump;
    @Parameter(property="android.uiautomator.dumpFilePath")
    private String uiautomatorDumpFilePath;
    @PullParameter(required=false, defaultValue={"/storage/sdcard0/window_dump.xml"})
    private String parsedDumpFilePath;
    @Parameter(property="android.uiautomator.createReport")
    private Boolean uiautomatorCreateReport;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedCreateReport;
    @Parameter(property="android.uiautomator.reportSuffix")
    private String uiautomatorReportSuffix;
    @PullParameter(required=false, defaultValueGetterMethod="getReportSuffix")
    private String parsedReportSuffix;
    @Parameter(property="android.uiautomator.takeScreenshotOnFailure")
    private Boolean uiautomatorTakeScreenshotOnFailure;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedTakeScreenshotOnFailure;
    @Parameter(property="android.uiautomator.screenshotsPathOnDevice")
    private String uiautomatorScreenshotsPathOnDevice;
    @PullParameter(required=false, defaultValue={"/sdcard/uiautomator-screenshots/"})
    private String parsedScreenshotsPathOnDevice;
    @Parameter(property="android.uiautomator.propertiesKeyPrefix")
    private String uiautomatorPropertiesKeyPrefix;
    @PullParameter(required=false, defaultValueGetterMethod="getPropertiesKeyPrefix")
    private String parsedPropertiesKeyPrefix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        if (this.isEnableIntegrationTest()) {
            this.playTests();
        }
    }

    protected boolean isEnableIntegrationTest() {
        return this.parsedSkip == false && !this.mavenTestSkip && !this.mavenSkipTests;
    }

    protected boolean isIgnoreTestFailures() {
        return this.mavenIgnoreTestFailure || this.mavenTestFailureIgnore;
    }

    protected void playTests() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Parsed values for Android UI UIAutomator invocation: ");
        this.getLog().debug((CharSequence)("jarFile:" + this.parsedJarFile));
        String testClassOrMethodString = UIAutomatorMojo.buildSpaceSeparatedString(this.parsedTestClassOrMethods);
        this.getLog().debug((CharSequence)("testClassOrMethod:" + testClassOrMethodString));
        this.getLog().debug((CharSequence)("createReport:" + this.parsedCreateReport));
        DeviceCallback instrumentationTestExecutor = new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                UIAutomatorRemoteAndroidTestRunner automatorRemoteAndroidTestRunner = new UIAutomatorRemoteAndroidTestRunner(UIAutomatorMojo.this.parsedJarFile, device);
                automatorRemoteAndroidTestRunner.setRunName("ui uiautomator tests");
                automatorRemoteAndroidTestRunner.setDebug(UIAutomatorMojo.this.uiautomatorDebug);
                automatorRemoteAndroidTestRunner.setTestClassOrMethods(UIAutomatorMojo.this.parsedTestClassOrMethods);
                automatorRemoteAndroidTestRunner.setNoHup(UIAutomatorMojo.this.parsedNoHup);
                automatorRemoteAndroidTestRunner.setUserProperties(UIAutomatorMojo.this.session.getUserProperties(), UIAutomatorMojo.this.parsedPropertiesKeyPrefix);
                if (UIAutomatorMojo.this.parsedUseDump.booleanValue()) {
                    automatorRemoteAndroidTestRunner.setDumpFilePath(UIAutomatorMojo.this.parsedDumpFilePath);
                }
                UIAutomatorMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Running ui uiautomator tests in" + UIAutomatorMojo.this.parsedJarFile));
                try {
                    AndroidTestRunListener testRunListener = new AndroidTestRunListener(UIAutomatorMojo.this.project, device, UIAutomatorMojo.this.getLog(), UIAutomatorMojo.this.parsedCreateReport, UIAutomatorMojo.this.parsedTakeScreenshotOnFailure, UIAutomatorMojo.this.parsedScreenshotsPathOnDevice, UIAutomatorMojo.this.parsedReportSuffix, UIAutomatorMojo.this.targetDirectory);
                    automatorRemoteAndroidTestRunner.run(testRunListener);
                    if (testRunListener.hasFailuresOrErrors() && !UIAutomatorMojo.this.isIgnoreTestFailures()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Tests failed on device.");
                    }
                    if (testRunListener.testRunFailed()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Test run failed to complete: " + testRunListener.getTestRunFailureCause());
                    }
                    if (testRunListener.threwException() && !UIAutomatorMojo.this.isIgnoreTestFailures()) {
                        throw new MojoFailureException(deviceLogLinePrefix + testRunListener.getExceptionMessages());
                    }
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "timeout", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "adb command rejected", (Exception)((Object)e));
                }
                catch (ShellCommandUnresponsiveException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "shell command " + "unresponsive", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "IO problem", (Exception)e);
                }
            }
        };
        instrumentationTestExecutor = new ScreenshotServiceWrapper(instrumentationTestExecutor, this.project, this.getLog());
        this.doWithDevices(instrumentationTestExecutor);
    }

    private String getJarFile() {
        if (this.parsedJarFile == null) {
            File jarFilePath = new File(this.targetDirectory + File.separator + this.finalName + ".jar");
            return jarFilePath.getName();
        }
        return this.parsedJarFile;
    }

    private String[] getTestClassOrMethods() {
        return this.parsedTestClassOrMethods;
    }

    private String getReportSuffix() {
        return this.parsedReportSuffix;
    }

    private String getPropertiesKeyPrefix() {
        return this.parsedPropertiesKeyPrefix;
    }

    protected static String buildSpaceSeparatedString(String[] lines) {
        if (lines == null || lines.length == 0) {
            return null;
        }
        return StringUtils.join((Object[])lines, (String)" ");
    }
}

