/**
 * Sencha GXT 3.1.1 - Sencha for GWT
 * Copyright(c) 2007-2014, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://www.sencha.com/products/gxt/license/
 */
package com.sencha.gxt.chart.client.draw.engine;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.dom.client.Element;
import com.sencha.gxt.chart.client.draw.Surface;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.core.client.dom.XElement;

public abstract class DomSurface extends Surface {

  protected Map<Sprite, XElement> elements = new HashMap<Sprite, XElement>();
  protected Map<Sprite, String> spriteIds = new HashMap<Sprite, String>();

  /**
   * Assigns an ID to be set in the sprite's dom element once it has been created. Only makes sense Surface 
   * implementations that are built using a dom. Requires the sprite to be rendered or re-rendered to take effect.
   * 
   * @see Element#setId(String)
   * @param sprite the sprite
   * @param id the id to set.
   */
  public void setId(Sprite sprite, String id) {
    spriteIds.put(sprite, id);
  }

  /**
   * Returns the DOM element associated with the given sprite.
   * 
   * @param sprite the sprite
   * @return the DOM element
   */
  protected XElement getElement(Sprite sprite) {
    return elements.get(sprite);
  }

  /**
   * Associates the given sprite with the given dom element.
   * 
   * @param sprite the sprite
   * @param element the dom element
   */
  protected void setElement(Sprite sprite, XElement element) {
    elements.put(sprite, element);
  }

  @Override
  public void deleteSprite(Sprite sprite) {
    super.deleteSprite(sprite);
    if (surfaceElement != null) {
      //TODO - when chart sets shadow to false, elements are created, but not added to DOM.  element is null
      Element spriteElement = getElement(sprite);
      if (spriteElement != null) {
        surfaceElement.removeChild(spriteElement);
      }
    }
    elements.remove(sprite);
    spriteIds.remove(sprite);
  }
}
