/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ProcessCSSFilesTask
extends ProcessFilesTask {
    public ProcessCSSFilesTask(Log log, Integer bufferSize, boolean debug, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, String suffix, boolean nosuffix, String charset, int linebreak) {
        super(log, bufferSize, debug, skipMerge, skipMinify, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, suffix, nosuffix, charset, linebreak);
    }

    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        try (FileInputStream in = new FileInputStream(mergedFile);
             FileOutputStream out = new FileOutputStream(minifiedFile);
             InputStreamReader reader = new InputStreamReader((InputStream)in, this.charset);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.charset);){
            this.log.info((CharSequence)("Creating the minified file [" + (this.debug ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
            CssCompressor compressor = new CssCompressor((Reader)reader);
            compressor.compress((Writer)writer, this.linebreak);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Failed to compress the CSS file [" + mergedFile.getName() + "]."), (Throwable)e);
            throw e;
        }
        this.logCompressionGains(mergedFile, minifiedFile);
    }
}

